/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.tupletable.AbstractFilterableTupleTable;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.model.elements.Field;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.EntityTuple;
import org.molgenis.util.tuple.Tuple;

public class EntityTable
extends AbstractFilterableTupleTable {
    private Class<? extends Entity> entityClass;
    private List<Field> columns;
    private Database db;

    public EntityTable(Database database, Class<? extends Entity> entityClass) {
        this.setDb(database);
        if (entityClass == null) {
            throw new NullPointerException("entityClass can't be null");
        }
        this.entityClass = entityClass;
    }

    @Override
    public List<Field> getAllColumns() throws TableException {
        if (this.columns != null) {
            return this.columns;
        }
        try {
            this.columns = this.getDb().getMetaData().getEntity(this.entityClass.getSimpleName()).getAllFields();
            return this.columns;
        }
        catch (Exception e) {
            throw new TableException(e);
        }
    }

    @Override
    public List<Tuple> getRows() {
        try {
            Query<? extends Entity> q = this.getDb().query(this.entityClass);
            if (this.getLimit() > 0) {
                q.limit(this.getLimit());
            }
            if (this.getOffset() > 0) {
                q.offset(this.getOffset());
            }
            if (this.getFilters().size() > 0) {
                q.addRules(this.getFilters().toArray(new QueryRule[this.getFilters().size()]));
            }
            List<? extends Entity> entities = q.find();
            ArrayList<Tuple> result = new ArrayList<Tuple>();
            for (Entity entity : entities) {
                result.add(new EntityTuple(entity));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.getRows().iterator();
    }

    @Override
    public void close() throws TableException {
    }

    @Override
    public int getCount() throws TableException {
        try {
            if (this.getFilters().size() > 0) {
                return this.getDb().count(this.entityClass, this.getFilters().toArray(new QueryRule[this.getFilters().size()]));
            }
            return this.getDb().count(this.entityClass, new QueryRule[0]);
        }
        catch (DatabaseException e) {
            throw new TableException(e);
        }
    }

    public void setDb(Database db) {
        if (db == null) {
            throw new NullPointerException("database cannot be null in setDb(db)");
        }
        this.db = db;
    }

    public Database getDb() {
        return this.db;
    }
}

