/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.framework.tupletable.TupleTableIterator;
import org.molgenis.model.elements.Field;
import org.molgenis.util.tuple.Tuple;

public abstract class AbstractTupleTable
implements TupleTable {
    private int limit = 0;
    private int offset = 0;
    private int colOffset = 0;
    private int colLimit = 0;
    private boolean firstColumnFixed;
    private Map<String, Integer> columnByIndex;

    @Override
    public void reset() {
        this.limit = 0;
        this.offset = 0;
        this.colOffset = 0;
        this.colLimit = 0;
    }

    @Override
    public void setFirstColumnFixed(boolean firstColumnFixed) {
        this.firstColumnFixed = firstColumnFixed;
    }

    @Override
    public boolean isFirstColumnFixed() {
        return this.firstColumnFixed;
    }

    @Override
    public void hideColumn(String columnName) {
        try {
            if (this.isFirstColumnFixed() && this.getAllColumns().get(0).getName().equals(columnName)) {
                return;
            }
            this.getColumnByName(columnName).setHidden(true);
        }
        catch (TableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void showColumn(String columnName) {
        try {
            this.getColumnByName(columnName).setHidden(false);
        }
        catch (TableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Field> getHiddenColumns() {
        try {
            Collection hiddenColumns = Collections2.filter(this.getAllColumns(), (Predicate)new Predicate<Field>(){

                public boolean apply(Field f) {
                    return f.isHidden();
                }
            });
            return new ArrayList<Field>(hiddenColumns);
        }
        catch (TableException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<Field> getVisibleColumns() throws TableException {
        ArrayList<Field> visibleColumns = new ArrayList<Field>();
        for (Field column : this.getAllColumns()) {
            if (column.isHidden()) continue;
            visibleColumns.add(column);
        }
        return visibleColumns;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int limit) {
        if (limit < 0) {
            throw new RuntimeException("limit cannot be < 0");
        }
        this.limit = limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        if (offset < 0) {
            throw new RuntimeException("offset cannot be < 0");
        }
        this.offset = offset;
    }

    @Override
    public abstract List<Field> getAllColumns() throws TableException;

    @Override
    public List<Field> getColumns() throws TableException {
        int colLimit;
        List<Field> columns = this.getVisibleColumns();
        int colCount = columns.size();
        if (this.getColOffset() > colCount) {
            this.setColOffset(colCount);
        }
        if (this.isFirstColumnFixed()) {
            columns.remove(0);
            --colCount;
        }
        int n = colLimit = this.colLimit == 0 ? colCount - this.getColOffset() : this.getCurrentColumnPageSize(colCount);
        List<Field> result = this.getColOffset() > 0 ? (colLimit > 0 ? columns.subList(this.getColOffset(), Math.min(this.getColOffset() + colLimit, colCount)) : columns.subList(this.getColOffset(), colCount)) : (colLimit > 0 ? columns.subList(0, colLimit) : columns);
        if (this.isFirstColumnFixed()) {
            result.add(0, this.getAllColumns().get(0));
        }
        return result;
    }

    @Override
    public List<Tuple> getRows() throws TableException {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (Tuple t : this) {
            result.add(t);
        }
        return result;
    }

    @Override
    public Iterator<Tuple> iterator() {
        try {
            return new TupleTableIterator(this);
        }
        catch (TableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws TableException {
    }

    @Override
    public abstract int getCount() throws TableException;

    @Override
    public int getColCount() throws TableException {
        return this.getVisibleColumns().size();
    }

    @Override
    public void setColLimit(int limit) {
        if (limit < 0) {
            throw new RuntimeException("colLimit cannot be < 0");
        }
        this.colLimit = limit;
    }

    @Override
    public int getColLimit() {
        return this.colLimit;
    }

    @Override
    public int getColOffset() {
        return this.colOffset;
    }

    @Override
    public void setColOffset(int offset) {
        if (offset < 0) {
            throw new RuntimeException("colOffset cannot be < 0");
        }
        this.colOffset = offset;
    }

    @Override
    public void setLimitOffset(int limit, int offset) {
        this.setLimit(limit);
        this.setOffset(offset);
    }

    protected int getCurrentColumnPageSize(int colCount) throws TableException {
        int pageSize = this.getColLimit();
        if (this.getColOffset() + pageSize > colCount) {
            pageSize = colCount - this.getColOffset();
        }
        return pageSize;
    }

    protected Tuple getValues(int row, List<Field> columns) throws TableException {
        return this.getRows().get(row);
    }

    protected int getColumnIndex(String columnName) throws TableException {
        Integer index;
        if (this.columnByIndex == null) {
            this.columnByIndex = new HashMap<String, Integer>();
            List<Field> columns = this.getAllColumns();
            for (int i = 0; i < columns.size(); ++i) {
                this.columnByIndex.put(columns.get(i).getName(), i);
            }
        }
        if ((index = this.columnByIndex.get(columnName)) == null) {
            throw new TableException("Unknown columnName [" + columnName + "]");
        }
        return index;
    }

    protected Field getColumnByName(String columnName) throws TableException {
        for (Field field : this.getAllColumns()) {
            if (!field.getName().equals(columnName)) continue;
            return field;
        }
        throw new TableException("Unknown columnName [" + columnName + "]");
    }

    protected boolean isInViewPort(String columnName) throws TableException {
        for (Field field : this.getColumns()) {
            if (!field.getName().equals(columnName)) continue;
            return true;
        }
        return false;
    }
}

