/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.security.Login;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.ui.ApplicationController;
import org.molgenis.framework.ui.ApplicationModel;
import org.molgenis.framework.ui.EasyPluginController;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;

public abstract class MolgenisGuiService {
    Logger logger = Logger.getLogger(MolgenisGuiService.class);
    protected MolgenisContext mc;
    protected Database db;
    private static long newWindowId;

    public MolgenisGuiService(MolgenisContext mc) {
        this.mc = mc;
    }

    public static long getNewWindowId() {
        return ++newWindowId;
    }

    public abstract ApplicationController createUserInterface();

    public void handleRequest(MolgenisRequest request, MolgenisResponse response) throws DatabaseException, IOException {
        block24: {
            Database db;
            this.db = db = request.getDatabase();
            HttpSession session = request.getRequest().getSession();
            if (request.getRequest().getParameter("__action") != null && request.getRequest().getParameter("__action").equalsIgnoreCase("Logout")) {
                session.setAttribute("application", null);
            }
            ApplicationController appController = (ApplicationController)session.getAttribute("application");
            Login userLogin = request.getDatabase().getLogin();
            if (appController == null) {
                if (!userLogin.isAuthenticated() && userLogin.isLoginRequired() || request.getRequest().getParameter("logout") != null && !session.isNew()) {
                    response.getResponse().setHeader("WWW-Authenticate", "BASIC realm=\"MOLGENIS\"");
                    response.getResponse().sendError(401);
                    session.invalidate();
                    return;
                }
                appController = this.createUserInterface();
            }
            appController.setLogin(userLogin);
            try {
                PrintWriter writer;
                if (ScreenModel.Show.SHOW_JQGRID.equals(request.getString("__show"))) {
                    ScreenController controller = (ScreenController)appController.get(request.getString("__target"));
                    controller.handleRequest(db, request, (OutputStream)response.getResponse().getOutputStream());
                    break block24;
                }
                if ("download".equals(request.getString("__action"))) {
                    int bytes_read;
                    File file = new File(db.getFilesource() + "/" + request.getString("__filename"));
                    FileInputStream filestream = new FileInputStream(file);
                    response.getResponse().setContentType("application/x-download");
                    response.getResponse().setContentLength((int)file.length());
                    response.getResponse().setHeader("Content-Disposition", "attachment; filename=" + request.getString("__filename"));
                    BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getResponse().getOutputStream());
                    byte[] buffer = new byte[1024];
                    while ((bytes_read = filestream.read(buffer)) != -1) {
                        out.write(buffer, 0, bytes_read);
                    }
                    filestream.close();
                    out.flush();
                    out.close();
                    break block24;
                }
                if (!request.isNull("__action") && request.getAction().startsWith("download_json")) {
                    ScreenController controller = (ScreenController)appController.get(request.getString("__target"));
                    response.getResponse().setContentType("application/json");
                    controller.handleRequest(db, request, (OutputStream)response.getResponse().getOutputStream());
                    response.getResponse().getOutputStream().flush();
                    response.getResponse().getOutputStream().close();
                    break block24;
                }
                if (ScreenModel.Show.SHOW_DOWNLOAD.equals(request.getString("__show"))) {
                    ScreenController controller = (ScreenController)appController.get(request.getString("__target"));
                    response.getResponse().setContentType("application/x-download");
                    String action = request.getString("__action");
                    String extension = null;
                    if (action.startsWith("download_txt_")) {
                        extension = "txt";
                    } else if (action.startsWith("download_xls_")) {
                        extension = "xls";
                    } else {
                        throw new Exception("Download type '" + action + "' unsupported!");
                    }
                    response.getResponse().setHeader("Content-Disposition", "attachment; filename=" + controller.getName().toLowerCase() + "." + extension);
                    controller.handleRequest(db, request, (OutputStream)response.getResponse().getOutputStream());
                    response.getResponse().getOutputStream().flush();
                    response.getResponse().getOutputStream().close();
                    break block24;
                }
                if (request.getString("select") != null) {
                    ScreenController toBeSelected = (ScreenController)appController.get(request.getString("select"));
                    try {
                        ((ScreenController)toBeSelected.getParent()).setSelected(request.getString("select"));
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                }
                if (ScreenModel.Show.SHOW_CLOSE.equals((Object)appController.handleRequest(db, request, null))) {
                    writer = response.getResponse().getWriter();
                    writer.write("<html><head></head><body><script>window.close();</script></body></html>");
                    writer.close();
                    return;
                }
                if (EasyPluginController.HTML_WAS_ALREADY_SERVED != null && EasyPluginController.HTML_WAS_ALREADY_SERVED.booleanValue()) {
                    EasyPluginController.HTML_WAS_ALREADY_SERVED = null;
                    return;
                }
                appController.reload(db);
                session.setAttribute("application", (Object)appController);
                response.getResponse().setContentType("text/html;charset=UTF-8");
                writer = response.getResponse().getWriter();
                String show = request.getString("__show");
                if (ScreenModel.Show.SHOW_DIALOG.equals(show)) {
                    ((ApplicationModel)appController.getModel()).setShow(show);
                    ScreenController target = (ScreenController)appController.get(request.getString("__target"));
                    ((ApplicationModel)appController.getModel()).setTarget(target);
                    writer.write(appController.render());
                } else if ("massupdate".equals(show)) {
                    ((ApplicationModel)appController.getModel()).setShow("show");
                    writer.write(appController.render());
                } else {
                    ((ApplicationModel)appController.getModel()).setShow("root");
                    writer.write(appController.render());
                    if (request.getString("__comebacktoscreen") != null) {
                        ScreenController toBeSelected = (ScreenController)appController.get(request.getString("__comebacktoscreen"));
                        ((ScreenController)toBeSelected.getParent()).setSelected(request.getString("__comebacktoscreen"));
                    }
                }
                writer.close();
                appController.clearAllMessages();
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
    }
}

