/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.server.MolgenisService;
import org.molgenis.util.Entity;

public class MolgenisDataTableService
implements MolgenisService {
    Logger logger = Logger.getLogger(MolgenisDataTableService.class);

    public MolgenisDataTableService(MolgenisContext mc) {
    }

    @Override
    public void handleRequest(MolgenisRequest req, MolgenisResponse res) throws ParseException, DatabaseException, IOException {
        HttpServletResponse response = res.getResponse();
        try {
            boolean asc;
            response.setHeader("Cache-Control", "max-age=0");
            response.setContentType("application/json");
            if (req.isNull("entity")) {
                throw new Exception("required parameter 'entity' is missing");
            }
            Class<? extends Entity> entityClass = req.getDatabase().getClassForName(req.getString("entity"));
            int iDisplayLength = 10;
            if (!req.isNull("iDisplayLength")) {
                iDisplayLength = req.getInt("iDisplayLength");
            }
            int iDisplayStart = 0;
            if (!req.isNull("iDisplayStart")) {
                iDisplayStart = req.getInt("iDisplayStart");
            }
            Database db = req.getDatabase();
            Query<? extends Entity> q = db.query(entityClass);
            String sortField = req.getString("mDataProp_" + req.getString("iSortCol_0"));
            boolean bl = asc = "asc".equals(req.getString("sSortDir_0"));
            if (asc) {
                q.sortASC(sortField);
            } else {
                q.sortDESC(sortField);
            }
            int count = q.count();
            if (!"".equals(req.getString("sSearch"))) {
                q.search(req.getString("sSearch"));
            }
            int filteredCount = q.count();
            q.offset(iDisplayStart);
            q.limit(iDisplayLength);
            List<? extends Entity> result = q.find();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("sEcho", req.getString("sEcho"));
            jsonObject.addProperty("iTotalRecords", (Number)count);
            jsonObject.addProperty("iTotalDisplayRecords", (Number)filteredCount);
            JsonArray jsonArray = new JsonArray();
            for (Entity entity : result) {
                JsonObject jsonValues = new JsonObject();
                for (String field : entity.getFields()) {
                    if (entity.get(field) != null) {
                        jsonValues.addProperty(field, entity.get(field).toString());
                        continue;
                    }
                    jsonValues.addProperty(field, "");
                }
                jsonArray.add((JsonElement)jsonValues);
            }
            jsonObject.add("aaData", (JsonElement)jsonArray);
            String json = jsonObject.toString();
            this.logger.debug((Object)json);
            PrintWriter printWriter = response.getWriter();
            System.out.println("json\n" + json);
            printWriter.print(json);
            printWriter.close();
        }
        catch (Exception e) {
            PrintWriter out = response.getWriter();
            response.getWriter().print("{exception: '" + e.getMessage() + "'}");
            out.close();
            e.printStackTrace();
            throw new DatabaseException(e);
        }
    }
}

