/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.server.MolgenisService;
import org.molgenis.framework.server.services.CleanTmpDirJob;
import org.molgenis.framework.server.services.CleanTmpDirTask;
import org.molgenis.services.SchedulingService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class MolgenisCleanTmpDirServiceQuartz
implements MolgenisService {
    Logger logger = Logger.getLogger(MolgenisCleanTmpDirServiceQuartz.class);

    public MolgenisCleanTmpDirServiceQuartz(MolgenisContext mc) {
        try {
            CleanTmpDirTask task = new CleanTmpDirTask();
            JobDetail job = new JobDetail();
            job.setName("cleanTmpDirJob");
            job.setJobClass(CleanTmpDirJob.class);
            JobDataMap dataMap = job.getJobDataMap();
            dataMap.put("cleanTmpDirTask", task);
            SimpleTrigger trigger = new SimpleTrigger();
            trigger.setName("runMeJobTesting");
            trigger.setStartTime(new Date(System.currentTimeMillis() + 1000L));
            trigger.setRepeatCount(-1);
            trigger.setRepeatInterval(30000L);
            Trigger t = TriggerUtils.makeMinutelyTrigger();
            t.setStartTime(new Date());
            t.setName("MolgenisCleanTmpDirServiceTrigger");
            SchedulingService schedulingService = mc.getSchedulingService();
            HashMap<Object, Object> dataMap2 = new HashMap<Object, Object>();
            schedulingService.scheduleOnce(dataMap2, CleanTmpDirJob.class);
            System.out.println("MolgenisCleanTmpDirService initialized.");
        }
        catch (SchedulerException e) {
            System.err.println("FATAL EXCEPTION: failure in starting MolgenisCleanTmpDirService.");
            e.printStackTrace();
            System.exit(0);
        }
    }

    @Override
    public void handleRequest(MolgenisRequest request, MolgenisResponse response) throws ParseException, DatabaseException, IOException {
        throw new IOException("This service does not accept requests.");
    }
}

