/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import JSci.maths.ArrayMath;
import JSci.maths.statistics.NormalDistribution;
import java.io.IOException;
import java.util.Arrays;
import umcg.genetica.math.matrix.DoubleMatrixDataset;

public class FDRUtils {
    private static NormalDistribution normDist;

    private FDRUtils() {
        normDist = null;
    }

    public static double getGlobalThreshold(double[][] real, double[][] permuted, double fdr, CloneArrays c, SortArrays s, AbsoluteValues a) {
        double[][][] perm3d = new double[][][]{permuted};
        return FDRUtils.getGlobalThreshold(real, perm3d, fdr, c, s, a);
    }

    public static int[] getNrSignificant(double[][] data, double threshold, SortArrays s, AbsoluteValues a) {
        switch (s) {
            case SORT_DESCENDING: {
                data = FDRUtils.sortDesc(data);
            }
        }
        switch (a) {
            case USE_ABSOLUTE: {
                data = ArrayMath.abs((double[][])data);
            }
        }
        int[] nrSignificant = new int[data.length];
        for (int gene = 0; gene < data.length; ++gene) {
            for (int term = 0; term < data[0].length && FDRUtils.zToP(data[gene][term]) < threshold; ++term) {
                int n = gene;
                nrSignificant[n] = nrSignificant[n] + 1;
            }
        }
        return nrSignificant;
    }

    public static double zToP(double z) {
        double p;
        if (normDist == null) {
            normDist = new NormalDistribution();
        }
        if ((p = z > 0.0 ? normDist.cumulative(-z) : normDist.cumulative(z)) > 0.5) {
            p = 1.0 - p;
        }
        return p *= 2.0;
    }

    public static double getGlobalThreshold(double[][] real, double[][][] permuted, double fdr, CloneArrays c, SortArrays s, AbsoluteValues a) {
        FDRUtils.checkNulls(real, permuted);
        FDRUtils.checkSizes(real, permuted);
        FDRUtils.checkFDR(fdr);
        int nrPermutations = permuted.length;
        double[][] realData = real;
        double[][][] permData = permuted;
        switch (c) {
            case CLONE_BOTH: {
                realData = (double[][])real.clone();
                permData = (double[][][])permuted.clone();
                break;
            }
            case CLONE_REAL: {
                realData = (double[][])real.clone();
            }
        }
        switch (s) {
            case SORT_DESCENDING: {
                realData = FDRUtils.sortDesc(realData);
                permData = FDRUtils.sortDesc(permData);
            }
        }
        switch (a) {
            case USE_ABSOLUTE: {
                realData = ArrayMath.abs((double[][])realData);
                for (int p = 0; p < nrPermutations; ++p) {
                    permData[p] = ArrayMath.abs((double[][])permData[p]);
                }
                break;
            }
        }
        double threshold = -1.0;
        int nrSignificantInReal = 0;
        int nrSignificantInPerm = 0;
        int[] realColsTraversed = new int[realData.length];
        int[][] permColsTraversed = new int[nrPermutations][realData.length];
        double foundFDR = -1.0;
        while (foundFDR < fdr) {
            double realThreshold = 0.0;
            int nextMaxRow = -1;
            for (int i = 0; i < realColsTraversed.length; ++i) {
                if (realData[i][realColsTraversed[i]] > realThreshold) {
                    realThreshold = realData[i][realColsTraversed[i]];
                    nextMaxRow = i;
                }
                if (realColsTraversed[i] == 0) break;
            }
            int n = nextMaxRow;
            realColsTraversed[n] = realColsTraversed[n] + 1;
            ++nrSignificantInReal;
            block13: for (int p = 0; p < nrPermutations; ++p) {
                for (int i = 0; i < permColsTraversed[0].length; ++i) {
                    while (permData[p][i][permColsTraversed[p][i]] > realThreshold) {
                        ++nrSignificantInPerm;
                        int[] nArray = permColsTraversed[p];
                        int n2 = i;
                        nArray[n2] = nArray[n2] + 1;
                    }
                    if (permColsTraversed[p][i] == 0) continue block13;
                }
            }
            foundFDR = (double)nrSignificantInPerm / (double)nrPermutations / (double)nrSignificantInReal;
            if (!(foundFDR <= fdr)) continue;
            threshold = realThreshold;
        }
        return threshold;
    }

    public static double[] getThresholdsPerRow(double[][] real, double[][] permuted, double fdr, CloneArrays c, SortArrays s, AbsoluteValues a) {
        double[][][] perm3d = new double[][][]{permuted};
        return FDRUtils.getThresholdsPerRow(real, perm3d, fdr, c, s, a);
    }

    public static double[] getThresholdsPerRow(double[][] real, double[][][] permuted, double fdr, CloneArrays c, SortArrays s, AbsoluteValues a) {
        FDRUtils.checkNulls(real, permuted);
        FDRUtils.checkSizes(real, permuted);
        FDRUtils.checkFDR(fdr);
        int nrPermutations = permuted.length;
        double[][] realData = real;
        double[][][] permData = permuted;
        switch (c) {
            case CLONE_BOTH: {
                realData = (double[][])real.clone();
                permData = (double[][][])permuted.clone();
                break;
            }
            case CLONE_REAL: {
                realData = (double[][])real.clone();
            }
        }
        switch (a) {
            case USE_ABSOLUTE: {
                realData = ArrayMath.abs((double[][])realData);
                for (int p = 0; p < nrPermutations; ++p) {
                    permData[p] = ArrayMath.abs((double[][])permData[p]);
                }
                break;
            }
        }
        double[] thresholds = new double[realData.length];
        for (int row = 0; row < realData.length; ++row) {
            if (s == SortArrays.SORT_DESCENDING) {
                Arrays.sort(realData[row]);
                realData[row] = ArrayMath.invert((double[])realData[row]);
                for (int p = 0; p < nrPermutations; ++p) {
                    Arrays.sort(permData[p][row]);
                    permData[p][row] = ArrayMath.invert((double[])permData[p][row]);
                }
            }
            double[] thresholdPerm = new double[nrPermutations];
            double foundFDR = 1.0;
            block10: for (int p = 0; p < nrPermutations; ++p) {
                int nrSignificantInReal = 0;
                thresholdPerm[p] = realData[row][0];
                for (int i = 0; i < realData[0].length; ++i) {
                    double currentThreshold = realData[row][i];
                    ++nrSignificantInReal;
                    int nrSignificantInPerm = 0;
                    for (int j = 0; j < permData[0][0].length && permData[p][row][j] > currentThreshold; ++j) {
                        ++nrSignificantInPerm;
                    }
                    foundFDR = nrSignificantInPerm / nrSignificantInReal;
                    if (foundFDR > fdr) continue block10;
                    thresholdPerm[p] = currentThreshold;
                }
            }
            Arrays.sort(thresholdPerm);
            thresholds[row] = thresholdPerm[(int)(0.8 * (double)nrPermutations) - 1];
        }
        return thresholds;
    }

    public static int[] getNrSignificant(double[][] data, double[] thresholds, CloneArrays c, SortArrays s, AbsoluteValues a) {
        int row;
        int[] nrSignificant = new int[thresholds.length];
        double[][] realData = data;
        switch (c) {
            case CLONE_BOTH: {
                realData = (double[][])data.clone();
                break;
            }
            case CLONE_REAL: {
                realData = (double[][])data.clone();
            }
        }
        switch (a) {
            case USE_ABSOLUTE: {
                realData = ArrayMath.abs((double[][])realData);
            }
        }
        if (s == SortArrays.SORT_DESCENDING) {
            for (row = 0; row < realData.length; ++row) {
                Arrays.sort(realData[row]);
                realData[row] = ArrayMath.invert((double[])realData[row]);
            }
        }
        for (row = 0; row < realData.length; ++row) {
            int nrSignificantThisRow = 0;
            for (int i = 0; i < realData[0].length; ++i) {
                if (!(realData[row][i] >= thresholds[row])) continue;
                ++nrSignificantThisRow;
            }
            nrSignificant[row] = nrSignificantThisRow;
        }
        return nrSignificant;
    }

    public static double[] getThresholdsPerRow(double[][] real, String[] permutedFiles, double fdr, double mvp, CloneArrays c, SortArrays s, AbsoluteValues a) throws IOException {
        FDRUtils.checkFDR(fdr);
        int nrPermutations = permutedFiles.length;
        double[][] realData = real;
        switch (c) {
            case CLONE_BOTH: {
                realData = (double[][])real.clone();
                break;
            }
            case CLONE_REAL: {
                realData = (double[][])real.clone();
            }
        }
        switch (a) {
            case USE_ABSOLUTE: {
                realData = ArrayMath.abs((double[][])realData);
            }
        }
        double[] thresholds = new double[realData.length];
        if (s == SortArrays.SORT_DESCENDING) {
            for (int row = 0; row < realData.length; ++row) {
                Arrays.sort(realData[row]);
                realData[row] = ArrayMath.invert((double[])realData[row]);
            }
        }
        double[][] thresholdRowPerm = new double[realData.length][nrPermutations];
        for (int p = 0; p < nrPermutations; ++p) {
            System.out.println("Processing permutation " + p);
            DoubleMatrixDataset permDataset = new DoubleMatrixDataset(permutedFiles[p]);
            double[][] permData = permDataset.getRawDataTransposed();
            if (a == AbsoluteValues.USE_ABSOLUTE) {
                permData = ArrayMath.abs((double[][])permData);
            }
            double foundFDR = 1.0;
            block9: for (int row = 0; row < realData.length; ++row) {
                if (s == SortArrays.SORT_DESCENDING) {
                    Arrays.sort(permData[row]);
                    permData[row] = ArrayMath.invert((double[])permData[row]);
                }
                int nrSignificantInReal = 0;
                thresholdRowPerm[row][p] = Double.MAX_VALUE;
                for (int i = 0; i < realData[0].length; ++i) {
                    double currentThreshold = realData[row][i];
                    ++nrSignificantInReal;
                    int nrSignificantInPerm = 0;
                    for (int j = 0; j < permData[0].length && permData[row][j] > currentThreshold; ++j) {
                        ++nrSignificantInPerm;
                    }
                    foundFDR = (double)nrSignificantInPerm / (double)nrSignificantInReal;
                    if (row == 16846) {
                        // empty if block
                    }
                    if (foundFDR > fdr) continue block9;
                    thresholdRowPerm[row][p] = currentThreshold;
                }
            }
        }
        for (int row = 0; row < realData.length; ++row) {
            Arrays.sort(thresholdRowPerm[row]);
            thresholds[row] = thresholdRowPerm[row][(int)(mvp * (double)nrPermutations) - 1];
        }
        return thresholds;
    }

    private static double[][] sortDesc(double[][] array) {
        int i;
        for (i = 0; i < array.length; ++i) {
            Arrays.sort(array[i]);
            array[i] = ArrayMath.invert((double[])array[i]);
        }
        array = ArrayMath.transpose((double[][])array);
        for (i = 0; i < array.length; ++i) {
            Arrays.sort(array[i]);
            array[i] = ArrayMath.invert((double[])array[i]);
        }
        array = ArrayMath.transpose((double[][])array);
        return array;
    }

    private static double[][][] sortDesc(double[][][] array) {
        for (int p = 0; p < array.length; ++p) {
            int i;
            for (i = 0; i < array[p].length; ++i) {
                Arrays.sort(array[p][i]);
                array[p][i] = ArrayMath.invert((double[])array[p][i]);
            }
            array[p] = ArrayMath.transpose((double[][])array[p]);
            for (i = 0; i < array[p].length; ++i) {
                Arrays.sort(array[p][i]);
                array[p][i] = ArrayMath.invert((double[])array[p][i]);
            }
            array[p] = ArrayMath.transpose((double[][])array[p]);
        }
        return array;
    }

    private static void checkNulls(double[][] real, double[][][] permuted) {
        if (real == null) {
            throw new IllegalArgumentException("Null real data given.");
        }
        if (permuted == null) {
            throw new IllegalArgumentException("Null permuted data given.");
        }
        for (int i = 0; i < permuted.length; ++i) {
            if (permuted[i] != null) continue;
            throw new IllegalArgumentException("Null permuted data given at index " + i + ".");
        }
    }

    private static void checkSizes(double[][] real, double[][][] permuted) {
        if (real.length != permuted[0].length || real[0].length != permuted[0][0].length) {
            throw new IllegalArgumentException("Matrix sizes (real and permuted) must be the same. Real: " + real.length + " x " + real[0].length + ", permuted: " + permuted[0].length + " x " + permuted[0][0].length);
        }
    }

    private static void checkFDR(double fdr) {
        if (fdr < Double.MIN_VALUE || fdr >= 1.0) {
            throw new IllegalArgumentException("FDR must be larger than 0 and smaller than 1: " + fdr);
        }
    }

    public static enum AbsoluteValues {
        USE_ABSOLUTE,
        USE_AS_IS;

    }

    public static enum SortArrays {
        SORT_DESCENDING,
        ALREADY_SORTED_DESCENDING;

    }

    public static enum CloneArrays {
        CLONE_BOTH,
        DONT_CLONE,
        CLONE_REAL;

    }
}

