/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class SymmetricByteDistanceMatrix {
    private int size;
    private byte[] matrix;
    private static final double eLog10 = Math.log(10.0);
    private static final int MAX_ALL_PAIRS_STEPS = 100;
    public static final int MAX_VALUE = 255;
    private long[] elementIndex;
    public boolean loadSuccess = false;

    public SymmetricByteDistanceMatrix(int size) {
        this.size = size;
        long arraySize = (long)size * (long)(size + 1) / 2L;
        this.matrix = new byte[(int)arraySize];
        this.elementIndex = new long[size];
        for (int x = 0; x < size; ++x) {
            this.elementIndex[x] = (long)x * (long)size - (long)x * (long)(x + 1) / 2L;
        }
        this.setMaxDistance();
    }

    public SymmetricByteDistanceMatrix(int size, boolean setMaxDistance) {
        this.size = size;
        long arraySize = (long)size * (long)(size + 1) / 2L;
        this.matrix = new byte[(int)arraySize];
        this.elementIndex = new long[size];
        for (int x = 0; x < size; ++x) {
            this.elementIndex[x] = (long)x * (long)size - (long)x * (long)(x + 1) / 2L;
        }
        if (setMaxDistance) {
            this.setMaxDistance();
        }
    }

    public void dispose() {
        this.size = 0;
        this.matrix = null;
        this.elementIndex = null;
    }

    public void setAllElements(int value) {
        for (int m = 0; m < this.matrix.length; ++m) {
            this.matrix[m] = (byte)(value - 128);
        }
    }

    private void setMaxDistance() {
        for (int m = 0; m < this.matrix.length; ++m) {
            this.matrix[m] = 127;
        }
    }

    private long getElement(int x, int y) {
        if (x > y) {
            return this.elementIndex[y] + (long)x;
        }
        return this.elementIndex[x] + (long)y;
    }

    public void set(int x, int y, int value) {
        this.matrix[(int)this.getElement((int)x, (int)y)] = (byte)(value - 128);
    }

    public int get(int x, int y) {
        return this.matrix[(int)this.getElement(x, y)] + 128;
    }

    public int size() {
        return this.size;
    }

    public int maxValue() {
        return 255;
    }

    public void getAllPairsShortestPath() {
        int previousPercentage = 0;
        for (int i = 0; i < this.size() && i < 100; ++i) {
            for (int v = 0; v < this.size(); ++v) {
                for (int w = v; w < this.size(); ++w) {
                    if (this.get(v, i) == this.maxValue() || this.get(i, w) == this.maxValue()) continue;
                    this.set(v, w, (short)Math.min(this.get(v, w), this.get(v, i) + this.get(i, w)));
                }
            }
            int percentage = (int)(100.0 * (double)i / (double)this.size());
            if (percentage != previousPercentage) {
                System.out.print(percentage + "% ");
            }
            previousPercentage = percentage;
            System.out.print(".");
        }
        System.out.println("");
        for (int v = 0; v < this.size(); ++v) {
            this.set(v, v, 0);
        }
    }

    public Vector getShortestPath(int x, int y) {
        int i;
        Vector<Integer> path = new Vector<Integer>();
        boolean[] traversed = new boolean[this.size()];
        int[][] T = new int[2][this.size()];
        for (i = 0; i < this.size(); ++i) {
            traversed[i] = false;
            T[0][i] = this.maxValue();
            T[1][i] = -1;
        }
        traversed[x] = true;
        T[0][x] = 0;
        T[1][x] = x;
        for (i = 0; i < this.size(); ++i) {
            if (i == x || this.get(i, x) >= this.maxValue()) continue;
            T[0][i] = this.get(i, x);
            T[1][i] = x;
        }
        boolean pathPossible = false;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.get(i2, x) <= 0) continue;
            pathPossible = true;
        }
        System.out.println("pathPossible: " + pathPossible);
        boolean pathExists = true;
        boolean traversePath = true;
        block3: while (pathPossible && pathExists && traversePath) {
            int i3;
            int tMin = this.maxValue();
            int v = -1;
            for (i3 = 0; i3 < this.size(); ++i3) {
                if (traversed[i3] || T[0][i3] >= tMin) continue;
                tMin = T[0][i3];
                v = i3;
            }
            if (v == -1) {
                pathExists = false;
                break;
            }
            System.out.println("pathExists: " + pathExists);
            traversed[v] = true;
            for (i3 = 0; i3 < this.size(); ++i3) {
                if (traversed[i3] || this.get(v, i3) <= 0 || T[0][v] + this.get(v, i3) >= T[0][i3]) continue;
                T[0][i3] = T[0][v] + this.get(v, i3);
                T[1][i3] = v;
            }
            if (traversed[y]) {
                traversePath = false;
                continue;
            }
            pathExists = false;
            for (i3 = 0; i3 < this.size(); ++i3) {
                if (traversed[i3] || T[0][i3] >= this.maxValue()) continue;
                pathExists = true;
                continue block3;
            }
        }
        System.out.println("pathExists: " + pathExists + "\tpathPossible: " + pathPossible + "\tx: " + x + "\ty: " + y);
        if (pathExists && pathPossible) {
            path.add(new Integer(y));
            int totalDistance = T[0][y];
            int predecessor = T[1][y];
            path.add(new Integer(predecessor));
            while (predecessor != x) {
                totalDistance += T[0][predecessor];
                predecessor = T[1][predecessor];
                System.out.println(predecessor);
                path.add(new Integer(predecessor));
            }
        }
        return path;
    }

    public int getDistance(double pValue) {
        return (int)(Math.max(Math.log(pValue) / eLog10, -3.984375) * 64.0 + 255.0);
    }

    public double getPValue(int distance) {
        return Math.pow(10.0, ((double)distance - 255.0) / 64.0);
    }

    public void save(File fileName) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
            int bufferLength = 5120000;
            byte[] buffer = new byte[bufferLength];
            int len = 0;
            int loc = 0;
            while (loc + bufferLength <= this.matrix.length) {
                len = bufferLength;
                System.arraycopy(this.matrix, loc, buffer, 0, len);
                loc += len;
                ((OutputStream)out).write(buffer);
                System.out.print(".");
            }
            len = this.matrix.length - loc;
            buffer = new byte[len];
            System.arraycopy(this.matrix, loc, buffer, 0, len);
            ((OutputStream)out).write(buffer);
            System.out.print(".");
            System.out.println("");
            buffer = null;
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.out.println("Cannot write to file! (" + e.getMessage() + ")");
        }
    }

    public void load(File fileName) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
            long length = fileName.length();
            if (length == (long)this.matrix.length) {
                int bufferLength = 5120000;
                byte[] buffer = new byte[bufferLength];
                int len = 0;
                int loc = 0;
                while ((len = ((InputStream)in).read(buffer, 0, bufferLength)) != -1) {
                    System.arraycopy(buffer, 0, this.matrix, loc, len);
                    loc += len;
                    System.out.print(".");
                }
                System.out.println("");
                buffer = null;
                this.loadSuccess = true;
            } else {
                System.out.println("File does not adhere to the matrix size!");
                this.loadSuccess = false;
            }
            ((InputStream)in).close();
        }
        catch (Exception e) {
            System.out.println("Cannot read from file! (" + e.getMessage() + ")");
        }
    }
}

