/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.util;

import umcg.genetica.containers.Pair;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.TriTyperGenotypeData;

public class DetermineLD {
    public static final int INCLUDE_CASES_AND_CONTROLS = 1;
    public static final int INCLUDE_CASES = 2;
    public static final int INCLUDE_CONTROLS = 3;
    public static final int RETURN_R_SQUARED = 4;
    public static final int RETURN_D_PRIME = 5;
    public double h11 = 0.0;
    public double h12 = 0.0;
    public double h21 = 0.0;
    public double h22 = 0.0;
    public int nrCalledGenotypes = 0;

    public synchronized double getRSquared(SNP snpX, SNP snpY, TriTyperGenotypeData genotypeData, int returnType, int individualsToInclude, boolean print) {
        Pair<Double, Double> ld = this.getLD(snpX, snpY, genotypeData, individualsToInclude, print);
        if (returnType == 5) {
            return ld.getLeft();
        }
        return ld.getRight();
    }

    public synchronized Pair<Double, Double> getLD(SNP snpX, SNP snpY, TriTyperGenotypeData genotypeData, int individualsToInclude, boolean print) {
        double a;
        if (snpX == null || snpY == null) {
            return new Pair<Double, Double>(0.0, 0.0);
        }
        byte[] genotypesX = snpX.getGenotypes();
        byte[] genotypesY = snpY.getGenotypes();
        if (genotypesX == null || genotypesY == null) {
            System.err.println("Genotypes not loaded for either SNP: " + snpX + ", " + snpY);
        }
        if (genotypesX.length != genotypesY.length) {
            return new Pair<Double, Double>(0.0, 0.0);
        }
        int[][] genotypes = new int[3][3];
        this.nrCalledGenotypes = 0;
        for (int ind = 0; ind < genotypesX.length; ++ind) {
            if (individualsToInclude != 1 && (genotypeData.getIsCase()[ind] == null || !genotypeData.getIsCase()[ind].booleanValue() || individualsToInclude != 2) && (genotypeData.getIsCase()[ind] == null || genotypeData.getIsCase()[ind].booleanValue() || individualsToInclude != 3)) continue;
            byte genotypeX = genotypesX[ind];
            byte genotypeY = genotypesY[ind];
            if (genotypeX == -1 || genotypeY == -1) continue;
            int[] nArray = genotypes[genotypeX];
            byte by = genotypeY;
            nArray[by] = nArray[by] + 1;
            ++this.nrCalledGenotypes;
        }
        double[][] genotypesFreq = new double[3][3];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                genotypesFreq[x][y] = (double)genotypes[x][y] / (double)this.nrCalledGenotypes;
                if (!print) continue;
                System.out.print(genotypes[x][y] + "\t");
            }
            if (!print) continue;
            System.out.println("");
        }
        double[][] alleleFreq = new double[2][2];
        alleleFreq[0][0] = genotypesFreq[0][0] + genotypesFreq[0][1] + genotypesFreq[0][2] + (genotypesFreq[1][0] + genotypesFreq[1][1] + genotypesFreq[1][2]) / 2.0;
        alleleFreq[0][1] = genotypesFreq[2][0] + genotypesFreq[2][1] + genotypesFreq[2][2] + (genotypesFreq[1][0] + genotypesFreq[1][1] + genotypesFreq[1][2]) / 2.0;
        alleleFreq[1][0] = genotypesFreq[0][0] + genotypesFreq[1][0] + genotypesFreq[2][0] + (genotypesFreq[0][1] + genotypesFreq[1][1] + genotypesFreq[2][1]) / 2.0;
        alleleFreq[1][1] = genotypesFreq[0][2] + genotypesFreq[1][2] + genotypesFreq[2][2] + (genotypesFreq[0][1] + genotypesFreq[1][1] + genotypesFreq[2][1]) / 2.0;
        if (print) {
            System.out.println("Allele freq:");
            System.out.println(alleleFreq[0][0]);
            System.out.println(alleleFreq[0][1]);
            System.out.println(alleleFreq[1][0]);
            System.out.println(alleleFreq[1][1]);
        }
        double[][] genotypesTriangleFreq = new double[3][3];
        genotypesTriangleFreq[0][0] = 2.0 * genotypesFreq[0][0] + genotypesFreq[1][0] + genotypesFreq[0][1];
        genotypesTriangleFreq[2][0] = 2.0 * genotypesFreq[2][0] + genotypesFreq[1][0] + genotypesFreq[2][1];
        genotypesTriangleFreq[0][2] = 2.0 * genotypesFreq[0][2] + genotypesFreq[0][1] + genotypesFreq[1][2];
        genotypesTriangleFreq[2][2] = 2.0 * genotypesFreq[2][2] + genotypesFreq[1][2] + genotypesFreq[2][1];
        if (print) {
            System.out.println("Triangle freq:");
            System.out.println(genotypesTriangleFreq[0][0]);
            System.out.println(genotypesTriangleFreq[0][2]);
            System.out.println(genotypesTriangleFreq[2][0]);
            System.out.println(genotypesTriangleFreq[2][2]);
        }
        this.h11 = alleleFreq[0][0] * alleleFreq[1][0];
        this.h12 = alleleFreq[0][0] * alleleFreq[1][1];
        this.h21 = alleleFreq[0][1] * alleleFreq[1][0];
        this.h22 = alleleFreq[0][1] * alleleFreq[1][1];
        double x12y12 = this.h11 * this.h22 / (this.h11 * this.h22 + this.h12 * this.h21) * genotypesFreq[1][1];
        double x12y21 = this.h12 * this.h21 / (this.h11 * this.h22 + this.h12 * this.h21) * genotypesFreq[1][1];
        if (print) {
            System.out.println(this.h11 + "\t" + this.h12 + "\t" + this.h21 + "\t" + this.h22 + "\t\t" + x12y12 + "\t" + x12y21);
        }
        for (int itr = 0; itr < 25; ++itr) {
            this.h11 = (x12y12 + genotypesTriangleFreq[0][0]) / 2.0;
            this.h12 = (x12y21 + genotypesTriangleFreq[0][2]) / 2.0;
            this.h21 = (x12y21 + genotypesTriangleFreq[2][0]) / 2.0;
            this.h22 = (x12y12 + genotypesTriangleFreq[2][2]) / 2.0;
            x12y12 = this.h11 * this.h22 / (this.h11 * this.h22 + this.h12 * this.h21) * genotypesFreq[1][1];
            x12y21 = this.h12 * this.h21 / (this.h11 * this.h22 + this.h12 * this.h21) * genotypesFreq[1][1];
            if (!print) continue;
            System.out.println(this.h11 + "\t" + this.h12 + "\t" + this.h21 + "\t" + this.h22 + "\t\t" + x12y12 + "\t" + x12y21);
        }
        double d = this.h11 - alleleFreq[0][0] * alleleFreq[1][0];
        double rSquared = d * d / (alleleFreq[0][0] * alleleFreq[0][1] * alleleFreq[1][0] * alleleFreq[1][1]);
        double dMax = 0.0;
        if (d < 0.0) {
            a = alleleFreq[0][1] * alleleFreq[1][1];
            if (alleleFreq[0][0] > alleleFreq[1][0]) {
                a = alleleFreq[0][0] * alleleFreq[1][0];
            }
            double b = alleleFreq[0][0] * alleleFreq[1][0];
            if (alleleFreq[0][0] > alleleFreq[1][0]) {
                b = alleleFreq[0][1] * alleleFreq[1][1];
            }
            dMax = Math.min(a, b);
        } else {
            a = alleleFreq[0][1] * alleleFreq[1][0];
            if (alleleFreq[0][0] > alleleFreq[1][0]) {
                a = alleleFreq[0][0] * alleleFreq[1][1];
            }
            double b = alleleFreq[0][0] * alleleFreq[1][1];
            if (alleleFreq[0][0] > alleleFreq[1][0]) {
                b = alleleFreq[0][1] * alleleFreq[1][0];
            }
            dMax = Math.min(a, b);
        }
        double dPrime = Math.abs(d / dMax);
        return new Pair<Double, Double>(Math.min(1.0, dPrime), rSquared);
    }
}

