/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.bin;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class BinaryGZipFloatMatrix {
    private DataOutputStream out;
    public static boolean W = true;
    public static boolean R = false;
    private final Deflater d = new Deflater(9);
    private long indexposition = 0L;
    private long iterations = 0L;
    private long ratio = 0L;
    private long uncompressedSize = 0L;
    private final Inflater inflater = new Inflater();
    private RandomAccessFile ra;
    private byte[] writebuffer = null;
    private byte[] tmpbytebuffer = null;
    private int nrOfBytesInWriteBuffer = 0;
    private int writebuffersize = 0x8000000;
    private int tmpbuffersize = 4096;

    public BinaryGZipFloatMatrix(String filename, boolean W) throws IOException {
        if (W) {
            this.out = new DataOutputStream(new FileOutputStream(new File(filename + ".ZScoreMatrix.dat")));
            this.writebuffer = new byte[this.writebuffersize];
            this.tmpbytebuffer = new byte[this.tmpbuffersize];
        } else {
            this.ra = new RandomAccessFile(filename, "r");
        }
    }

    public long write(Float[] zscorelist) throws IOException {
        long positionToReturn = this.indexposition;
        int nrBytesRequired = zscorelist.length * 4;
        ByteBuffer buff = ByteBuffer.allocate(nrBytesRequired);
        for (Float f : zscorelist) {
            if (f == null) {
                System.out.println("ERROR!");
            }
            buff.putFloat(f.floatValue());
        }
        byte[] input = buff.array();
        this.d.setInput(input);
        this.d.finish();
        int compressedDataLength = this.tmpbuffersize;
        long compressedsize = 0L;
        while (compressedDataLength == this.tmpbuffersize) {
            compressedDataLength = this.d.deflate(this.tmpbytebuffer);
            this.write(this.tmpbytebuffer, 0, compressedDataLength);
            compressedsize += (long)compressedDataLength;
        }
        this.d.reset();
        this.uncompressedSize += (long)nrBytesRequired;
        this.indexposition += compressedsize;
        this.ratio += (long)Math.floor((double)input.length / (double)compressedsize);
        ++this.iterations;
        return positionToReturn;
    }

    public long write(byte[] input) throws IOException {
        long positionToReturn = this.indexposition;
        this.d.setInput(input);
        this.d.finish();
        int compressedDataLength = this.tmpbuffersize;
        long compressedsize = 0L;
        while (compressedDataLength == this.tmpbuffersize) {
            compressedDataLength = this.d.deflate(this.tmpbytebuffer);
            this.write(this.tmpbytebuffer, 0, compressedDataLength);
            compressedsize += (long)compressedDataLength;
        }
        this.d.reset();
        this.uncompressedSize += (long)input.length;
        this.indexposition += compressedsize;
        this.ratio += (long)Math.floor((double)input.length / (double)compressedsize);
        ++this.iterations;
        return positionToReturn;
    }

    public long writeDeflated(byte[] input) throws IOException {
        long positionToReturn = this.indexposition;
        this.write(input, 0, input.length);
        this.indexposition += (long)input.length;
        ++this.iterations;
        return positionToReturn;
    }

    private void write(byte[] bytebuffer, int start, int end) throws IOException {
        int bytesToAdd = end - start;
        if (this.nrOfBytesInWriteBuffer + bytesToAdd >= this.writebuffersize) {
            int nrOfBytesThatWillNotFitInWriteBuffer = this.nrOfBytesInWriteBuffer + bytesToAdd - this.writebuffersize;
            int nrOfBytesThatWillFitInWriteBuffer = bytesToAdd - nrOfBytesThatWillNotFitInWriteBuffer;
            System.arraycopy(bytebuffer, 0, this.writebuffer, this.nrOfBytesInWriteBuffer, nrOfBytesThatWillFitInWriteBuffer);
            this.nrOfBytesInWriteBuffer = this.writebuffersize;
            this.flush();
            System.arraycopy(bytebuffer, nrOfBytesThatWillFitInWriteBuffer, this.writebuffer, 0, nrOfBytesThatWillNotFitInWriteBuffer);
            this.nrOfBytesInWriteBuffer = nrOfBytesThatWillNotFitInWriteBuffer;
        } else {
            System.arraycopy(bytebuffer, 0, this.writebuffer, this.nrOfBytesInWriteBuffer, bytesToAdd);
            this.nrOfBytesInWriteBuffer += bytesToAdd;
        }
    }

    public void flush() throws IOException {
        this.out.write(this.writebuffer, 0, this.nrOfBytesInWriteBuffer);
        this.nrOfBytesInWriteBuffer = 0;
    }

    public Float[] read(long index, long nextIndex, int numElems) throws IOException, DataFormatException {
        long nextpos;
        long curpos;
        if (index > this.ra.length()) {
            throw new IOException("IO Error: SNP ID out of scope!");
        }
        long seekloc = index;
        int compressedsize = 0;
        if (nextIndex == -1L) {
            curpos = seekloc;
            nextpos = this.ra.length();
            compressedsize = (int)(nextpos - curpos);
        } else {
            curpos = seekloc;
            nextpos = nextIndex;
            compressedsize = (int)(nextpos - curpos);
        }
        if (seekloc + (long)compressedsize > this.ra.length()) {
            throw new IOException("IO Error: buffer to be loaded is out of scope");
        }
        byte[] buffer = new byte[compressedsize];
        this.ra.seek(seekloc);
        this.ra.read(buffer);
        this.inflater.setInput(buffer);
        this.inflater.finished();
        byte[] decompressed = new byte[numElems * 4];
        this.inflater.inflate(decompressed);
        long actuallydecompressed = this.inflater.getBytesWritten();
        if (actuallydecompressed != (long)(numElems * 4)) {
            throw new IOException("IO Error: uncompressed data does not correspond to the size requested\t" + actuallydecompressed + "\t" + numElems * 4 + "\t Index: " + index);
        }
        this.inflater.reset();
        ByteBuffer bytebuffer = ByteBuffer.wrap(decompressed);
        Float[] output = new Float[numElems];
        for (int i = 0; i < numElems; ++i) {
            output[i] = Float.valueOf(bytebuffer.getFloat());
        }
        return output;
    }

    public synchronized byte[] readDeflated(long index, long nextIndex, int numElems) throws IOException {
        long curpos;
        if (index > this.ra.length()) {
            throw new IOException("IO Error: SNP ID out of scope!");
        }
        long seekloc = index;
        int compressedsize = 0;
        if (nextIndex == -1L) {
            curpos = seekloc;
            long nextpos = this.ra.length();
            compressedsize = (int)(nextpos - curpos);
        } else {
            curpos = seekloc;
            long nextpos = nextIndex;
            compressedsize = (int)(nextpos - curpos);
        }
        if (seekloc + (long)compressedsize > this.ra.length()) {
            throw new IOException("IO Error: buffer to be loaded is out of scope");
        }
        byte[] buffer = new byte[compressedsize];
        this.ra.seek(seekloc);
        this.ra.read(buffer);
        return buffer;
    }

    public void close() throws IOException {
        if (this.out != null) {
            if (this.nrOfBytesInWriteBuffer > 0) {
                this.flush();
            }
            this.out.close();
            System.out.println("Average compression ratio: " + (double)this.uncompressedSize / (double)this.indexposition);
        }
        if (this.ra != null) {
            this.ra.close();
        }
    }
}

