/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WGAFileMatrixImputedDosage {
    public int nrSNPs = 0;
    public int nrInds = 0;
    private RandomAccessFile file = null;

    public WGAFileMatrixImputedDosage(int nrSNPs, int nrInds, File fileName, boolean readOnly) throws IOException {
        this.nrSNPs = nrSNPs;
        this.nrInds = nrInds;
        if (readOnly) {
            System.out.println("Opening imputed dosage matrix file: " + fileName);
            this.file = new RandomAccessFile(fileName, "r");
        } else {
            this.file = new RandomAccessFile(fileName, "rw");
        }
        long fileSize = 1L * (long)nrSNPs * (long)nrInds;
        if (!readOnly && this.file.length() != fileSize) {
            System.out.println("Creating imputed dosage matrix for " + nrSNPs + " SNPS and " + nrInds + " individuals. Eventual size: " + fileSize);
            this.file.seek(0L);
            byte[] byteString = new byte[1000];
            for (int g = 0; g < 1000; ++g) {
                byteString[g] = 0;
            }
            for (long x = 0L; x < fileSize - 1000L; x += 1000L) {
                this.file.write(byteString);
            }
            long remainder = fileSize % 1000L;
            byte[] byteSingle = new byte[]{0};
            for (long x = 0L; x < remainder; ++x) {
                this.file.write(byteSingle);
                if (x % 0x8000000L != 0L) continue;
                double perc = Math.floor((double)x / (double)fileSize) * 100.0;
                System.out.println("Written " + perc + "%");
            }
            System.out.println("Size matrix:\t" + fileSize + "\tFile size:\t" + this.file.length());
        }
    }

    private long getElement(int snp, int ind) {
        return 1L * (long)snp * (long)this.nrInds + (long)ind;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public byte getDosage(int snp, int ind) throws IOException {
        this.file.seek(this.getElement(snp, ind));
        return this.file.readByte();
    }

    public void setDosage(int snp, int ind, byte[] value) throws IOException {
        this.file.seek(this.getElement(snp, ind));
        this.file.write(value);
    }

    public void setDosage(int snp, int ind, byte value) throws IOException {
        this.file.seek(this.getElement(snp, ind));
        this.file.write(value);
    }
}

