/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.TriTyperExpressionData;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDatasetSettings;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.math.stats.Log2Transform;
import umcg.genetica.math.stats.QuantileNormalization;

public final class TriTyperGeneticalGenomicsDataset
implements Comparable<TriTyperGeneticalGenomicsDataset> {
    private TriTyperGenotypeData genotypeData;
    private TriTyperExpressionData expressionData;
    private HashMap<String, String> genotypeToExpressionCouplings;
    private TriTyperGeneticalGenomicsDatasetSettings settings;
    private short[] expressionToGenotypeIdArray;
    private short totalGGSamples;
    private boolean expressionDataLoadedCorrectly = true;
    private short[] genotypeToExpressionIdArray;

    public TriTyperGeneticalGenomicsDataset(TriTyperGeneticalGenomicsDatasetSettings settings) throws IOException, Exception {
        this.settings = settings;
        settings.genotypeLocation = Gpio.formatAsDirectory(settings.genotypeLocation);
        if (settings.expressionLocation == null) {
            settings.expressionLocation = settings.genotypeLocation + "ExpressionData.txt";
        }
        this.genotypeData = new TriTyperGenotypeData();
        this.genotypeData.load(settings.genotypeLocation);
        HashSet<String> includedExpressionIndividuals = new HashSet<String>();
        Boolean[] isIncluded = this.genotypeData.getIsIncluded();
        this.loadCouplings();
        Set<Map.Entry<String, String>> entries = this.genotypeToExpressionCouplings.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String genotypeIndividual = entry.getKey();
            Integer genotypeIndividualId = this.genotypeData.getIndividualId(genotypeIndividual);
            if (genotypeIndividualId == null || isIncluded[genotypeIndividualId] == null || !isIncluded[genotypeIndividualId].booleanValue()) continue;
            includedExpressionIndividuals.add(entry.getValue());
        }
        if (includedExpressionIndividuals.isEmpty()) {
            System.err.println("ERROR: none of the expression samples will be included with your current settings.\nPlease check the links between genotype and gene expression samples and/or your PhenotypeInformation.txt");
            System.exit(-1);
        }
        this.expressionData = new TriTyperExpressionData();
        this.expressionData.confineToProbes(settings.tsProbesConfine);
        this.expressionData.setConfineToProbesThatMapToChromosome(settings.confineProbesToProbesMappingToAnyChromosome);
        this.expressionData.setConfineToProbesThatMapToChromosome(settings.confineProbesToProbesThatMapToChromosome);
        this.expressionData.setIncludeIndividuals(includedExpressionIndividuals);
        this.expressionDataLoadedCorrectly = this.expressionData.load(settings.expressionLocation, settings.probeannotation, settings.expressionplatform, settings.cisAnalysis && settings.transAnalysis);
        this.pruneGenotypeToExpressionCouplings();
        if (settings.quantilenormalize) {
            QuantileNormalization.quantilenormalize(this.expressionData.getMatrix());
        }
        if (settings.logtransform) {
            Log2Transform.log2transform(this.expressionData.getMatrix());
        }
    }

    public TriTyperGenotypeData getGenotypeData() {
        return this.genotypeData;
    }

    public void setGenotypeData(TriTyperGenotypeData genotypeData) {
        this.genotypeData = genotypeData;
    }

    public TriTyperExpressionData getExpressionData() {
        return this.expressionData;
    }

    public void setExpressionData(TriTyperExpressionData expressionData) {
        this.expressionData = expressionData;
    }

    public HashMap<String, String> getGenotypeToExpressionCouplings() {
        return this.genotypeToExpressionCouplings;
    }

    public void setGenotypeToExpressionCouplings(HashMap<String, String> genotypeToExpressionCouplings) {
        this.genotypeToExpressionCouplings = genotypeToExpressionCouplings;
    }

    public TriTyperGeneticalGenomicsDatasetSettings getSettings() {
        return this.settings;
    }

    public void setSettings(TriTyperGeneticalGenomicsDatasetSettings settings) {
        this.settings = settings;
    }

    public int getTotalGGSamples() {
        return this.totalGGSamples;
    }

    private void loadCouplings() throws IOException {
        this.genotypeToExpressionCouplings = new HashMap();
        String genotypeToExpressionCoupling = this.settings.genotypeToExpressionCoupling;
        if (genotypeToExpressionCoupling != null && genotypeToExpressionCoupling.trim().length() > 0) {
            if (!Gpio.exists(genotypeToExpressionCoupling)) {
                throw new IOException("Error: genotype to expression coupling file: " + genotypeToExpressionCoupling + " does not exist.");
            }
            TextFile in = new TextFile(genotypeToExpressionCoupling, false);
            String[] elems = in.readLineElemsReturnReference(TextFile.tab);
            while (elems != null) {
                if (elems.length > 1) {
                    String key = new String(elems[0].getBytes("UTF-8"));
                    String value = new String(elems[1].getBytes("UTF-8"));
                    if (this.genotypeToExpressionCouplings.get(key) != null) {
                        System.out.println("ERROR: your genotype to expression coupling file contains duplicate entries for individual: " + key);
                        System.exit(0);
                    } else {
                        this.genotypeToExpressionCouplings.put(key, value);
                    }
                }
                elems = in.readLineElemsReturnReference(TextFile.tab);
            }
            in.close();
        } else {
            String[] individuals;
            Boolean[] isIncluded = this.genotypeData.getIsIncluded();
            int i = 0;
            for (String ind : individuals = this.genotypeData.getIndividuals()) {
                if (isIncluded[i] != null && isIncluded[i].booleanValue()) {
                    if (this.genotypeToExpressionCouplings.get(ind) != null) {
                        System.out.println("ERROR: your genotype data contains duplicate individuals: " + ind);
                        System.exit(0);
                    } else {
                        this.genotypeToExpressionCouplings.put(ind, ind);
                    }
                }
                ++i;
            }
        }
    }

    public int[] getExpressionToGenotypeIdArray() {
        int[] intExpToGArr = new int[this.expressionToGenotypeIdArray.length];
        for (int i = 0; i < intExpToGArr.length; ++i) {
            intExpToGArr[i] = this.expressionToGenotypeIdArray[i];
        }
        return intExpToGArr;
    }

    public short[] getExpressionToGenotypeIdArrayShort() {
        return this.expressionToGenotypeIdArray;
    }

    @Override
    public int compareTo(TriTyperGeneticalGenomicsDataset o) {
        int numIndsOther = o.getGenotypeData().getIndividuals().length;
        return this.genotypeData.getIndividuals().length - numIndsOther;
    }

    public boolean equals(TriTyperGeneticalGenomicsDataset o) {
        int numIndsOther = o.getGenotypeData().getIndividuals().length;
        return this.genotypeData.getIndividuals().length == numIndsOther;
    }

    public void permuteSampleLables() {
        ArrayList<Short> alIndWGA = new ArrayList<Short>();
        int numSamples = this.expressionToGenotypeIdArray.length;
        for (int i = 0; i < numSamples; ++i) {
            if (this.expressionToGenotypeIdArray[i] == -1) continue;
            alIndWGA.add(this.expressionToGenotypeIdArray[i]);
        }
        short[] indWGANew = new short[numSamples];
        this.genotypeToExpressionIdArray = new short[this.genotypeData.getIndividuals().length];
        for (int i = 0; i < numSamples; ++i) {
            short genotypeId;
            if (this.expressionToGenotypeIdArray[i] == -1) {
                indWGANew[i] = -1;
                continue;
            }
            indWGANew[i] = genotypeId = ((Short)alIndWGA.remove((int)(Math.random() * (double)alIndWGA.size()))).shortValue();
            this.genotypeToExpressionIdArray[genotypeId] = (short)i;
        }
        this.expressionToGenotypeIdArray = indWGANew;
    }

    public void resetGenotypeToExpressionCouplings() throws IOException {
        this.loadCouplings();
    }

    public void pruneGenotypeToExpressionCouplings() {
        String[] individuals = this.genotypeData.getIndividuals();
        Boolean[] isReallyIncluded = new Boolean[individuals.length];
        HashMap<String, String> realGenotypeToExpressionCouplings = new HashMap<String, String>();
        this.totalGGSamples = 0;
        for (int i = 0; i < isReallyIncluded.length; ++i) {
            String genotypeInd = individuals[i];
            if (!this.genotypeToExpressionCouplings.containsKey(genotypeInd)) {
                isReallyIncluded[i] = false;
                continue;
            }
            String coupledExpressionSample = this.genotypeToExpressionCouplings.get(genotypeInd);
            if (coupledExpressionSample == null) continue;
            Integer expressionSampleId = this.expressionData.getIndividualId(coupledExpressionSample);
            if (expressionSampleId == null) {
                isReallyIncluded[i] = false;
                continue;
            }
            isReallyIncluded[i] = true;
            realGenotypeToExpressionCouplings.put(genotypeInd, coupledExpressionSample);
            this.totalGGSamples = (short)(this.totalGGSamples + 1);
        }
        this.genotypeData.setIsIncluded(isReallyIncluded);
        this.genotypeToExpressionCouplings = realGenotypeToExpressionCouplings;
        Set entries = realGenotypeToExpressionCouplings.entrySet();
        this.expressionToGenotypeIdArray = new short[this.totalGGSamples];
        HashSet<Integer> visitedNumbers = new HashSet<Integer>();
        for (Map.Entry entry : entries) {
            Integer expressionIndId = this.expressionData.getIndividualId((String)entry.getValue());
            Integer genotypeIndId = this.genotypeData.getIndividualId((String)entry.getKey());
            if (expressionIndId == null || genotypeIndId == null) continue;
            if (visitedNumbers.contains(expressionIndId)) {
                System.out.println("ERROR: your dataset contains duplicate samples!");
                continue;
            }
            this.expressionToGenotypeIdArray[expressionIndId.intValue()] = genotypeIndId.shortValue();
            visitedNumbers.add(expressionIndId);
        }
    }

    public HashMap<Integer, Integer> getGenotypeToExpressionIdHash() {
        HashMap<Integer, Integer> gte = new HashMap<Integer, Integer>();
        int i = 0;
        for (short entry : this.expressionToGenotypeIdArray) {
            Integer genotypeIndId = entry;
            Integer expressionIndId = i;
            if (expressionIndId != null && genotypeIndId != null) {
                gte.put(genotypeIndId, expressionIndId);
            }
            ++i;
        }
        return gte;
    }

    public HashMap<Integer, Integer> getExpressionToGenotypeIdHash() {
        HashMap<Integer, Integer> etg = new HashMap<Integer, Integer>();
        int i = 0;
        for (short entry : this.expressionToGenotypeIdArray) {
            Integer genotypeIndId = entry;
            Integer expressionIndId = i;
            if (expressionIndId != null && genotypeIndId != null) {
                etg.put(expressionIndId, genotypeIndId);
            }
            ++i;
        }
        return etg;
    }

    public boolean isExpressionDataLoadedCorrectly() {
        return this.expressionDataLoadedCorrectly;
    }

    public void setExpressionDataLoadedCorrectly(boolean expressionDataLoadedCorrectly) {
        this.expressionDataLoadedCorrectly = expressionDataLoadedCorrectly;
    }
}

