/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.IOException;
import java.io.RandomAccessFile;
import umcg.genetica.io.trityper.SNP;

public class BufferedSNPLoader {
    private RandomAccessFile m_genotypehandle;
    private RandomAccessFile m_dosagehandle;
    private final int BUFFERSIZE = 8192;
    private final byte[] dosagebuffer = new byte[8192];
    private int dosagepointer = 0;
    private long dosagestartpointer = -1L;
    private final byte[] genotypebuffer = new byte[8192];
    private int genotypepointer = 0;
    private long genotypestartpointer = -1L;
    private long genotypestoppointer = -1L;
    private int m_numIndividuals;
    private final Boolean[] m_isIncluded;
    private final Boolean[] m_isFemale;

    public BufferedSNPLoader(RandomAccessFile genotypehandle, Boolean[] indIsIncluded, Boolean[] isFemale) {
        this.m_genotypehandle = genotypehandle;
        this.m_isIncluded = indIsIncluded;
        this.m_isFemale = isFemale;
    }

    public BufferedSNPLoader(RandomAccessFile genotypehandle, RandomAccessFile dosagehandle, Boolean[] indIsIncluded, Boolean[] isFemale) {
        this.m_genotypehandle = genotypehandle;
        this.m_dosagehandle = dosagehandle;
        this.m_isIncluded = indIsIncluded;
        this.m_isFemale = isFemale;
    }

    private int readgenotypebuffer(long seekLoc) throws IOException {
        if (seekLoc > this.m_genotypehandle.length()) {
            throw new IOException("Can not seek beyond file size. File size: " + this.m_genotypehandle.length() + ", seek location: " + seekLoc);
        }
        if (this.m_genotypehandle.getFilePointer() != seekLoc) {
            this.m_genotypehandle.seek(seekLoc);
        }
        long toread = 8192L;
        if (seekLoc + 8192L > this.m_genotypehandle.length()) {
            toread = this.m_genotypehandle.length() - (seekLoc + 8192L);
        }
        this.genotypestartpointer = this.m_genotypehandle.getFilePointer();
        int len = this.m_genotypehandle.read(this.genotypebuffer, 0, (int)toread);
        this.genotypestoppointer = this.m_genotypehandle.getFilePointer();
        return len;
    }

    public void loadGenotypes(SNP snp) throws IOException {
        byte[] allele1 = new byte[this.m_numIndividuals];
        byte[] allele2 = new byte[this.m_numIndividuals];
        int bytesize = this.m_numIndividuals * 2;
        long seekLoc = (long)snp.getId() * (long)bytesize;
        byte[] alleles = new byte[bytesize];
        if (this.genotypepointer == -1) {
            this.readgenotypebuffer(seekLoc);
        }
        long readstop = seekLoc + (long)bytesize;
        if (seekLoc >= this.genotypestartpointer && readstop < this.genotypestoppointer) {
            int readStart = (int)(seekLoc - this.genotypestartpointer);
            System.arraycopy(this.genotypebuffer, readStart, allele1, 0, this.m_numIndividuals);
            System.arraycopy(this.genotypebuffer, readStart + this.m_numIndividuals, allele2, 0, this.m_numIndividuals);
        } else if (seekLoc >= this.genotypestartpointer && seekLoc < this.genotypestoppointer && readstop > this.genotypestoppointer) {
            int readStart = (int)(seekLoc - this.genotypestartpointer);
            int remainderToRead = bytesize - (int)(this.genotypestoppointer - (long)readStart);
        } else if (seekLoc > this.genotypestartpointer) {
            // empty if block
        }
        alleles = null;
        snp.setAlleles(allele1, allele2, this.m_isIncluded, this.m_isFemale);
    }

    public void loadDosage(SNP snp) throws IOException {
        if (this.m_dosagehandle != null) {
            int ind;
            byte[] dosageValues = new byte[this.m_numIndividuals];
            long seekLoc = (long)snp.getId() * (long)this.m_numIndividuals * 1L;
            this.m_dosagehandle.seek(seekLoc);
            int len = this.m_dosagehandle.read(dosageValues, 0, this.m_numIndividuals);
            byte[] genotypes = snp.getGenotypes();
            boolean takeComplement = false;
            for (ind = 0; ind < dosageValues.length; ++ind) {
                double dosagevalue = (double)(128 + dosageValues[ind]) / 100.0;
                if (genotypes[ind] == 0 && dosagevalue > 1.0) {
                    takeComplement = true;
                    break;
                }
                if (genotypes[ind] != 2 || !(dosagevalue < 1.0)) continue;
                takeComplement = true;
                break;
            }
            if (takeComplement) {
                for (ind = 0; ind < dosageValues.length; ++ind) {
                    byte dosageValue;
                    dosageValues[ind] = dosageValue = (byte)(200 - (128 + dosageValues[ind]) + -128);
                }
            }
            snp.setDosage(dosageValues);
        }
    }

    public int getNumIndividuals() {
        return this.m_numIndividuals;
    }

    public void setNumIndividuals(int numIndividuals) {
        this.m_numIndividuals = numIndividuals;
    }

    public boolean hasDosageInformation() {
        return this.m_dosagehandle != null;
    }

    public double getAverageSNPSize(int numSNPs) {
        long size = 0L;
        try {
            size += this.m_genotypehandle.length();
            if (this.m_dosagehandle != null) {
                size += this.m_dosagehandle.length();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        double avgSNPSize = 0.0;
        if (size > 0L) {
            avgSNPSize = (double)size / (double)numSNPs;
        }
        return avgSNPSize;
    }

    public void close() throws IOException {
        if (this.m_dosagehandle != null) {
            this.m_dosagehandle.close();
        }
        this.m_genotypehandle.close();
    }
}

