/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.gwascatalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import umcg.genetica.io.gwascatalog.GWASLocus;
import umcg.genetica.io.gwascatalog.GWASPublication;
import umcg.genetica.io.gwascatalog.GWASSNP;
import umcg.genetica.io.gwascatalog.GWASTrait;
import umcg.genetica.io.text.TextFile;

public class GWASCatalog {
    private HashSet<GWASLocus> loci = new HashSet();
    private HashSet<GWASSNP> snps = new HashSet();
    private HashSet<GWASTrait> traits = new HashSet();
    private GWASTrait[] traitArray = null;
    private HashMap<String, GWASPublication> publicationToObj = new HashMap();
    private HashMap<String, GWASSNP> snpToObj = new HashMap();
    private HashMap<String, GWASLocus> locusToObj = new HashMap();
    private HashMap<String, GWASTrait> traitToObj = new HashMap();
    private HashMap<String, GWASTrait> cleanTraitToObj = new HashMap();

    public GWASCatalog() {
    }

    public GWASCatalog(String gwasCatalogLoc) throws IOException {
        this.read(gwasCatalogLoc);
    }

    public GWASCatalog(String gwasCatalogLoc, double pvaluethreshold) throws IOException {
        this.read(gwasCatalogLoc);
    }

    public void read(String calatogloc) throws IOException {
        TextFile tf = new TextFile(calatogloc, false);
        String[] headerelems = tf.readLineElemsReturnReference(TextFile.tab);
        int dateAddedCol = -1;
        int pubMedidCol = -1;
        int firstAuthorCol = -1;
        int publishDateCol = -1;
        int journalCol = -1;
        int studyCol = -1;
        int diseaseCol = -1;
        int samplesizeCol = -1;
        int samplesizeReplicationCol = -1;
        int topSNPCol = -1;
        int snpCol = -1;
        int pvalCol = -1;
        int chrCol = -1;
        int chrPosCol = -1;
        int reportedGeneCol = -1;
        int mappedGeneCol = -1;
        int col = 0;
        for (String e : headerelems) {
            if (e.equals("Date Added to Catalog")) {
                dateAddedCol = col;
            } else if (e.equals("PUBMEDID")) {
                pubMedidCol = col;
            } else if (e.equals("First Author")) {
                firstAuthorCol = col;
            } else if (e.equals("Date")) {
                publishDateCol = col;
            } else if (e.equals("Journal")) {
                journalCol = col;
            } else if (e.equals("Study")) {
                studyCol = col;
            } else if (e.equals("Disease/Trait")) {
                diseaseCol = col;
            } else if (e.equals("Initial Sample Size")) {
                samplesizeCol = col;
            } else if (e.equals("Replication Sample Size")) {
                samplesizeReplicationCol = col;
            } else if (e.equals("Strongest SNP-Risk Allele")) {
                topSNPCol = col;
            } else if (e.equals("SNPs")) {
                snpCol = col;
            } else if (e.equals("p-Value")) {
                pvalCol = col;
            } else if (e.equals("Chr_id")) {
                chrCol = col;
            } else if (e.equals("Chr_pos")) {
                chrPosCol = col;
            } else if (e.equals("Reported Gene(s)")) {
                reportedGeneCol = col;
            } else if (e.equals("Mapped_gene")) {
                mappedGeneCol = col;
            }
            ++col;
        }
        String[] elems = tf.readLineElemsReturnReference(TextFile.tab);
        int numtraits = 0;
        int numsnps = 0;
        int numpubs = 0;
        while (elems != null) {
            if (elems.length > 11) {
                Double previousP;
                GWASTrait gwasTraitObj;
                GWASPublication pub;
                String pubname = elems[pubMedidCol] + "; " + elems[firstAuthorCol] + "; " + elems[publishDateCol] + "; " + elems[journalCol] + "; " + elems[studyCol];
                String trait = elems[diseaseCol].trim();
                String cleanedTrait = trait.replaceAll(" ", "_").replaceAll("[^a-zA-Z0-9\\-_]+", "");
                String otherSNPs = elems[snpCol].trim();
                String[] topSNPElems = elems[topSNPCol].split("-");
                String riskallele = null;
                String mGene = elems[mappedGeneCol];
                String rGene = elems[reportedGeneCol];
                HashSet<String> mappedGenes = new HashSet<String>();
                HashSet<String> reportedGenes = new HashSet<String>();
                if (!(mGene.equals("NR") || mGene.equals("Intergenic") || mGene.equals(" - "))) {
                    if (mGene.contains(" - ")) {
                        String[] mGenes = mGene.split(" - ");
                        mappedGenes.addAll(Arrays.asList(mGenes));
                    } else if (mGene.contains(";")) {
                        String[] mGenes = mGene.split(";");
                        mappedGenes.addAll(Arrays.asList(mGenes));
                    } else {
                        mappedGenes.add(mGene);
                    }
                }
                if (!(rGene.equals("NR") || rGene.equals("Intergenic") || rGene.equals(" - "))) {
                    String[] rGenes;
                    if (rGene.contains(" - ")) {
                        rGenes = rGene.split(" - ");
                        reportedGenes.addAll(Arrays.asList(rGenes));
                    } else if (rGene.contains(";")) {
                        rGenes = rGene.split(";");
                        reportedGenes.addAll(Arrays.asList(rGenes));
                    } else {
                        reportedGenes.add(rGene);
                    }
                }
                byte chr = -1;
                int chrPos = -1;
                try {
                    chr = Byte.parseByte(elems[chrCol]);
                    chrPos = Integer.parseInt(elems[chrPosCol]);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                if (topSNPElems.length > 1 && (riskallele = topSNPElems[1]).equals("?")) {
                    riskallele = null;
                }
                if ((pub = this.publicationToObj.get(pubname)) == null) {
                    pub = new GWASPublication();
                    pub.id = numpubs++;
                    pub.name = pubname;
                    this.publicationToObj.put(pubname, pub);
                }
                if ((gwasTraitObj = this.traitToObj.get(trait)) == null) {
                    gwasTraitObj = new GWASTrait();
                    gwasTraitObj.name = trait;
                    gwasTraitObj.cleanName = cleanedTrait;
                    gwasTraitObj.id = numtraits++;
                    gwasTraitObj.setMappedGenes(mappedGenes);
                    gwasTraitObj.setReportedGenes(reportedGenes);
                    this.traitToObj.put(trait, gwasTraitObj);
                    this.cleanTraitToObj.put(cleanedTrait, gwasTraitObj);
                    this.traits.add(gwasTraitObj);
                }
                String topSNP = topSNPElems[0];
                topSNP = topSNP.trim();
                while (topSNP.startsWith(" ")) {
                    topSNP = topSNP.substring(1);
                }
                GWASSNP gwasTopSNPObj = this.snpToObj.get(topSNP);
                if (gwasTopSNPObj == null) {
                    gwasTopSNPObj = new GWASSNP();
                    gwasTopSNPObj.setName(topSNP);
                    gwasTopSNPObj.setId(numsnps);
                    gwasTopSNPObj.setChr(chr);
                    gwasTopSNPObj.setPosition(chrPos);
                    this.snpToObj.put(topSNP, gwasTopSNPObj);
                    this.snps.add(gwasTopSNPObj);
                    ++numsnps;
                }
                Double topSNPAssocPVal = null;
                try {
                    topSNPAssocPVal = Double.parseDouble(elems[pvalCol]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                gwasTopSNPObj.getAssociatedTraits().add(gwasTraitObj);
                gwasTraitObj.addTopSNP(gwasTopSNPObj);
                if (topSNPAssocPVal != null && ((previousP = gwasTopSNPObj.getPValueAssociatedWithTrait(gwasTraitObj)) == null || previousP > topSNPAssocPVal)) {
                    gwasTopSNPObj.setPValueAssociatedWithTrait(gwasTraitObj, topSNPAssocPVal);
                    gwasTopSNPObj.getRiskAllele().put(gwasTraitObj, riskallele);
                }
                String[] otherSNPElems = otherSNPs.split(",");
                for (int s = 0; s < otherSNPElems.length; ++s) {
                    Double previousP2;
                    String snpname = otherSNPElems[s].trim();
                    while (snpname.startsWith(" ")) {
                        snpname = snpname.substring(1);
                    }
                    GWASSNP gwasSNPObj = this.snpToObj.get(snpname);
                    if (gwasSNPObj == null) {
                        gwasSNPObj = new GWASSNP();
                        gwasSNPObj.setName(snpname);
                        gwasSNPObj.setId(numsnps);
                        gwasSNPObj.setChr(chr);
                        gwasSNPObj.setPosition(chrPos);
                        this.snpToObj.put(snpname, gwasSNPObj);
                        this.snps.add(gwasSNPObj);
                        ++numsnps;
                    }
                    Double pval = null;
                    try {
                        pval = Double.parseDouble(elems[pvalCol]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    gwasSNPObj.getAssociatedTraits().add(gwasTraitObj);
                    if (pval != null && ((previousP2 = gwasSNPObj.getPValueAssociatedWithTrait(gwasTraitObj)) == null || previousP2 > pval)) {
                        gwasSNPObj.setPValueAssociatedWithTrait(gwasTraitObj, pval);
                        gwasSNPObj.getRiskAllele().put(gwasTraitObj, riskallele);
                    }
                    gwasTraitObj.snps.add(gwasSNPObj);
                    pub.snps.add(gwasSNPObj);
                    pub.setPValueAssociatedWithTrait(gwasSNPObj, gwasTraitObj, pval);
                    gwasSNPObj.getPublishedIn().add(pub);
                }
                gwasTraitObj.appendMappedGenes(mappedGenes);
                gwasTraitObj.appendReportedGenes(reportedGenes);
                gwasTraitObj.publishedIn.add(pub);
                pub.traits.add(gwasTraitObj);
            }
            elems = tf.readLineElemsReturnReference(TextFile.tab);
        }
        System.out.println(numpubs + " pubs, " + numsnps + " snps, " + numtraits + " traits");
        tf.close();
    }

    public GWASTrait[] getTraits() {
        if (this.traitArray == null) {
            this.traitArray = new GWASTrait[this.traits.size()];
            this.traits.toArray(this.traitArray);
        }
        return this.traitArray;
    }

    public HashSet<GWASLocus> getLoci() {
        return this.loci;
    }

    public void setLoci(HashSet<GWASLocus> loci) {
        this.loci = loci;
    }

    public HashSet<GWASSNP> getSnps() {
        return this.snps;
    }

    public void setSnps(HashSet<GWASSNP> snps) {
        this.snps = snps;
    }

    public void setTraits(HashSet<GWASTrait> traits) {
        this.traits = traits;
    }

    public HashMap<String, GWASPublication> getPublicationToObj() {
        return this.publicationToObj;
    }

    public void setPublicationToObj(HashMap<String, GWASPublication> publicationToObj) {
        this.publicationToObj = publicationToObj;
    }

    public HashMap<String, GWASSNP> getSnpToObj() {
        return this.snpToObj;
    }

    public void setSnpToObj(HashMap<String, GWASSNP> snpToObj) {
        this.snpToObj = snpToObj;
    }

    public HashMap<String, GWASLocus> getLocusToObj() {
        return this.locusToObj;
    }

    public void setLocusToObj(HashMap<String, GWASLocus> locusToObj) {
        this.locusToObj = locusToObj;
    }

    public HashMap<String, GWASTrait> getTraitToObj() {
        return this.traitToObj;
    }

    public void setTraitToObj(HashMap<String, GWASTrait> traitToObj) {
        this.traitToObj = traitToObj;
    }

    public GWASSNP[] getSnpsArray() {
        GWASSNP[] snpsr = new GWASSNP[this.snps.size()];
        snpsr = this.snps.toArray(snpsr);
        return snpsr;
    }

    public GWASSNP[] getSNPsForTraitContainingKey(String key) {
        System.out.println("Looking for " + key + " snps");
        HashSet<GWASSNP> s = new HashSet<GWASSNP>();
        key = key.toLowerCase();
        for (GWASTrait t : this.traits) {
            if (!t.getName().toLowerCase().contains(key)) continue;
            System.out.println("Found trait: " + t.getName());
            GWASSNP[] traitsnps = t.getSNPs();
            s.addAll(Arrays.asList(traitsnps));
        }
        return s.toArray(new GWASSNP[s.size()]);
    }

    public GWASTrait[] getTraitsForCertainKey(String key) {
        key = key.toLowerCase();
        ArrayList<GWASTrait> selected = new ArrayList<GWASTrait>();
        for (GWASTrait t : this.traits) {
            if (!t.getName().toLowerCase().contains(key)) continue;
            selected.add(t);
        }
        return selected.toArray(new GWASTrait[selected.size()]);
    }

    public GWASLocus[] getLociForCertainKey(String key) {
        System.out.println("Looking for " + key + " snps");
        HashSet<GWASLocus> s = new HashSet<GWASLocus>();
        key = key.toLowerCase();
        for (GWASTrait t : this.traits) {
            if (!t.getName().toLowerCase().contains(key)) continue;
            System.out.println("Found trait: " + t.getName());
            s.addAll(t.loci);
        }
        return s.toArray(new GWASLocus[s.size()]);
    }

    public HashSet<String> getReportedGenesForCertainKey(String key) {
        System.out.println("Looking for " + key + " snps");
        HashSet<String> s = new HashSet<String>();
        key = key.toLowerCase();
        for (GWASTrait t : this.traits) {
            if (!t.getName().toLowerCase().contains(key)) continue;
            System.out.println("Found trait: " + t.getName());
            s.addAll(t.getReportedGenes());
        }
        return s;
    }

    public HashSet<String> getMappedGenesForCertainKey(String key) {
        System.out.println("Looking for " + key + " snps");
        HashSet<String> s = new HashSet<String>();
        key = key.toLowerCase();
        for (GWASTrait t : this.traits) {
            if (!t.getName().toLowerCase().contains(key)) continue;
            System.out.println("Found trait: " + t.getName());
            s.addAll(t.getMappedGenes());
        }
        return s;
    }

    public HashSet<String> getTraitsForCertainSnps(String key) {
        HashSet<String> m = new HashSet<String>();
        key = key.toLowerCase();
        for (GWASSNP s : this.snps) {
            if (!s.getName().equalsIgnoreCase(key)) continue;
            HashSet<GWASTrait> t = s.getAssociatedTraits();
            for (GWASTrait tmp : t) {
                m.add(tmp.cleanName);
            }
        }
        return m;
    }
}

