/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.bin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class BinaryFile {
    public static final boolean W = true;
    public static final boolean R = false;
    protected final DataOutputStream os;
    protected final DataInputStream is;
    protected final String loc;
    protected final boolean writeable;

    public BinaryFile(String loc, boolean mode) throws IOException {
        if (loc.trim().length() == 0) {
            throw new IOException("Could not find file: no file specified");
        }
        this.writeable = mode;
        this.loc = loc;
        if (this.writeable) {
            this.is = null;
            this.os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(loc)));
        } else {
            this.is = new DataInputStream(new BufferedInputStream(new FileInputStream(loc)));
            this.os = null;
        }
    }

    public BinaryFile(String loc, boolean mode, int buffersize) throws IOException {
        if (loc.trim().length() == 0) {
            throw new IOException("Could not find file: no file specified");
        }
        this.writeable = mode;
        this.loc = loc;
        if (this.writeable) {
            this.is = null;
            this.os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(loc), buffersize));
        } else {
            this.is = new DataInputStream(new BufferedInputStream(new FileInputStream(loc), buffersize));
            this.os = null;
        }
    }

    public void writeBytes(byte[] v) throws IOException {
        if (!this.writeable) {
            throw new IOException("File is read only.");
        }
        this.os.write(v);
    }

    public void writeInt(int v) throws IOException {
        if (!this.writeable) {
            throw new IOException("File is read only.");
        }
        this.os.writeInt(v);
    }

    public void writeString(String s) throws IOException {
        if (!this.writeable) {
            throw new IOException("File is read only.");
        }
        this.os.writeChars(s);
    }

    public void writeBool(boolean b) throws IOException {
        if (!this.writeable) {
            throw new IOException("File is read only.");
        }
        this.os.writeBoolean(b);
    }

    public void writeFloat(float f) throws IOException {
        if (!this.writeable) {
            throw new IOException("File is read only.");
        }
        this.os.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        if (!this.writeable) {
            throw new IOException("File is read only.");
        }
        this.os.writeDouble(d);
    }

    public void writeLong(long l) throws IOException {
        if (!this.writeable) {
            throw new IOException("File is read only.");
        }
        this.os.writeLong(l);
    }

    public int readInt() throws IOException, EOFException {
        if (this.writeable) {
            throw new IOException("File is write only.");
        }
        return this.is.readInt();
    }

    public boolean readBool() throws IOException, EOFException {
        if (this.writeable) {
            throw new IOException("File is write only.");
        }
        return this.is.readBoolean();
    }

    public String readString() throws IOException, EOFException {
        if (this.writeable) {
            throw new IOException("File is write only.");
        }
        return this.is.readUTF();
    }

    public float readFloat() throws IOException, EOFException {
        if (this.writeable) {
            throw new IOException("File is write only.");
        }
        return this.is.readFloat();
    }

    public double readDouble() throws IOException, EOFException {
        if (this.writeable) {
            throw new IOException("File is write only.");
        }
        return this.is.readDouble();
    }

    public long readLong() throws IOException, EOFException {
        if (this.writeable) {
            throw new IOException("File is write only.");
        }
        return this.is.readLong();
    }

    public void close() throws IOException {
        if (this.writeable) {
            this.os.close();
        } else {
            this.is.close();
        }
    }

    public void writeByte(byte b) throws IOException {
        if (!this.writeable) {
            throw new IOException("File is read only.");
        }
        this.os.writeByte(b);
    }

    public int read() throws IOException {
        return this.is.read();
    }

    public void write(int b) throws IOException {
        this.os.write(b);
    }
}

