/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.gwas;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.io.trityper.util.DetermineLD;

public class Dependifier {
    private final SNPLoader loader;
    private final TriTyperGenotypeData genotypeData;
    private final DetermineLD ldCalc = new DetermineLD();
    private final String[] allSNPsInReference;
    private HashSet<String> haystack;

    public Dependifier(String datadir) throws IOException {
        this.genotypeData = new TriTyperGenotypeData();
        this.genotypeData.load(datadir);
        this.loader = this.genotypeData.createSNPLoader();
        this.allSNPsInReference = this.genotypeData.getSNPs();
    }

    public Dependifier(TriTyperGenotypeData dataset, SNPLoader loader) {
        this.loader = loader;
        this.genotypeData = dataset;
        this.allSNPsInReference = this.genotypeData.getSNPs();
    }

    public HashMap<String, HashSet<String>> dependifyReturnProxiesPerSNP(String[] inputsnps, double proxyldthreshold, int maxproxydistance) throws IOException {
        HashMap<String, HashSet<String>> proxies = new HashMap<String, HashSet<String>>();
        for (String snp : inputsnps) {
            proxies.put(snp, this.findProxiesForSNP(snp, proxyldthreshold, maxproxydistance));
        }
        return proxies;
    }

    public HashSet<String> dependify(String[] inputsnps, double proxyldthreshold, int maxproxydistance) throws IOException {
        HashSet<String> proxies = new HashSet<String>();
        for (String snp : inputsnps) {
            proxies.addAll(this.findProxiesForSNP(snp, proxyldthreshold, maxproxydistance));
        }
        return proxies;
    }

    public HashSet<String> dependify(String[] needles, String[] haystack, double proxyldthreshold, int maxproxydistance) throws IOException {
        HashSet<String> proxies = new HashSet<String>();
        this.haystack = new HashSet();
        this.haystack.addAll(Arrays.asList(haystack));
        for (String snp : needles) {
            proxies.addAll(this.findProxiesForSNP(snp, proxyldthreshold, maxproxydistance));
        }
        this.haystack = null;
        return proxies;
    }

    public HashMap<String, HashSet<String>> dependifyReturnProxiesPerSNP(String[] needles, String[] haystack, double proxyldthreshold, int maxproxydistance) throws IOException {
        HashMap<String, HashSet<String>> proxies = new HashMap<String, HashSet<String>>();
        this.haystack = new HashSet();
        this.haystack.addAll(Arrays.asList(haystack));
        for (String snp : needles) {
            proxies.put(snp, this.findProxiesForSNP(snp, proxyldthreshold, maxproxydistance));
        }
        this.haystack = null;
        return proxies;
    }

    public HashSet<String> findProxiesForSNP(String snp, double proxyldthreshold, int maxproxydistance) throws IOException {
        HashSet<String> proxies = new HashSet<String>();
        Integer snpIdInReference = this.genotypeData.getSnpToSNPId().get(snp);
        if (snpIdInReference != null) {
            SNP snpObj = this.genotypeData.getSNPObject(snpIdInReference);
            byte chr = snpObj.getChr();
            int chrPos = snpObj.getChrPos();
            if (chr > 0 && chrPos > 0) {
                HashSet<Integer> allSNPsWithinMaxDistance = new HashSet<Integer>();
                for (int i = 0; i < this.allSNPsInReference.length; ++i) {
                    int chrPos2;
                    byte chr2;
                    if (this.haystack != null && !this.haystack.contains(this.allSNPsInReference[i]) || chr != (chr2 = this.genotypeData.getChr(i).byteValue()) || Math.abs((chrPos2 = this.genotypeData.getChrPos(i)) - chrPos) >= maxproxydistance) continue;
                    allSNPsWithinMaxDistance.add(i);
                }
                if (!allSNPsWithinMaxDistance.isEmpty()) {
                    this.loader.loadGenotypes(snpObj);
                    for (Integer i : allSNPsWithinMaxDistance) {
                        double r2;
                        SNP snpObj2 = this.genotypeData.getSNPObject(i);
                        this.loader.loadGenotypes(snpObj2);
                        if (snpObj.getMAF() > 0.0 && snpObj2.getMAF() > 0.0 && !Double.isNaN(r2 = this.ldCalc.getRSquared(snpObj, snpObj2, this.genotypeData, 4, 1, false)) && r2 >= proxyldthreshold) {
                            proxies.add(snpObj2.getName());
                        }
                        snpObj2.clearGenotypes();
                    }
                    snpObj.clearGenotypes();
                }
            }
            snpObj = null;
        }
        return proxies;
    }
}

