/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.graphics;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import umcg.genetica.util.Primitives;

public class ScatterPlot {
    private BufferedImage bi;
    private Graphics2D g2d;
    private int graphHeight;
    private int graphWidth;
    private int drawWidth;
    private int drawHeight;
    private int margin = 50;
    private Color color;
    private Font font;
    private double unitX = Double.NaN;
    private double unitY = Double.NaN;
    private double[] x;
    private double[] y;
    private double maxX;
    private double maxY;
    private double minY;
    private double minX;
    private double rangeX;
    private double rangeY;
    private int fontheight;
    private OUTPUTFORMAT format;
    private String outfilename;
    private Document document = null;
    private PdfWriter writer = null;
    private PdfContentByte cb;

    public ScatterPlot(int sizeX, int sizeY, double[] x, double[] y, OUTPUTFORMAT format, String outfile) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Error initializing scatterplot: X and Y do not have the same length! " + x.length + "x" + y.length);
        }
        this.graphHeight = sizeY;
        this.graphWidth = sizeX;
        this.outfilename = outfile;
        this.format = format;
        this.x = x;
        this.y = y;
        this.init();
        this.plot();
        this.draw();
    }

    public ScatterPlot(int sizeX, int sizeY, double unitX, double unitY, double[] x, double[] y, OUTPUTFORMAT format, String outfile) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Error initializing scatterplot: X and Y do not have the same length! " + x.length + "x" + y.length);
        }
        this.graphHeight = sizeY;
        this.graphWidth = sizeX;
        this.format = format;
        this.outfilename = outfile;
        this.unitX = unitX;
        this.unitY = unitY;
        this.x = x;
        this.y = y;
        this.init();
        this.plot();
        this.draw();
    }

    private void init() {
        if (this.margin > this.graphHeight || this.margin > this.graphWidth) {
            throw new IllegalArgumentException("Size of graph should be > " + this.margin * 2 + " pixels in both directions");
        }
        this.drawWidth = this.graphWidth - 2 * this.margin;
        this.drawHeight = this.graphHeight - 2 * this.margin;
        if (this.format == OUTPUTFORMAT.PDF) {
            Rectangle rectangle = new Rectangle((float)this.graphWidth, (float)this.graphHeight);
            this.document = new Document(rectangle);
            if (!this.outfilename.toLowerCase().endsWith(".pdf")) {
                this.outfilename = this.outfilename + ".pdf";
            }
            try {
                this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(this.outfilename));
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.document.open();
            this.cb = this.writer.getDirectContent();
            this.cb.saveState();
            this.g2d = this.cb.createGraphics((float)this.graphWidth, (float)this.graphHeight);
        } else {
            this.bi = new BufferedImage(this.graphWidth, this.graphHeight, 1);
            this.g2d = this.bi.createGraphics();
        }
        this.color = new Color(255, 255, 255);
        this.g2d.setColor(this.color);
        this.g2d.setFont(new Font("Verdana", 0, 10));
        FontMetrics fontmetrics = this.g2d.getFontMetrics();
        this.fontheight = fontmetrics.getHeight();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2d.fillRect(0, 0, this.graphWidth, this.graphHeight);
        this.color = new Color(0, 0, 0);
        this.g2d.setColor(this.color);
        this.g2d.setColor(this.color);
        this.determineRange();
        this.drawAxis();
    }

    private void plot() {
        this.g2d.setColor(new Color(0, 128, 255, 64));
        for (int i = 0; i < this.x.length; ++i) {
            double xval = this.x[i];
            double yval = this.y[i];
            if (Double.isInfinite(xval)) {
                xval = xval < 0.0 ? -1.7976931348623157E308 : -1.7976931348623157E308;
            }
            if (Double.isInfinite(yval)) {
                yval = yval < 0.0 ? -1.7976931348623157E308 : -1.7976931348623157E308;
            }
            int posX = this.margin + (int)Math.ceil(Math.abs(this.minX - xval) / this.rangeX * (double)this.drawWidth);
            int posY = this.margin + this.drawHeight - (int)Math.ceil(Math.abs(this.minY - yval) / this.rangeY * (double)this.drawHeight);
            this.g2d.fillRect(posX - 1, posY, 3, 3);
        }
    }

    private void draw() {
        try {
            this.g2d.dispose();
            if (this.format == OUTPUTFORMAT.JPG) {
                if (!this.outfilename.toLowerCase().endsWith(".jpg")) {
                    this.outfilename = this.outfilename + ".jpg";
                }
                ImageIO.write((RenderedImage)this.bi, "jpg", new File(this.outfilename));
            } else if (this.format == OUTPUTFORMAT.PNG) {
                if (!this.outfilename.toLowerCase().endsWith(".png")) {
                    this.outfilename = this.outfilename + ".png";
                }
                ImageIO.write((RenderedImage)this.bi, "png", new File(this.outfilename));
            } else {
                this.cb.restoreState();
                this.document.close();
                this.writer.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
    }

    private void drawAxis() {
        String tickLabelFormatted;
        int diff;
        double nonroundedPerc;
        int diff2;
        Color originalColor = this.g2d.getColor();
        Font oriFont = this.g2d.getFont();
        FontMetrics fontmetrics = this.g2d.getFontMetrics();
        int tickFontHeight = fontmetrics.getHeight();
        this.g2d.setFont(new Font("SansSerif", 0, 9));
        this.g2d.setColor(Color.gray);
        int xposYAxis = 0;
        int yposXAxis = 0;
        if (this.minY >= 0.0) {
            this.g2d.drawLine(this.margin, this.margin + this.drawHeight, this.margin + this.drawWidth, this.margin + this.drawHeight);
            yposXAxis = this.margin + this.drawHeight;
        } else if (this.maxY <= 0.0) {
            this.g2d.drawLine(this.margin, this.margin, this.margin + this.drawWidth, this.margin);
            yposXAxis = this.margin;
        } else {
            diff2 = (int)Math.ceil(Math.abs(this.minY) / this.rangeY * (double)this.drawHeight);
            yposXAxis = this.margin + this.drawHeight - diff2;
            this.g2d.drawLine(this.margin, yposXAxis, this.margin + this.drawWidth, yposXAxis);
        }
        if (this.minX > 0.0) {
            this.g2d.drawLine(this.margin, this.margin, this.margin, this.margin + this.drawHeight);
            xposYAxis = this.margin;
        } else if (this.maxX <= 0.0) {
            this.g2d.drawLine(this.margin + this.drawWidth, this.margin, this.margin + this.drawWidth, this.margin + this.drawHeight);
            xposYAxis = this.margin + this.drawWidth;
        } else {
            diff2 = (int)Math.ceil(Math.abs(this.minX) / this.rangeX * (double)this.drawWidth);
            xposYAxis = this.margin + diff2;
            this.g2d.drawLine(this.margin + diff2, this.margin, this.margin + diff2, this.margin + this.drawHeight);
        }
        if (!Double.isNaN(this.unitX)) {
            for (double tickX = this.minX - this.minX % this.unitX; tickX <= this.maxX; tickX += this.unitX) {
                int nrPixelsString;
                nonroundedPerc = Math.abs(this.minX - tickX) / this.rangeX;
                diff = (int)Math.floor(nonroundedPerc * (double)this.drawWidth);
                tickLabelFormatted = null;
                tickLabelFormatted = this.unitX > 10000.0 || this.unitX < 0.001 ? new DecimalFormat("0.#E0").format(tickX) : new DecimalFormat("#.###").format(tickX);
                if (tickX == 0.0) {
                    this.g2d.drawLine(xposYAxis, yposXAxis - 3, xposYAxis, yposXAxis + 3);
                    nrPixelsString = this.g2d.getFontMetrics().stringWidth(tickLabelFormatted) / 2;
                    this.g2d.drawString(tickLabelFormatted, this.margin + diff - nrPixelsString, yposXAxis + tickFontHeight + 3);
                    continue;
                }
                this.g2d.drawLine(this.margin + diff, yposXAxis - 3, this.margin + diff, yposXAxis + 3);
                nrPixelsString = this.g2d.getFontMetrics().stringWidth(tickLabelFormatted) / 2;
                this.g2d.drawString(tickLabelFormatted, this.margin + diff - nrPixelsString, yposXAxis + tickFontHeight + 3);
            }
        }
        if (!Double.isNaN(this.unitY)) {
            for (double tickY = this.minY - this.minY % this.unitY; tickY <= this.maxY; tickY += this.unitY) {
                nonroundedPerc = Math.abs(this.minY - tickY) / this.rangeY;
                diff = (int)Math.floor(nonroundedPerc * (double)this.drawHeight);
                tickLabelFormatted = null;
                tickLabelFormatted = this.unitY > 100000.0 || this.unitY < 1.0E-4 ? new DecimalFormat("0.#E0").format(tickY) : new DecimalFormat("#.###").format(tickY);
                if (tickY == 0.0) {
                    this.g2d.drawLine(xposYAxis - 3, yposXAxis, xposYAxis + 3, yposXAxis);
                    this.g2d.drawString(tickLabelFormatted, xposYAxis - this.g2d.getFontMetrics().stringWidth(tickLabelFormatted) - 5, this.margin + this.drawHeight - diff + tickFontHeight / 2 - 3);
                    continue;
                }
                this.g2d.drawLine(xposYAxis - 3, this.margin + this.drawHeight - diff, xposYAxis + 3, this.margin + this.drawHeight - diff);
                this.g2d.drawString(tickLabelFormatted, xposYAxis - this.g2d.getFontMetrics().stringWidth(tickLabelFormatted) - 5, this.margin + this.drawHeight - diff + tickFontHeight / 2 - 3);
            }
        }
        this.g2d.setFont(oriFont);
        this.g2d.setColor(originalColor);
    }

    private double roundToDecimals(double d, int c) {
        int temp = (int)(d * Math.pow(10.0, c));
        return (double)temp / Math.pow(10.0, c);
    }

    private void determineRange() {
        double diff;
        double remainder;
        this.maxX = Primitives.max(this.x);
        this.maxY = Primitives.max(this.y);
        this.minX = Primitives.min(this.x);
        this.minY = Primitives.min(this.y);
        if (this.minY > 0.0) {
            this.minY = 0.0;
        }
        if (this.minX > 0.0) {
            this.minX = 0.0;
        }
        if (this.maxY < 0.0) {
            this.maxY = 0.0;
        }
        if (this.maxX < 0.0) {
            this.maxX = 0.0;
        }
        if (Double.isInfinite(this.maxX)) {
            this.maxX = Double.MAX_VALUE;
        }
        if (Double.isInfinite(this.minX)) {
            this.minX = -1.7976931348623157E308;
        }
        if (Double.isInfinite(this.maxY)) {
            this.maxY = Double.MAX_VALUE;
        }
        if (Double.isInfinite(this.minY)) {
            this.minY = -1.7976931348623157E308;
        }
        this.rangeX = Math.abs(this.minX - this.maxX);
        this.rangeY = Math.abs(this.minY - this.maxY);
        if (Double.isNaN(this.unitX)) {
            this.unitX = this.determineUnit(this.rangeX);
            if (this.unitX >= Math.abs(this.minX) && this.unitX >= Math.abs(this.maxX)) {
                this.unitX /= 10.0;
            }
        }
        if (Double.isNaN(this.unitY)) {
            this.unitY = this.determineUnit(this.rangeY);
            if (this.unitY >= Math.abs(this.minY) && this.unitY >= Math.abs(this.maxY)) {
                this.unitY /= 10.0;
            }
        }
        if ((remainder = Math.abs(this.maxX) % this.unitX) > 0.0 && this.maxX != 0.0) {
            diff = this.unitX - remainder;
            this.maxX += diff;
        }
        if ((remainder = Math.abs(this.minX) % this.unitX) > 0.0 && this.minX != 0.0) {
            diff = this.unitX - remainder;
            this.minX -= diff;
        }
        this.rangeX = Math.abs(this.minX - this.maxX);
        if (this.rangeX == 0.0) {
            this.maxX = this.unitX;
        }
        if ((remainder = Math.abs(this.maxY) % this.unitY) > 0.0 && this.maxY != 0.0) {
            diff = this.unitY - remainder;
            this.maxY += diff;
        }
        if ((remainder = Math.abs(this.minY) % this.unitY) > 0.0 && this.minY != 0.0) {
            diff = this.unitY - remainder;
            this.minY -= diff;
        }
        this.rangeY = Math.abs(this.minY - this.maxY);
        if (this.rangeY == 0.0) {
            this.maxY = this.unitY;
        }
        if (Double.isInfinite(this.maxY)) {
            this.maxY = Double.MAX_VALUE;
        }
        if (Double.isInfinite(this.minY)) {
            this.minY = -1.7976931348623157E308;
        }
        if (Double.isInfinite(this.maxX)) {
            this.maxX = Double.MAX_VALUE;
        }
        if (Double.isInfinite(this.minX)) {
            this.minX = -1.7976931348623157E308;
        }
        this.rangeX = Math.abs(this.minX - this.maxX);
        this.rangeY = Math.abs(this.minY - this.maxY);
    }

    private double determineUnit(double range) {
        double divisor = Math.log10(range);
        divisor = Math.floor(divisor);
        divisor = Math.pow(10.0, divisor);
        return divisor;
    }

    public static enum OUTPUTFORMAT {
        PDF,
        PNG,
        JPG;

    }
}

