/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import org.broad.tribble.TribbleException;

public enum VCFHeaderVersion {
    VCF3_2("VCRv3.2", "format"),
    VCF3_3("VCFv3.3", "fileformat"),
    VCF4_0("VCFv4.0", "fileformat"),
    VCF4_1("VCFv4.1", "fileformat");

    private final String versionString;
    private final String formatString;

    private VCFHeaderVersion(String string2, String string3) {
        this.versionString = string2;
        this.formatString = string3;
    }

    public static VCFHeaderVersion toHeaderVersion(String string) {
        string = VCFHeaderVersion.clean(string);
        for (VCFHeaderVersion vCFHeaderVersion : VCFHeaderVersion.values()) {
            if (!vCFHeaderVersion.versionString.equals(string)) continue;
            return vCFHeaderVersion;
        }
        return null;
    }

    public static boolean isVersionString(String string) {
        return VCFHeaderVersion.toHeaderVersion(string) != null;
    }

    public static boolean isFormatString(String string) {
        string = VCFHeaderVersion.clean(string);
        for (VCFHeaderVersion vCFHeaderVersion : VCFHeaderVersion.values()) {
            if (!vCFHeaderVersion.formatString.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static VCFHeaderVersion getHeaderVersion(String string) {
        String[] stringArray = string.split("=");
        if (stringArray.length != 2 || !VCFHeaderVersion.isFormatString(stringArray[0].substring(2))) {
            throw new TribbleException.InvalidHeader(string + " is not a valid VCF version line");
        }
        if (!VCFHeaderVersion.isVersionString(stringArray[1])) {
            throw new TribbleException.InvalidHeader(stringArray[1] + " is not a supported version");
        }
        return VCFHeaderVersion.toHeaderVersion(stringArray[1]);
    }

    private static String clean(String string) {
        return string.trim();
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getFormatString() {
        return this.formatString;
    }
}

