/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.PeekIterator;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.TempStreamFactory;

public class SortingCollection<T>
implements Iterable<T> {
    private final File[] tmpDirs;
    private final long TMP_SPACE_FREE = 0x140000000L;
    private final Codec<T> codec;
    private final Comparator<T> comparator;
    private final int maxRecordsInRam;
    private int numRecordsInRam = 0;
    private T[] ramRecords;
    private boolean iterationStarted = false;
    private boolean doneAdding = false;
    private boolean cleanedUp = false;
    private final List<File> files = new ArrayList<File>();
    private boolean destructiveIteration = true;
    private TempStreamFactory tempStreamFactory = new TempStreamFactory();

    private SortingCollection(Class<T> clazz, Codec<T> codec, Comparator<T> comparator, int n, File ... fileArray) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxRecordsInRam must be > 0");
        }
        if (fileArray == null || fileArray.length == 0) {
            throw new IllegalArgumentException("At least one temp directory must be provided.");
        }
        this.tmpDirs = fileArray;
        this.codec = codec;
        this.comparator = comparator;
        this.maxRecordsInRam = n;
        this.ramRecords = (Object[])Array.newInstance(clazz, n);
    }

    public void add(T t) {
        if (this.doneAdding) {
            throw new IllegalStateException("Cannot add after calling doneAdding()");
        }
        if (this.iterationStarted) {
            throw new IllegalStateException("Cannot add after calling iterator()");
        }
        if (this.numRecordsInRam == this.maxRecordsInRam) {
            this.spillToDisk();
        }
        this.ramRecords[this.numRecordsInRam++] = t;
    }

    public void doneAdding() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cannot call doneAdding() after cleanup() was called.");
        }
        if (this.doneAdding) {
            return;
        }
        this.doneAdding = true;
        if (this.files.isEmpty()) {
            return;
        }
        if (this.numRecordsInRam > 0) {
            this.spillToDisk();
        }
        this.ramRecords = null;
    }

    public boolean isDestructiveIteration() {
        return this.destructiveIteration;
    }

    public void setDestructiveIteration(boolean bl) {
        this.destructiveIteration = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spillToDisk() {
        try {
            Arrays.sort(this.ramRecords, 0, this.numRecordsInRam, this.comparator);
            File file = this.newTempFile();
            OutputStream outputStream = null;
            try {
                outputStream = this.tempStreamFactory.wrapTempOutputStream(new FileOutputStream(file), IOUtil.STANDARD_BUFFER_SIZE);
                this.codec.setOutputStream(outputStream);
                for (int i = 0; i < this.numRecordsInRam; ++i) {
                    this.codec.encode(this.ramRecords[i]);
                    this.ramRecords[i] = null;
                }
                outputStream.flush();
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            this.numRecordsInRam = 0;
            this.files.add(file);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private File newTempFile() throws IOException {
        return IOUtil.newTempFile("sortingcollection.", ".tmp", this.tmpDirs, 0x140000000L);
    }

    @Override
    public CloseableIterator<T> iterator() {
        if (this.cleanedUp) {
            throw new IllegalStateException("Cannot call iterator() after cleanup() was called.");
        }
        this.doneAdding();
        this.iterationStarted = true;
        if (this.files.isEmpty()) {
            return new InMemoryIterator();
        }
        return new MergingIterator();
    }

    public void cleanup() {
        this.iterationStarted = true;
        this.cleanedUp = true;
        IOUtil.deleteFiles(this.files);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> clazz, Codec<T> codec, Comparator<T> comparator, int n, File ... fileArray) {
        return new SortingCollection<T>(clazz, codec, comparator, n, fileArray);
    }

    public static <T> SortingCollection<T> newInstance(Class<T> clazz, Codec<T> codec, Comparator<T> comparator, int n, Collection<File> collection) {
        return new SortingCollection<T>(clazz, codec, comparator, n, collection.toArray(new File[collection.size()]));
    }

    public static <T> SortingCollection<T> newInstance(Class<T> clazz, Codec<T> codec, Comparator<T> comparator, int n) {
        File file = new File(System.getProperty("java.io.tmpdir"));
        return new SortingCollection<T>(clazz, codec, comparator, n, file);
    }

    static class PollableTreeSet<T>
    extends TreeSet<T> {
        PollableTreeSet(Comparator<? super T> comparator) {
            super(comparator);
        }

        public T poll() {
            if (this.isEmpty()) {
                return null;
            }
            Object e = this.first();
            this.remove(e);
            return (T)e;
        }
    }

    class PeekFileRecordIteratorComparator
    implements Comparator<PeekFileRecordIterator> {
        PeekFileRecordIteratorComparator() {
        }

        @Override
        public int compare(PeekFileRecordIterator peekFileRecordIterator, PeekFileRecordIterator peekFileRecordIterator2) {
            int n = SortingCollection.this.comparator.compare(peekFileRecordIterator.peek(), peekFileRecordIterator2.peek());
            if (n == 0) {
                return peekFileRecordIterator.n - peekFileRecordIterator2.n;
            }
            return n;
        }
    }

    class PeekFileRecordIterator
    extends PeekIterator<T> {
        final int n;

        PeekFileRecordIterator(Iterator<T> iterator, int n) {
            super(iterator);
            this.n = n;
        }
    }

    class FileRecordIterator
    implements CloseableIterator<T> {
        private final File file;
        private final FileInputStream is;
        private final Codec<T> codec;
        private T currentRecord = null;

        FileRecordIterator(File file) {
            this.file = file;
            try {
                this.is = new FileInputStream(file);
                this.codec = SortingCollection.this.codec.clone();
                this.codec.setInputStream(SortingCollection.this.tempStreamFactory.wrapTempInputStream(this.is, IOUtil.STANDARD_BUFFER_SIZE));
                this.advance();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeIOException(fileNotFoundException);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object t = this.currentRecord;
            this.advance();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            this.currentRecord = this.codec.decode();
        }

        @Override
        public void close() {
            CloserUtil.close(this.is);
        }
    }

    class MergingIterator
    implements CloseableIterator<T> {
        private final PollableTreeSet<PeekFileRecordIterator> queue;

        MergingIterator() {
            this.queue = new PollableTreeSet<PeekFileRecordIterator>(new PeekFileRecordIteratorComparator());
            int n = 0;
            for (File file : SortingCollection.this.files) {
                FileRecordIterator fileRecordIterator = new FileRecordIterator(file);
                if (fileRecordIterator.hasNext()) {
                    this.queue.add(new PeekFileRecordIterator(fileRecordIterator, n++));
                    continue;
                }
                fileRecordIterator.close();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PeekFileRecordIterator peekFileRecordIterator = this.queue.poll();
            Object t = peekFileRecordIterator.next();
            if (peekFileRecordIterator.hasNext()) {
                this.queue.add(peekFileRecordIterator);
            } else {
                ((CloseableIterator)peekFileRecordIterator.getUnderlyingIterator()).close();
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            while (!this.queue.isEmpty()) {
                PeekFileRecordIterator peekFileRecordIterator = this.queue.poll();
                ((CloseableIterator)peekFileRecordIterator.getUnderlyingIterator()).close();
            }
        }
    }

    class InMemoryIterator
    implements CloseableIterator<T> {
        private int iterationIndex = 0;

        InMemoryIterator() {
            Arrays.sort(SortingCollection.this.ramRecords, 0, SortingCollection.this.numRecordsInRam, SortingCollection.this.comparator);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterationIndex < SortingCollection.this.numRecordsInRam;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = SortingCollection.this.ramRecords[this.iterationIndex];
            if (SortingCollection.this.destructiveIteration) {
                ((SortingCollection)SortingCollection.this).ramRecords[this.iterationIndex] = null;
            }
            ++this.iterationIndex;
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Codec<T>
    extends Cloneable {
        public void setOutputStream(OutputStream var1);

        public void setInputStream(InputStream var1);

        public void encode(T var1);

        public T decode();

        public Codec<T> clone();
    }
}

