/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.naming;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.JVMContext;

public class FileContext
extends JVMContext
implements Serializable {
    private File file = null;

    public FileContext(File file) {
        this.file = file;
    }

    public FileContext(File file, Context parent, String atomicName) {
        super(parent, atomicName);
        this.file = file;
    }

    private synchronized void save() throws NamingException {
        try {
            FileContext clone = (FileContext)this.clone();
            clone.listeners.clear();
            ObjectOutputStream stream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
            stream.writeObject(this);
            stream.close();
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"save", (Throwable)exception);
            throw new NamingException(exception.getMessage());
        }
    }

    public void bind(Name name, Object value) throws NamingException {
        super.bind(name, value);
        this.save();
    }

    public void bind(String name, Object value) throws NamingException {
        super.bind(name, value);
        this.save();
    }

    public Context createSubcontext(Name name) throws NamingException {
        Context result = super.createSubcontext(name);
        this.save();
        return result;
    }

    public Context createSubcontext(String arg0) throws NamingException {
        Context result = super.createSubcontext(arg0);
        this.save();
        return result;
    }

    public void destroySubcontext(Name arg0) throws NamingException {
        super.destroySubcontext(arg0);
        this.save();
    }

    public void destroySubcontext(String arg0) throws NamingException {
        super.destroySubcontext(arg0);
        this.save();
    }

    public void rebind(Name name, Object value) throws NamingException {
        super.rebind(name, value);
        this.save();
    }

    public void rebind(String name, Object value) throws NamingException {
        super.rebind(name, value);
        this.save();
    }

    public Object removeFromEnvironment(String arg0) throws NamingException {
        Object result = super.removeFromEnvironment(arg0);
        this.save();
        return result;
    }

    public void rename(Name nameOld, Name nameNew) throws NamingException {
        super.rename(nameOld, nameNew);
        this.save();
    }

    public void rename(String nameOld, String nameNew) throws NamingException {
        super.rename(nameOld, nameNew);
        this.save();
    }

    public void unbind(Name name) throws NamingException {
        super.unbind(name);
        this.save();
    }

    public void unbind(String name) throws NamingException {
        super.unbind(name);
        this.save();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        FileContext clone = new FileContext(this.file);
        HashMap elements = new HashMap(this.elements);
        Iterator i = elements.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = elements.get(key);
            if (value instanceof JVMContext) {
                JVMContext item = (JVMContext)value;
                value = item.clone();
            }
            elements.put(key, value);
        }
        clone.elements = elements;
        return clone;
    }
}

