/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.concurrent;

import java.util.logging.Logger;

public class WorkerThread
extends Thread {
    private Runnable job = null;
    private boolean finalized = false;

    public WorkerThread(String name, Runnable job) {
        super(name);
        this.job = job;
        this.setDaemon(false);
        this.setPriority(5);
        this.start();
    }

    public synchronized void finalize() {
        this.finalized = true;
        try {
            super.finalize();
        }
        catch (Throwable exception) {
            Logger.getLogger("nl.tudelft.simulation.language.concurrent").warning(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public synchronized void run() {
        while (!this.finalized) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
                try {
                    this.job.run();
                }
                catch (Exception exception) {
                    Logger.getLogger("nl.tudelft.simulation.language.concurrent").severe(exception.getMessage());
                    exception.printStackTrace();
                }
                Thread.interrupted();
            }
        }
    }
}

