/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble.sampling;

import cern.colt.PersistentObject;
import cern.colt.list.tboolean.BooleanArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.random.tdouble.AbstractDoubleDistribution;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class WeightedDoubleRandomSampler
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected int skip;
    protected int nextTriggerPos;
    protected int nextSkip;
    protected int weight;
    protected DoubleUniform generator;
    static final int UNDEFINED = -1;

    public WeightedDoubleRandomSampler() {
        this(1, null);
    }

    public WeightedDoubleRandomSampler(int weight, DoubleRandomEngine randomGenerator) {
        if (randomGenerator == null) {
            randomGenerator = AbstractDoubleDistribution.makeDefaultGenerator();
        }
        this.generator = new DoubleUniform(randomGenerator);
        this.setWeight(weight);
    }

    public Object clone() {
        WeightedDoubleRandomSampler copy = (WeightedDoubleRandomSampler)super.clone();
        copy.generator = (DoubleUniform)this.generator.clone();
        return copy;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean sampleNextElement() {
        if (this.skip > 0) {
            --this.skip;
            return false;
        }
        if (this.nextTriggerPos == -1) {
            this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
            this.nextSkip = this.weight - 1 - this.nextTriggerPos;
        }
        if (this.nextTriggerPos > 0) {
            --this.nextTriggerPos;
            return false;
        }
        this.nextTriggerPos = -1;
        this.skip = this.nextSkip;
        return true;
    }

    public void setWeight(int weight) {
        if (weight < 1) {
            throw new IllegalArgumentException("bad weight");
        }
        this.weight = weight;
        this.skip = 0;
        this.nextTriggerPos = -1;
        this.nextSkip = 0;
    }

    public static void test(int weight, int size) {
        WeightedDoubleRandomSampler sampler = new WeightedDoubleRandomSampler();
        sampler.setWeight(weight);
        IntArrayList sample = new IntArrayList();
        for (int i = 0; i < size; ++i) {
            if (!sampler.sampleNextElement()) continue;
            sample.add(i);
        }
        System.out.println("Sample = " + sample);
    }

    private void xsampleNextElements(BooleanArrayList acceptList) {
        int length = acceptList.size();
        boolean[] accept = acceptList.elements();
        for (int i = 0; i < length; ++i) {
            if (this.skip > 0) {
                --this.skip;
                accept[i] = false;
                continue;
            }
            if (this.nextTriggerPos == -1) {
                this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
                this.nextSkip = this.weight - 1 - this.nextTriggerPos;
            }
            if (this.nextTriggerPos > 0) {
                --this.nextTriggerPos;
                accept[i] = false;
                continue;
            }
            this.nextTriggerPos = -1;
            this.skip = this.nextSkip;
            accept[i] = true;
        }
    }
}

