/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble.sampling;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.jet.random.tdouble.AbstractDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class DoubleRandomSampler
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    long my_n;
    long my_N;
    long my_low;
    DoubleRandomEngine my_RandomGenerator;

    public DoubleRandomSampler(long n, long N, long low, DoubleRandomEngine randomGenerator) {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        if (n > N) {
            throw new IllegalArgumentException("n must by <= N");
        }
        this.my_n = n;
        this.my_N = N;
        this.my_low = low;
        if (randomGenerator == null) {
            randomGenerator = AbstractDoubleDistribution.makeDefaultGenerator();
        }
        this.my_RandomGenerator = randomGenerator;
    }

    public Object clone() {
        DoubleRandomSampler copy = (DoubleRandomSampler)super.clone();
        copy.my_RandomGenerator = (DoubleRandomEngine)this.my_RandomGenerator.clone();
        return copy;
    }

    public static void main(String[] args) {
        long n = Long.parseLong(args[0]);
        long N = Long.parseLong(args[1]);
        long low = Long.parseLong(args[2]);
        int chunkSize = Integer.parseInt(args[3]);
        int times = Integer.parseInt(args[4]);
        DoubleRandomSampler.test(n, N, low, chunkSize, times);
    }

    public void nextBlock(int count, long[] values, int fromIndex) {
        if ((long)count > this.my_n) {
            throw new IllegalArgumentException("Random sample exhausted.");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count.");
        }
        if (count == 0) {
            return;
        }
        DoubleRandomSampler.sample(this.my_n, this.my_N, count, this.my_low, values, fromIndex, this.my_RandomGenerator);
        long lastSample = values[fromIndex + count - 1];
        this.my_n -= (long)count;
        this.my_N = this.my_N - lastSample - 1L + this.my_low;
        this.my_low = lastSample + 1L;
    }

    protected static void rejectMethodD(long n, long N, int count, long low, long[] values, int fromIndex, DoubleRandomEngine randomGenerator) {
        int iter;
        long S;
        n = N - n;
        long chosen = -1L + low;
        long negalphainv = -13L;
        double nreal = n;
        double ninv = 1.0 / nreal;
        double Nreal = N;
        double Vprime = Math.exp(Math.log(randomGenerator.raw()) * ninv);
        long qu1 = -n + 1L + N;
        double qu1real = -nreal + 1.0 + Nreal;
        while (n > 1L && count > 0) {
            double negSreal;
            double nmin1inv = 1.0 / (-1.0 + nreal);
            while (true) {
                long limit;
                double bottom;
                double X;
                if ((S = (long)(X = Nreal * (-Vprime + 1.0))) >= qu1) {
                    Vprime = Math.exp(Math.log(randomGenerator.raw()) * ninv);
                    continue;
                }
                double U = randomGenerator.raw();
                negSreal = -S;
                double y1 = Math.exp(Math.log(U * Nreal / qu1real) * nmin1inv);
                Vprime = y1 * (-X / Nreal + 1.0) * (qu1real / (negSreal + qu1real));
                if (Vprime <= 1.0) break;
                double y2 = 1.0;
                double top = -1.0 + Nreal;
                if (n - 1L > S) {
                    bottom = -nreal + Nreal;
                    limit = -S + N;
                } else {
                    bottom = -1.0 + negSreal + Nreal;
                    limit = qu1;
                }
                for (long t = N - 1L; t >= limit; --t) {
                    y2 = y2 * top / bottom;
                    top -= 1.0;
                    bottom -= 1.0;
                }
                if (Nreal / (-X + Nreal) >= y1 * Math.exp(Math.log(y2) * nmin1inv)) {
                    Vprime = Math.exp(Math.log(randomGenerator.raw()) * nmin1inv);
                    break;
                }
                Vprime = Math.exp(Math.log(randomGenerator.raw()) * ninv);
            }
            iter = count;
            if (S < (long)iter) {
                iter = (int)S;
            }
            count -= iter;
            while (--iter >= 0) {
                values[fromIndex++] = ++chosen;
            }
            ++chosen;
            N -= S + 1L;
            Nreal = negSreal + (-1.0 + Nreal);
            --n;
            nreal -= 1.0;
            ninv = nmin1inv;
            qu1 = -S + qu1;
            qu1real = negSreal + qu1real;
        }
        if (count > 0) {
            S = (long)((double)N * Vprime);
            iter = count;
            if (S < (long)iter) {
                iter = (int)S;
            }
            count -= iter;
            while (--iter >= 0) {
                values[fromIndex++] = ++chosen;
            }
            ++chosen;
            while (--count >= 0) {
                values[fromIndex++] = ++chosen;
            }
        }
    }

    public static void sample(long n, long N, int count, long low, long[] values, int fromIndex, DoubleRandomEngine randomGenerator) {
        if (n <= 0L || count <= 0) {
            return;
        }
        if ((long)count > n) {
            throw new IllegalArgumentException("count must not be greater than n");
        }
        if (randomGenerator == null) {
            randomGenerator = AbstractDoubleDistribution.makeDefaultGenerator();
        }
        if ((long)count == N) {
            long val = low;
            int limit = fromIndex + count;
            int i = fromIndex;
            while (i < limit) {
                values[i++] = val++;
            }
            return;
        }
        if ((double)n < (double)N * 0.95) {
            DoubleRandomSampler.sampleMethodD(n, N, count, low, values, fromIndex, randomGenerator);
        } else {
            DoubleRandomSampler.rejectMethodD(n, N, count, low, values, fromIndex, randomGenerator);
        }
    }

    protected static void sampleMethodA(long n, long N, int count, long low, long[] values, int fromIndex, DoubleRandomEngine randomGenerator) {
        long S;
        long chosen = -1L + low;
        double top = N - n;
        double Nreal = N;
        while (n >= 2L && count > 0) {
            double V = randomGenerator.raw();
            S = 0L;
            double quot = top / Nreal;
            while (quot > V) {
                ++S;
                quot = quot * (top -= 1.0) / (Nreal -= 1.0);
            }
            values[fromIndex++] = chosen += S + 1L;
            --count;
            Nreal -= 1.0;
            --n;
        }
        if (count > 0) {
            S = (long)((double)Math.round(Nreal) * randomGenerator.raw());
            values[fromIndex] = chosen += S + 1L;
        }
    }

    protected static void sampleMethodD(long n, long N, int count, long low, long[] values, int fromIndex, DoubleRandomEngine randomGenerator) {
        long S;
        long chosen = -1L + low;
        long negalphainv = -13L;
        double nreal = n;
        double ninv = 1.0 / nreal;
        double Nreal = N;
        double Vprime = Math.exp(Math.log(randomGenerator.raw()) * ninv);
        long qu1 = -n + 1L + N;
        double qu1real = -nreal + 1.0 + Nreal;
        for (long threshold = -negalphainv * n; n > 1L && count > 0 && threshold < N; threshold += negalphainv) {
            double negSreal;
            double nmin1inv = 1.0 / (-1.0 + nreal);
            while (true) {
                long limit;
                double bottom;
                double X;
                if ((S = (long)(X = Nreal * (-Vprime + 1.0))) >= qu1) {
                    Vprime = Math.exp(Math.log(randomGenerator.raw()) * ninv);
                    continue;
                }
                double U = randomGenerator.raw();
                negSreal = -S;
                double y1 = Math.exp(Math.log(U * Nreal / qu1real) * nmin1inv);
                Vprime = y1 * (-X / Nreal + 1.0) * (qu1real / (negSreal + qu1real));
                if (Vprime <= 1.0) break;
                double y2 = 1.0;
                double top = -1.0 + Nreal;
                if (n - 1L > S) {
                    bottom = -nreal + Nreal;
                    limit = -S + N;
                } else {
                    bottom = -1.0 + negSreal + Nreal;
                    limit = qu1;
                }
                for (long t = N - 1L; t >= limit; --t) {
                    y2 = y2 * top / bottom;
                    top -= 1.0;
                    bottom -= 1.0;
                }
                if (Nreal / (-X + Nreal) >= y1 * Math.exp(Math.log(y2) * nmin1inv)) {
                    Vprime = Math.exp(Math.log(randomGenerator.raw()) * nmin1inv);
                    break;
                }
                Vprime = Math.exp(Math.log(randomGenerator.raw()) * ninv);
            }
            values[fromIndex++] = chosen += S + 1L;
            --count;
            N -= S + 1L;
            Nreal = negSreal + (-1.0 + Nreal);
            --n;
            nreal -= 1.0;
            ninv = nmin1inv;
            qu1 = -S + qu1;
            qu1real = negSreal + qu1real;
        }
        if (count > 0) {
            if (n > 1L) {
                DoubleRandomSampler.sampleMethodA(n, N, count, chosen + 1L, values, fromIndex, randomGenerator);
            } else {
                S = (long)((double)N * Vprime);
                values[fromIndex++] = chosen += S + 1L;
            }
        }
    }

    public static void test(long n, long N, long low, int chunkSize, int times) {
        long[] values = new long[chunkSize];
        long chunks = n / (long)chunkSize;
        Timer timer = new Timer().start();
        long t = times;
        while (--t >= 0L) {
            DoubleRandomSampler sampler = new DoubleRandomSampler(n, N, low, AbstractDoubleDistribution.makeDefaultGenerator());
            for (long i = 0L; i < chunks; ++i) {
                sampler.nextBlock(chunkSize, values, 0);
            }
            int toDo = (int)(n - (long)chunkSize * chunks);
            if (toDo <= 0) continue;
            sampler.nextBlock(toDo, values, 0);
        }
        timer.stop();
        System.out.println("single run took " + timer.elapsedTime() / (double)times);
        System.out.println("Good bye.\n");
    }

    protected static void testNegAlphaInv(String[] args) {
    }
}

