/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;

class SelectedDenseObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseObjectMatrix1D(Object[] elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedDenseObjectMatrix1D(int size, Object[] elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    public Object elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public Object getQuick(int index) {
        return this.elements[this.offset + this.offsets[this.zero + index * this.stride]];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D other) {
        if (other instanceof SelectedDenseObjectMatrix1D) {
            SelectedDenseObjectMatrix1D otherMatrix = (SelectedDenseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix1D) {
            DenseObjectMatrix1D otherMatrix = (DenseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    public long index(int rank) {
        return this.offset + this.offsets[this.zero + rank * this.stride];
    }

    public ObjectMatrix1D like(int size) {
        return new DenseObjectMatrix1D(size);
    }

    public ObjectMatrix2D like2D(int rows, int columns) {
        return new DenseObjectMatrix2D(rows, columns);
    }

    public void setQuick(int index, Object value) {
        this.elements[this.offset + this.offsets[this.zero + index * this.stride]] = value;
    }

    public ObjectMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public ObjectMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    protected ObjectMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseObjectMatrix1D(this.elements, offsets);
    }
}

