/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

class SelectedSparseIntMatrix2D
extends IntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseIntMatrix2D(AbstractLongIntMap elements, int[] rowOffsets, int[] columnOffsets, int offset) {
        this(rowOffsets.length, columnOffsets.length, elements, 0, 0, 1, 1, rowOffsets, columnOffsets, offset);
    }

    protected SelectedSparseIntMatrix2D(int rows, int columns, AbstractLongIntMap elements, int rowZero, int columnZero, int rowStride, int columnStride, int[] rowOffsets, int[] columnOffsets, int offset) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public AbstractLongIntMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public int getQuick(int row, int column) {
        return this.elements.get((long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride]);
    }

    public long index(int row, int column) {
        return (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    public IntMatrix2D like(int rows, int columns) {
        return new SparseIntMatrix2D(rows, columns);
    }

    public IntMatrix1D like1D(int size) {
        return new SparseIntMatrix1D(size);
    }

    public void setQuick(int row, int column, int value) {
        long index = (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
        if (value == 0) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    public IntMatrix1D vectorize() {
        SparseIntMatrix1D v = new SparseIntMatrix1D((int)this.size());
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.setQuick(idx++, this.getQuick(c, r));
            }
        }
        return v;
    }

    public IntMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.rowZero;
        int viewStride = this.rowStride;
        int[] viewOffsets = this.rowOffsets;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        return new SelectedSparseIntMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    public IntMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.columnZero;
        int viewStride = this.columnStride;
        int[] viewOffsets = this.columnOffsets;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        return new SelectedSparseIntMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D other) {
        if (other instanceof SelectedSparseIntMatrix2D) {
            SelectedSparseIntMatrix2D otherMatrix = (SelectedSparseIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseIntMatrix2D) {
            SparseIntMatrix2D otherMatrix = (SparseIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected IntMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    protected void setUp(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] tmp = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = tmp;
        this.isNoView = false;
        return this;
    }

    protected IntMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseIntMatrix2D(this.elements, rowOffsets, columnOffsets, this.offset);
    }
}

