/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix2D;

class SelectedDenseIntMatrix3D
extends IntMatrix3D {
    private static final long serialVersionUID = 1L;
    protected int[] elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseIntMatrix3D(int[] elements, int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets, int offset) {
        int slices = sliceOffsets.length;
        int rows = rowOffsets.length;
        int columns = columnOffsets.length;
        this.setUp(slices, rows, columns);
        this.elements = elements;
        this.sliceOffsets = sliceOffsets;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public int[] elements() {
        throw new IllegalAccessError("getElements() is not supported for SelectedDenseIntMatrix3D.");
    }

    public int getQuick(int slice, int row, int column) {
        return this.elements[this.offset + this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]];
    }

    public long index(int slice, int row, int column) {
        return this.offset + this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    public IntMatrix3D like(int slices, int rows, int columns) {
        return new DenseIntMatrix3D(slices, rows, columns);
    }

    public IntMatrix2D like2D(int rows, int columns) {
        return new DenseIntMatrix2D(rows, columns);
    }

    public void setQuick(int slice, int row, int column, int value) {
        this.elements[this.offset + this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]] = value;
    }

    public IntMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int viewRows = this.slices;
        int viewColumns = this.rows;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.rowZero;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.rowStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.rowOffsets;
        return new SelectedDenseIntMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    public IntMatrix2D viewRow(int row) {
        this.checkRow(row);
        int viewRows = this.slices;
        int viewColumns = this.columns;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedDenseIntMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    public IntMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int viewRows = this.rows;
        int viewColumns = this.columns;
        int viewRowZero = this.rowZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._sliceOffset(this._sliceRank(slice));
        int viewRowStride = this.rowStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.rowOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedDenseIntMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    protected int _sliceOffset(int absRank) {
        return this.sliceOffsets[absRank];
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D other) {
        if (other instanceof SelectedDenseIntMatrix3D) {
            SelectedDenseIntMatrix3D otherMatrix = (SelectedDenseIntMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseIntMatrix3D) {
            DenseIntMatrix3D otherMatrix = (DenseIntMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected IntMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        throw new InternalError();
    }

    protected void setUp(int slices, int rows, int columns) {
        super.setUp(slices, rows, columns);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int axis0, int axis1, int axis2) {
        super.vDice(axis0, axis1, axis2);
        int[][] offsets = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = offsets[axis0];
        this.rowOffsets = offsets[axis1];
        this.columnOffsets = offsets[axis2];
        return this;
    }

    protected IntMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseIntMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, this.offset);
    }
}

