/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;

class SelectedDenseFloatMatrix1D
extends FloatMatrix1D {
    private static final long serialVersionUID = 1L;
    protected float[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseFloatMatrix1D(float[] elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedDenseFloatMatrix1D(int size, float[] elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public float[] elements() {
        return this.elements;
    }

    public float getQuick(int index) {
        return this.elements[this.offset + this.offsets[this.zero + index * this.stride]];
    }

    public long index(int rank) {
        return this.offset + this.offsets[this.zero + rank * this.stride];
    }

    public FloatMatrix1D like(int size) {
        return new DenseFloatMatrix1D(size);
    }

    public FloatMatrix2D like2D(int rows, int columns) {
        return new DenseFloatMatrix2D(rows, columns);
    }

    public FloatMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseFloatMatrix2D M = new DenseFloatMatrix2D(rows, columns);
        float[] elementsOther = (float[])((FloatMatrix2D)M).elements();
        int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        int rowStrideOther = M.rowStride();
        int colStrideOther = M.columnStride();
        int idx = 0;
        for (int c = 0; c < columns; ++c) {
            int idxOther = zeroOther + c * colStrideOther;
            for (int r = 0; r < rows; ++r) {
                elementsOther[idxOther] = this.getQuick(idx++);
                idxOther += rowStrideOther;
            }
        }
        return M;
    }

    public FloatMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseFloatMatrix3D M = new DenseFloatMatrix3D(slices, rows, columns);
        float[] elementsOther = (float[])((FloatMatrix3D)M).elements();
        int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        int sliceStrideOther = M.sliceStride();
        int rowStrideOther = M.rowStride();
        int colStrideOther = M.columnStride();
        int idx = 0;
        for (int s = 0; s < slices; ++s) {
            for (int c = 0; c < columns; ++c) {
                int idxOther = zeroOther + s * sliceStrideOther + c * colStrideOther;
                for (int r = 0; r < rows; ++r) {
                    elementsOther[idxOther] = this.getQuick(idx++);
                    idxOther += rowStrideOther;
                }
            }
        }
        return M;
    }

    public void setQuick(int index, float value) {
        this.elements[this.offset + this.offsets[this.zero + index * this.stride]] = value;
    }

    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    protected boolean haveSharedCellsRaw(FloatMatrix1D other) {
        if (other instanceof SelectedDenseFloatMatrix1D) {
            SelectedDenseFloatMatrix1D otherMatrix = (SelectedDenseFloatMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseFloatMatrix1D) {
            DenseFloatMatrix1D otherMatrix = (DenseFloatMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    protected FloatMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseFloatMatrix1D(this.elements, offsets);
    }
}

