/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import edu.emory.mathcs.utils.IOUtils;
import java.util.Random;

public class AccuracyCheckFloatFFT {
    private static int[] sizesPrimes = new int[]{997, 4999, 9973, 49999, 99991, 249989};
    private static int[] sizesPower2 = new int[]{8192, 16384, 32768, 65536, 131072, 262144};
    private static final int niters = 10;
    private static Random r;

    private AccuracyCheckFloatFFT() {
    }

    public static void checkAccuracyRealFFT_1D() {
        DenseFloatMatrix1D Mr;
        DenseFComplexMatrix1D Mc;
        DenseFloatMatrix1D M;
        int j;
        int i;
        System.out.println("Checking accuracy of 1D real forward full FFT (prime sizes)...");
        double[][] errors = new double[10][sizesPrimes.length];
        for (i = 0; i < sizesPrimes.length; ++i) {
            r = new Random(0L);
            for (j = 0; j < 10; ++j) {
                M = new DenseFloatMatrix1D(sizesPrimes[i]);
                AccuracyCheckFloatFFT.fillMatrix_1D(sizesPrimes[i], M.elements());
                Mc = M.getFft();
                Mc.ifft(true);
                Mr = (DenseFloatMatrix1D)Mc.getRealPart();
                errors[j][i] = AccuracyCheckFloatFFT.computeRMSE(M.elements(), Mr.elements());
            }
        }
        IOUtils.writeToFileReal_2D("%g", errors, "pc_rmse_primes_float.txt");
        System.out.println("Checking accuracy of 1D real forward full FFT (power2 sizes)...");
        errors = new double[10][sizesPower2.length];
        for (i = 0; i < sizesPower2.length; ++i) {
            r = new Random(0L);
            for (j = 0; j < 10; ++j) {
                M = new DenseFloatMatrix1D(sizesPower2[i]);
                AccuracyCheckFloatFFT.fillMatrix_1D(sizesPower2[i], M.elements());
                Mc = M.getFft();
                Mc.ifft(true);
                Mr = (DenseFloatMatrix1D)Mc.getRealPart();
                errors[j][i] = AccuracyCheckFloatFFT.computeRMSE(M.elements(), Mr.elements());
            }
        }
        IOUtils.writeToFileReal_2D("%g", errors, "pc_rmse_power2_float.txt");
    }

    private static double computeRMSE(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        float rms = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            float tmp = a[i] - b[i];
            rms += tmp * tmp;
        }
        return Math.sqrt(rms / (float)a.length);
    }

    public static void main(String[] args) {
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_1D();
        System.exit(0);
    }

    private static void fillMatrix_1D(int N, float[] m) {
        for (int i = 0; i < N; ++i) {
            m[i] = r.nextFloat();
        }
    }
}

