/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatGivensRotation;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatGMRES
extends AbstractFloatIterativeSolver {
    private int restart;
    private FloatMatrix1D w;
    private FloatMatrix1D u;
    private FloatMatrix1D r;
    private FloatMatrix1D[] v;
    private FloatMatrix1D s;
    private FloatMatrix2D H;
    private FloatGivensRotation[] rotation;

    public FloatGMRES(FloatMatrix1D template) {
        this(template, 30);
    }

    public FloatGMRES(FloatMatrix1D template, int restart) {
        this.w = template.copy();
        this.u = template.copy();
        this.r = template.copy();
        this.setRestart(restart);
    }

    public void setRestart(int restart) {
        this.restart = restart;
        if (restart <= 0) {
            throw new IllegalArgumentException("restart must be a positive integer");
        }
        this.s = new DenseFloatMatrix1D(restart + 1);
        this.H = new DenseFloatMatrix2D(restart + 1, restart);
        this.rotation = new FloatGivensRotation[restart + 1];
        this.v = new FloatMatrix1D[restart + 1];
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = new DenseFloatMatrix1D((int)this.r.size());
        }
    }

    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(A, b, x);
        A.zMult(x, this.u.assign(b), -1.0f, 1.0f, false);
        this.M.apply(this.u, this.r);
        float normr = DenseFloatAlgebra.DEFAULT.norm(this.r, Norm.Two);
        this.M.apply(b, this.u);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            int i;
            this.v[0].assign(this.r, FloatFunctions.multSecond(1.0f / normr));
            this.s.assign(0.0f).setQuick(0, normr);
            for (i = 0; i < this.restart && !this.iter.converged(Math.abs(this.s.getQuick(i))); ++i) {
                int k;
                A.zMult(this.v[i], this.u);
                this.M.apply(this.u, this.w);
                for (k = 0; k <= i; ++k) {
                    this.H.setQuick(k, i, this.w.zDotProduct(this.v[k]));
                    this.w.assign(this.v[k], FloatFunctions.plusMultSecond(-this.H.getQuick(k, i)));
                }
                this.H.setQuick(i + 1, i, DenseFloatAlgebra.DEFAULT.norm(this.w, Norm.Two));
                this.v[i + 1].assign(this.w, FloatFunctions.multSecond(1.0f / this.H.getQuick(i + 1, i)));
                for (k = 0; k < i; ++k) {
                    this.rotation[k].apply(this.H, i, k, k + 1);
                }
                this.rotation[i] = new FloatGivensRotation(this.H.getQuick(i, i), this.H.getQuick(i + 1, i));
                this.rotation[i].apply(this.H, i, i, i + 1);
                this.rotation[i].apply(this.s, i, i + 1);
                this.iter.next();
            }
            this.s = DenseFloatAlgebra.DEFAULT.backwardSolve(this.H.viewPart(0, 0, i, i), this.s);
            for (int j = 0; j < i; ++j) {
                x.assign(this.v[j], FloatFunctions.plusMultSecond(this.s.getQuick(j)));
            }
            A.zMult(x, this.u.assign(b), -1.0f, 1.0f, false);
            this.M.apply(this.u, this.r);
            normr = DenseFloatAlgebra.DEFAULT.norm(this.r, Norm.Two);
            this.iter.next();
        }
        return x;
    }
}

