/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2DProcedure;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FComplexMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected FComplexMatrix3D() {
    }

    public float[] aggregate(final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFunction f) {
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] a = f.apply(FComplexMatrix3D.this.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = d; c < FComplexMatrix3D.this.columns; ++c) {
                                    a = aggr.apply(a, f.apply(FComplexMatrix3D.this.getQuick(s, r, c)));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0));
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c)));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    public float[] aggregate(final FComplexMatrix3D other, final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFComplexFunction f) {
        this.checkShape(other);
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] a = f.apply(FComplexMatrix3D.this.getQuick(firstSlice, 0, 0), other.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = d; c < FComplexMatrix3D.this.columns; ++c) {
                                    a = aggr.apply(a, f.apply(FComplexMatrix3D.this.getQuick(s, r, c), other.getQuick(s, r, c)));
                                }
                                d = 0;
                            }
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c), other.getQuick(s, r, c)));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    public FComplexMatrix3D assign(final FComplexFComplexFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, function.apply(FComplexMatrix3D.this.getQuick(s, r, c)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c)));
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexRealFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] tmp = new float[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    tmp[0] = function.apply(FComplexMatrix3D.this.getQuick(s, r, c));
                                    FComplexMatrix3D.this.setQuick(s, r, c, tmp);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp = new float[2];
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        tmp[0] = function.apply(this.getQuick(s, r, c));
                        this.setQuick(s, r, c, tmp);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexProcedure cond, final FComplexFComplexFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    float[] elem = FComplexMatrix3D.this.getQuick(s, r, c);
                                    if (!cond.apply(elem)) continue;
                                    FComplexMatrix3D.this.setQuick(s, r, c, f.apply(elem));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        float[] elem = this.getQuick(s, r, c);
                        if (!cond.apply(elem)) continue;
                        this.setQuick(s, r, c, f.apply(elem));
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexProcedure cond, final float[] value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    float[] elem = FComplexMatrix3D.this.getQuick(s, r, c);
                                    if (!cond.apply(elem)) continue;
                                    FComplexMatrix3D.this.setQuick(s, r, c, value);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        float[] elem = this.getQuick(s, r, c);
                        if (!cond.apply(elem)) continue;
                        this.setQuick(s, r, c, value);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(FComplexMatrix3D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final FComplexMatrix3D B = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, B.getQuick(s, r, c));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, B.getQuick(s, r, c));
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexMatrix3D y, final FComplexFComplexFComplexFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, function.apply(FComplexMatrix3D.this.getQuick(s, r, c), y.getQuick(s, r, c)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c), y.getQuick(s, r, c)));
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float re, final float im) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, re, im);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, re, im);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float[] values) {
        if (values.length != this.slices * this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*2*columns()=" + this.slices() * this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = firstSlice * FComplexMatrix3D.this.rows * FComplexMatrix3D.this.columns * 2;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, values[idx], values[idx + 1]);
                                    idx += 2;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, values[idx], values[idx + 1]);
                        idx += 2;
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            float[][] currentSlice = values[s];
                            if (currentSlice.length != FComplexMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + FComplexMatrix3D.this.rows());
                            }
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                float[] currentRow = currentSlice[r];
                                if (currentRow.length != 2 * FComplexMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * FComplexMatrix3D.this.columns());
                                }
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, currentRow[2 * c], currentRow[2 * c + 1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                float[][] currentSlice = values[s];
                if (currentSlice.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                }
                for (int r = 0; r < this.rows; ++r) {
                    float[] currentRow = currentSlice[r];
                    if (currentRow.length != 2 * this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * this.columns());
                    }
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, currentRow[2 * c], currentRow[2 * c + 1]);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assignImaginary(final FloatMatrix3D other) {
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    float re = FComplexMatrix3D.this.getQuick(s, r, c)[0];
                                    float im = other.getQuick(s, r, c);
                                    FComplexMatrix3D.this.setQuick(s, r, c, re, im);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        float re = this.getQuick(s, r, c)[0];
                        float im = other.getQuick(s, r, c);
                        this.setQuick(s, r, c, re, im);
                    }
                }
            }
        }
        return this;
    }

    public FComplexMatrix3D assignReal(final FloatMatrix3D other) {
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    float re = other.getQuick(s, r, c);
                                    float im = FComplexMatrix3D.this.getQuick(s, r, c)[1];
                                    FComplexMatrix3D.this.setQuick(s, r, c, re, im);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        float re = other.getQuick(s, r, c);
                        float im = this.getQuick(s, r, c)[1];
                        this.setQuick(s, r, c, re, im);
                    }
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        float[] tmp = new float[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    tmp = FComplexMatrix3D.this.getQuick(s, r, c);
                                    if ((double)tmp[0] == 0.0 && (double)tmp[1] == 0.0) continue;
                                    ++cardinality;
                                }
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            float[] tmp = new float[2];
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        tmp = this.getQuick(s, r, c);
                        if (tmp[0] == 0.0f && tmp[1] == 0.0f) continue;
                        ++cardinality;
                    }
                }
            }
        }
        return cardinality;
    }

    public FComplexMatrix3D copy() {
        return this.like().assign(this);
    }

    public boolean equals(float[] value) {
        return FComplexProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FComplexMatrix3D)) {
            return false;
        }
        return FComplexProperty.DEFAULT.equals(this, (FComplexMatrix3D)obj);
    }

    public float[] get(int slice, int row, int column) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        return this.getQuick(slice, row, column);
    }

    public abstract Object elements();

    public abstract FloatMatrix3D getImaginaryPart();

    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, ArrayList<float[]> valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    float[] value = this.getQuick(s, r, c);
                    if (value[0] == 0.0f && value[1] == 0.0f) continue;
                    sliceList.add(s);
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
            }
        }
    }

    public abstract float[] getQuick(int var1, int var2, int var3);

    public abstract FloatMatrix3D getRealPart();

    public FComplexMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract FComplexMatrix3D like(int var1, int var2, int var3);

    public void set(int slice, int row, int column, float[] value) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, value);
    }

    public void set(int slice, int row, int column, float re, float im) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, re, im);
    }

    public abstract void setQuick(int var1, int var2, int var3, float var4, float var5);

    public abstract void setQuick(int var1, int var2, int var3, float[] var4);

    public float[][][] toArray() {
        final float[][][] values = new float[this.slices][this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] tmp = new float[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            float[][] currentSlice = values[s];
                            for (int r = 0; r < FComplexMatrix3D.this.rows; ++r) {
                                float[] currentRow = currentSlice[r];
                                for (int c = 0; c < FComplexMatrix3D.this.columns; ++c) {
                                    tmp = FComplexMatrix3D.this.getQuick(s, r, c);
                                    currentRow[2 * c] = tmp[0];
                                    currentRow[2 * c + 1] = tmp[1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp = new float[2];
            for (int s = 0; s < this.slices; ++s) {
                float[][] currentSlice = values[s];
                for (int r = 0; r < this.rows; ++r) {
                    float[] currentRow = currentSlice[r];
                    for (int c = 0; c < this.columns; ++c) {
                        tmp = this.getQuick(s, r, c);
                        currentRow[2 * c] = tmp[0];
                        currentRow[2 * c + 1] = tmp[1];
                    }
                }
            }
        }
        return values;
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String format) {
        StringBuffer sb = new StringBuffer(String.format("ComplexMatrix3D: %d slices, %d rows, %d columns\n\n", this.slices, this.rows, this.columns));
        float[] elem = new float[2];
        for (int s = 0; s < this.slices; ++s) {
            sb.append(String.format("(:,:,%d)=\n", s));
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    elem = this.getQuick(s, r, c);
                    if (elem[1] == 0.0f) {
                        sb.append(String.format(format + "\t", Float.valueOf(elem[0])));
                        continue;
                    }
                    if (elem[0] == 0.0f) {
                        sb.append(String.format(format + "i\t", Float.valueOf(elem[1])));
                        continue;
                    }
                    if (elem[1] < 0.0f) {
                        sb.append(String.format(format + " - " + format + "i\t", Float.valueOf(elem[0]), Float.valueOf(-elem[1])));
                        continue;
                    }
                    sb.append(String.format(format + " + " + format + "i\t", Float.valueOf(elem[0]), Float.valueOf(elem[1])));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public abstract FComplexMatrix1D vectorize();

    public FComplexMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int sliceRows = this.slices;
        int sliceColumns = this.rows;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.rowZero + this._columnOffset(this._columnRank(column));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.rowStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FComplexMatrix3D viewColumnFlip() {
        return (FComplexMatrix3D)this.view().vColumnFlip();
    }

    public FComplexMatrix3D viewDice(int axis0, int axis1, int axis2) {
        return (FComplexMatrix3D)this.view().vDice(axis0, axis1, axis2);
    }

    public FComplexMatrix3D viewPart(int slice, int row, int column, int depth, int height, int width) {
        return (FComplexMatrix3D)this.view().vPart(slice, row, column, depth, height, width);
    }

    public FComplexMatrix2D viewRow(int row) {
        this.checkRow(row);
        int sliceRows = this.slices;
        int sliceColumns = this.columns;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.columnZero + this._rowOffset(this._rowRank(row));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FComplexMatrix3D viewRowFlip() {
        return (FComplexMatrix3D)this.view().vRowFlip();
    }

    public FComplexMatrix3D viewSelection(FComplexMatrix2DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!condition.apply(this.viewSlice(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null, null);
    }

    public FComplexMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        int i2;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i2 = this.slices;
            while (--i2 >= 0) {
                sliceIndexes[i2] = i2;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i2 = this.rows;
            while (--i2 >= 0) {
                rowIndexes[i2] = i2;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i2 = this.columns;
            while (--i2 >= 0) {
                columnIndexes[i2] = i2;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] sliceOffsets = new int[sliceIndexes.length];
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < sliceIndexes.length; ++i) {
            sliceOffsets[i] = this._sliceOffset(this._sliceRank(sliceIndexes[i]));
        }
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(sliceOffsets, rowOffsets, columnOffsets);
    }

    public FComplexMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int sliceRows = this.rows;
        int sliceColumns = this.columns;
        int sliceRowZero = this.rowZero;
        int sliceColumnZero = this.columnZero + this._sliceOffset(this._sliceRank(slice));
        int sliceRowStride = this.rowStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FComplexMatrix3D viewSliceFlip() {
        return (FComplexMatrix3D)this.view().vSliceFlip();
    }

    public FComplexMatrix3D viewStrides(int sliceStride, int rowStride, int columnStride) {
        return (FComplexMatrix3D)this.view().vStrides(sliceStride, rowStride, columnStride);
    }

    public float[] zSum() {
        if (this.size() == 0L) {
            return new float[2];
        }
        return this.aggregate(FComplexFunctions.plus, FComplexFunctions.identity);
    }

    protected FComplexMatrix3D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FComplexMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix3D other) {
        return false;
    }

    protected abstract FComplexMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    protected FComplexMatrix3D view() {
        return (FComplexMatrix3D)this.clone();
    }

    protected abstract FComplexMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public abstract FComplexMatrix2D like2D(int var1, int var2);
}

