/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DelegateDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DiagonalDoubleMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperDoubleMatrix2D
extends DoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected DoubleMatrix2D content;

    public WrapperDoubleMatrix2D(DoubleMatrix2D newContent) {
        block3: {
            if (newContent != null) {
                try {
                    this.setUp(newContent.rows(), newContent.columns());
                }
                catch (IllegalArgumentException exc) {
                    if ("matrix too large".equals(exc.getMessage())) break block3;
                    throw exc;
                }
            }
        }
        this.content = newContent;
    }

    public DoubleMatrix2D assign(final double[] values) {
        if (this.content instanceof DiagonalDoubleMatrix2D) {
            int dlength = ((DiagonalDoubleMatrix2D)this.content).dlength;
            final double[] elems = ((DiagonalDoubleMatrix2D)this.content).elements;
            if (values.length != dlength) {
                throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + dlength);
            }
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, dlength);
                Future[] futures = new Future[nthreads];
                int k = dlength / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                elems[i] = values[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < dlength; ++i) {
                    elems[i] = values[i];
                }
            }
            return this;
        }
        return super.assign(values);
    }

    public DoubleMatrix2D assign(final float[] values) {
        if (this.content instanceof DiagonalDoubleMatrix2D) {
            int dlength = ((DiagonalDoubleMatrix2D)this.content).dlength;
            final double[] elems = ((DiagonalDoubleMatrix2D)this.content).elements;
            if (values.length != dlength) {
                throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + dlength);
            }
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, dlength);
                Future[] futures = new Future[nthreads];
                int k = dlength / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                elems[i] = values[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < dlength; ++i) {
                    elems[i] = values[i];
                }
            }
            return this;
        }
        return super.assign(values);
    }

    public DoubleMatrix2D assign(DoubleMatrix2D y, DoubleDoubleFunction function) {
        this.checkShape(y);
        if (y instanceof WrapperDoubleMatrix2D) {
            IntArrayList rowList = new IntArrayList();
            IntArrayList columnList = new IntArrayList();
            DoubleArrayList valueList = new DoubleArrayList();
            y.getNonZeros(rowList, columnList, valueList);
            this.assign(y, function, rowList, columnList);
        } else {
            super.assign(y, function);
        }
        return this;
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized double getQuick(int row, int column) {
        return this.content.getQuick(row, column);
    }

    public boolean equals(double value) {
        if (this.content instanceof DiagonalDoubleMatrix2D) {
            double epsilon = DoubleProperty.DEFAULT.tolerance();
            double[] elements = (double[])this.content.elements();
            for (int r = 0; r < elements.length; ++r) {
                double x = elements[r];
                double diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0;
                }
                if (diff <= epsilon) continue;
                return false;
            }
            return true;
        }
        return super.equals(value);
    }

    public boolean equals(Object obj) {
        if (this.content instanceof DiagonalDoubleMatrix2D && obj instanceof DiagonalDoubleMatrix2D) {
            double epsilon = DoubleProperty.DEFAULT.tolerance();
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            DiagonalDoubleMatrix2D A = (DiagonalDoubleMatrix2D)this.content;
            DiagonalDoubleMatrix2D B = (DiagonalDoubleMatrix2D)obj;
            if (A.columns() != B.columns() || A.rows() != B.rows() || A.diagonalIndex() != B.diagonalIndex() || A.diagonalLength() != B.diagonalLength()) {
                return false;
            }
            double[] AElements = A.elements();
            double[] BElements = B.elements();
            for (int r = 0; r < AElements.length; ++r) {
                double value = BElements[r];
                double x = AElements[r];
                double diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0;
                }
                if (diff <= epsilon) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public DoubleMatrix2D like(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    public DoubleMatrix1D like1D(int size) {
        return this.content.like1D(size);
    }

    public void dct2(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dct2(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dct2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dctColumns(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dctColumns(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dctColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dctRows(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dctRows(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dctRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst2(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dst2(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dst2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dstColumns(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dstColumns(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dstColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dstRows(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dstRows(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dstRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht2() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dht2();
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dht2();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dhtColumns() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dhtColumns();
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dhtColumns();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dhtRows() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).dhtRows();
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.dhtRows();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft2() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).fft2();
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.fft2();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public DenseLargeDComplexMatrix2D getFft2() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getFft2();
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getFft2();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getIfft2(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getIfft2(scale);
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getIfft2(scale);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getFftColumns() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getFftColumns();
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getFftColumns();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getFftRows() {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getFftRows();
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getFftRows();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getIfftColumns(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeDoubleMatrix2D)this.content).getIfftColumns(scale);
            }
            return ((DenseLargeDoubleMatrix2D)this.copy()).getIfftColumns(scale);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeDComplexMatrix2D getIfftRows(boolean scale) {
        if (this.isNoView) {
            return ((DenseLargeDoubleMatrix2D)this.content).getIfftRows(scale);
        }
        return ((DenseLargeDoubleMatrix2D)this.copy()).getIfftRows(scale);
    }

    public void idct2(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idct2(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idct2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idctColumns(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idctColumns(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idctColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idctRows(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idctRows(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idctRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst2(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idst2(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idst2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idstColumns(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idstColumns(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idstColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idstRows(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idstRows(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idstRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht2(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idht2(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idht2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idhtColumns(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idhtColumns(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idhtColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idhtRows(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).idhtRows(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.idhtRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2(boolean scale) {
        if (this.content instanceof DenseLargeDoubleMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDoubleMatrix2D)this.content).ifft2(scale);
            } else {
                DenseLargeDoubleMatrix2D copy = (DenseLargeDoubleMatrix2D)this.copy();
                copy.ifft2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized void setQuick(int row, int column, double value) {
        this.content.setQuick(row, column, value);
    }

    public DoubleMatrix1D vectorize() {
        final DenseDoubleMatrix1D v = new DenseDoubleMatrix1D((int)this.size());
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                final int firstidx = j * k * this.rows;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = firstidx;
                        for (int c = firstCol; c < lastCol; ++c) {
                            for (int r = 0; r < WrapperDoubleMatrix2D.this.rows; ++r) {
                                v.setQuick(idx++, WrapperDoubleMatrix2D.this.getQuick(r, c));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int c = 0; c < this.columns; ++c) {
                for (int r = 0; r < this.rows; ++r) {
                    v.setQuick(idx++, this.getQuick(r, c));
                }
            }
        }
        return v;
    }

    public DoubleMatrix1D viewColumn(int column) {
        return this.viewDice().viewRow(column);
    }

    public DoubleMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int row, int column) {
                return this.content.getQuick(row, this.columns - 1 - column);
            }

            public synchronized void setQuick(int row, int column, double value) {
                this.content.setQuick(row, this.columns - 1 - column, value);
            }

            public synchronized double get(int row, int column) {
                return this.content.get(row, this.columns - 1 - column);
            }

            public synchronized void set(int row, int column, double value) {
                this.content.set(row, this.columns - 1 - column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    public DoubleMatrix2D viewDice() {
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int row, int column) {
                return this.content.getQuick(column, row);
            }

            public synchronized void setQuick(int row, int column, double value) {
                this.content.setQuick(column, row, value);
            }

            public synchronized double get(int row, int column) {
                return this.content.get(column, row);
            }

            public synchronized void set(int row, int column, double value) {
                this.content.set(column, row, value);
            }
        };
        view.rows = this.columns;
        view.columns = this.rows;
        view.isNoView = false;
        return view;
    }

    public DoubleMatrix2D viewPart(final int row, final int column, int height, int width) {
        this.checkBox(row, column, height, width);
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int i, int j) {
                return this.content.getQuick(row + i, column + j);
            }

            public synchronized void setQuick(int i, int j, double value) {
                this.content.setQuick(row + i, column + j, value);
            }

            public synchronized double get(int i, int j) {
                return this.content.get(row + i, column + j);
            }

            public synchronized void set(int i, int j, double value) {
                this.content.set(row + i, column + j, value);
            }
        };
        view.rows = height;
        view.columns = width;
        view.isNoView = false;
        return view;
    }

    public DoubleMatrix1D viewRow(int row) {
        this.checkRow(row);
        return new DelegateDoubleMatrix1D(this, row);
    }

    public DoubleMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int row, int column) {
                return this.content.getQuick(this.rows - 1 - row, column);
            }

            public synchronized void setQuick(int row, int column, double value) {
                this.content.setQuick(this.rows - 1 - row, column, value);
            }

            public synchronized double get(int row, int column) {
                return this.content.get(this.rows - 1 - row, column);
            }

            public synchronized void set(int row, int column, double value) {
                this.content.set(this.rows - 1 - row, column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    public DoubleMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int i, int j) {
                return this.content.getQuick(rix[i], cix[j]);
            }

            public synchronized void setQuick(int i, int j, double value) {
                this.content.setQuick(rix[i], cix[j], value);
            }

            public synchronized double get(int i, int j) {
                return this.content.get(rix[i], cix[j]);
            }

            public synchronized void set(int i, int j, double value) {
                this.content.set(rix[i], cix[j], value);
            }
        };
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        view.isNoView = false;
        return view;
    }

    public DoubleMatrix2D viewStrides(final int _rowStride, final int _columnStride) {
        if (_rowStride <= 0 || _columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int row, int column) {
                return this.content.getQuick(_rowStride * row, _columnStride * column);
            }

            public synchronized void setQuick(int row, int column, double value) {
                this.content.setQuick(_rowStride * row, _columnStride * column, value);
            }

            public synchronized double get(int row, int column) {
                return this.content.get(_rowStride * row, _columnStride * column);
            }

            public synchronized void set(int row, int column, double value) {
                this.content.set(_rowStride * row, _columnStride * column, value);
            }
        };
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / _rowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / _columnStride + 1;
        }
        view.isNoView = false;
        return view;
    }

    protected DoubleMatrix2D getContent() {
        return this.content;
    }

    protected DoubleMatrix1D like1D(int size, int offset, int stride) {
        throw new InternalError();
    }

    protected DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }
}

