/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.PersistentObject;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DComplexFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DComplexFactory1D dense = new DComplexFactory1D();
    public static final DComplexFactory1D sparse = new DComplexFactory1D();

    protected DComplexFactory1D() {
    }

    public DComplexMatrix1D append(DComplexMatrix1D A, DComplexMatrix1D B) {
        DComplexMatrix1D matrix = this.make((int)(A.size() + B.size()));
        matrix.viewPart(0, (int)A.size()).assign(A);
        matrix.viewPart((int)A.size(), (int)B.size()).assign(B);
        return matrix;
    }

    public DComplexMatrix1D make(double[] values) {
        if (this == sparse) {
            return new SparseDComplexMatrix1D(values);
        }
        return new DenseDComplexMatrix1D(values);
    }

    public DComplexMatrix1D make(DComplexMatrix1D[] parts) {
        if (parts.length == 0) {
            return this.make(0);
        }
        int size = 0;
        for (int i = 0; i < parts.length; ++i) {
            size = (int)((long)size + parts[i].size());
        }
        DComplexMatrix1D vector = this.make(size);
        size = 0;
        for (int i = 0; i < parts.length; ++i) {
            vector.viewPart(size, (int)parts[i].size()).assign(parts[i]);
            size = (int)((long)size + parts[i].size());
        }
        return vector;
    }

    public DComplexMatrix1D make(int size) {
        if (this == sparse) {
            return new SparseDComplexMatrix1D(size);
        }
        return new DenseDComplexMatrix1D(size);
    }

    public DComplexMatrix1D make(int size, double[] initialValue) {
        return this.make(size).assign(initialValue[0], initialValue[1]);
    }

    public DComplexMatrix1D make(ArrayList<double[]> values) {
        int size = values.size();
        DComplexMatrix1D vector = this.make(size);
        for (int i = 0; i < size; ++i) {
            vector.setQuick(i, values.get(i));
        }
        return vector;
    }

    public DComplexMatrix1D random(int size) {
        return this.make(size).assign(DComplexFunctions.random());
    }

    public DComplexMatrix1D repeat(DComplexMatrix1D A, int repeat) {
        int size = (int)A.size();
        DComplexMatrix1D matrix = this.make(repeat * size);
        for (int i = 0; i < repeat; ++i) {
            matrix.viewPart(size * i, size).assign(A);
        }
        return matrix;
    }

    public DComplexMatrix1D sample(int size, double[] value, double nonZeroFraction) {
        double epsilon = 1.0E-9;
        if (nonZeroFraction < 0.0 - epsilon || nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0) {
            nonZeroFraction = 0.0;
        }
        if (nonZeroFraction > 1.0) {
            nonZeroFraction = 1.0;
        }
        DComplexMatrix1D matrix = this.make(size);
        int n = (int)Math.round((double)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        DoubleRandomSamplingAssistant sampler = new DoubleRandomSamplingAssistant(n, size, new DoubleMersenneTwister());
        for (int i = 0; i < size; ++i) {
            if (!sampler.sampleNextElement()) continue;
            matrix.setQuick(i, value);
        }
        return matrix;
    }

    public ArrayList<double[]> toList(DComplexMatrix1D values) {
        int size = (int)values.size();
        ArrayList<double[]> list = new ArrayList<double[]>(size);
        for (int i = 0; i < size; ++i) {
            list.set(i, values.getQuick(i));
        }
        return list;
    }
}

