/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tdouble;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntDoubleProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntDoubleMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractIntDoubleMap() {
    }

    public void assign(final DoubleFunction function) {
        this.copy().forEachPair(new IntDoubleProcedure(){

            public boolean apply(int key, double value) {
                AbstractIntDoubleMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractIntDoubleMap other) {
        this.clear();
        other.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int key, double value) {
                AbstractIntDoubleMap.this.put(key, value);
                return true;
            }
        });
    }

    public boolean containsKey(final int key) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final double value) {
        return !this.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int iterKey, double iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractIntDoubleMap copy() {
        return (AbstractIntDoubleMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntDoubleMap)) {
            return false;
        }
        final AbstractIntDoubleMap other = (AbstractIntDoubleMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int key, double value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int key, double value) {
                return AbstractIntDoubleMap.this.containsKey(key) && AbstractIntDoubleMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntDoubleProcedure procedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                return procedure.apply(key, AbstractIntDoubleMap.this.get(key));
            }
        });
    }

    public abstract double get(int var1);

    public int keyOf(final double value) {
        final int[] foundKey = new int[1];
        boolean notFound = this.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int iterKey, double iterValue) {
                boolean found;
                boolean bl = found = value == iterValue;
                if (found) {
                    foundKey[0] = iterKey;
                }
                return !found;
            }
        });
        if (notFound) {
            return Integer.MIN_VALUE;
        }
        return foundKey[0];
    }

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList keyList) {
        this.pairsSortedByValue(keyList, new DoubleArrayList(this.size()));
    }

    public void pairsMatching(final IntDoubleProcedure condition, final IntArrayList keyList, final DoubleArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int key, double value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(IntArrayList keyList, DoubleArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final int[] k = keyList.elements();
        final double[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                double t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                int t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(int var1, double var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        String tmp = theKeys.toString() + "\n";
        theKeys.sort();
        StringBuffer buf = new StringBuffer(tmp);
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toStringByValue() {
        IntArrayList theKeys = new IntArrayList();
        this.keysSortedByValue(theKeys);
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public DoubleArrayList values() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                list.add(AbstractIntDoubleMap.this.get(key));
                return true;
            }
        });
    }
}

