/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.tdouble.Dklu_internal;
import edu.ufl.cise.klu.tdouble.Dklu_memory;

public class Dklu_kernel
extends Dklu_internal {
    public static int dfs(int j, int k, int[] Pinv, int[] Llen, int Llen_offset, int[] Lip, int Lip_offset, int[] Stack, int[] Flag, int[] Lpend, int top, double[] LU, double[] Lik, int Lik_offset, int[] plength, int[] Ap_pos) {
        int l_length = plength[0];
        int head = 0;
        Stack[0] = j;
        Dklu_kernel.ASSERT(Flag[j] != k);
        while (head >= 0) {
            int pos;
            j = Stack[head];
            int jnew = Pinv[j];
            Dklu_kernel.ASSERT(jnew >= 0 && jnew < k);
            if (Flag[j] != k) {
                Flag[j] = k;
                Dklu_kernel.PRINTF("[ start dfs at %d : new %d\n", j, jnew);
                Ap_pos[head] = Lpend[jnew] == -1 ? Llen[Llen_offset + jnew] : Lpend[jnew];
            }
            double[] Li = LU;
            int Li_offset = Lip[Lip_offset + jnew];
            int n = head;
            Ap_pos[n] = Ap_pos[n] - 1;
            for (pos = v6009; pos >= 0; --pos) {
                int i = (int)Li[Li_offset + pos];
                if (Flag[i] == k) continue;
                if (Pinv[i] >= 0) {
                    Ap_pos[head] = pos;
                    Stack[++head] = i;
                    break;
                }
                Flag[i] = k;
                Lik[Lik_offset + l_length] = i;
                ++l_length;
            }
            if (pos != -1) continue;
            Stack[--top] = j;
            Dklu_kernel.PRINTF("  end   dfs at %d ] head : %d\n", j, --head);
        }
        plength[0] = l_length;
        return top;
    }

    public static int lsolve_symbolic(int n, int k, int[] Ap, int[] Ai, int[] Q, int[] Pinv, int[] Stack, int[] Flag, int[] Lpend, int[] Ap_pos, double[] LU, int lup, int[] Llen, int Llen_offset, int[] Lip, int Lip_offset, int k1, int[] PSinv) {
        int top = n;
        int[] l_length = new int[]{0};
        double[] Lik = LU;
        int Lik_offset = lup;
        int kglobal = k + k1;
        int oldcol = Q[kglobal];
        int pend = Ap[oldcol + 1];
        for (int p = Ap[oldcol]; p < pend; ++p) {
            int i = PSinv[Ai[p]] - k1;
            if (i < 0) continue;
            Dklu_kernel.PRINTF("\n ===== DFS at node %d in b, inew: %d\n", i, Pinv[i]);
            if (Flag[i] == k) continue;
            if (Pinv[i] >= 0) {
                top = Dklu_kernel.dfs(i, k, Pinv, Llen, Llen_offset, Lip, Lip_offset, Stack, Flag, Lpend, top, LU, Lik, Lik_offset, l_length, Ap_pos);
                continue;
            }
            Flag[i] = k;
            Lik[Lik_offset + l_length[0]] = i;
            l_length[0] = l_length[0] + 1;
        }
        Llen[Llen_offset + k] = l_length[0];
        return top;
    }

    public static void construct_column(int k, int[] Ap, int[] Ai, double[] Ax, int[] Q, double[] X, int k1, int[] PSinv, double[] Rs, int scale, int[] Offp, int[] Offi, double[] Offx) {
        int kglobal = k + k1;
        int poff = Offp[kglobal];
        int oldcol = Q[kglobal];
        int pend = Ap[oldcol + 1];
        if (scale <= 0) {
            for (int p = Ap[oldcol]; p < pend; ++p) {
                int oldrow = Ai[p];
                int i = PSinv[oldrow] - k1;
                double aik = Ax[p];
                if (i < 0) {
                    Offi[poff] = oldrow;
                    Offx[poff] = aik;
                    ++poff;
                    continue;
                }
                X[i] = aik;
            }
        } else {
            for (int p = Ap[oldcol]; p < pend; ++p) {
                int oldrow = Ai[p];
                int i = PSinv[oldrow] - k1;
                double aik = Ax[p];
                aik = Dklu_kernel.SCALE_DIV(aik, Rs[oldrow]);
                if (i < 0) {
                    Offi[poff] = oldrow;
                    Offx[poff] = aik;
                    ++poff;
                    continue;
                }
                X[i] = aik;
            }
        }
        Offp[kglobal + 1] = poff;
    }

    public static void lsolve_numeric(int[] Pinv, double[] LU, int[] Stack, int[] Lip, int Lip_offset, int top, int n, int[] Llen, int Llen_offset, double[] X) {
        int[] len = new int[1];
        int[] Li_offset = new int[1];
        int[] Lx_offset = new int[1];
        for (int s = top; s < n; ++s) {
            double[] Lx;
            int j = Stack[s];
            int jnew = Pinv[j];
            Dklu_kernel.ASSERT(jnew >= 0);
            double xj = X[j];
            double[] Li = Lx = Dklu_kernel.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, jnew, len);
            Dklu_kernel.ASSERT(Lip[Lip_offset + jnew] <= Lip[Lip_offset + jnew + 1]);
            for (int p = 0; p < len[0]; ++p) {
                int n2 = (int)Li[Li_offset[0] + p];
                X[n2] = X[n2] - Lx[Lx_offset[0] + p] * xj;
            }
        }
    }

    public static int lpivot(int diagrow, int[] p_pivrow, double[] p_pivot, double[] p_abs_pivot, double tol, double[] X, double[] LU, int[] Lip, int Lip_offset, int[] Llen, int Llen_offset, int k, int n, int[] Pinv, int[] p_firstrow, KLU_common Common) {
        double pivot;
        double xabs;
        int p;
        double[] Lx;
        int[] len = new int[1];
        int[] Li_offset = new int[1];
        int[] Lx_offset = new int[1];
        int pivrow = -1;
        if (Llen[Llen_offset + k] == 0) {
            int firstrow;
            if (Common.halt_if_singular != 0) {
                return 0;
            }
            for (firstrow = p_firstrow[0]; firstrow < n; ++firstrow) {
                Dklu_kernel.PRINTF("check %d\n", firstrow);
                if (Pinv[firstrow] >= 0) continue;
                pivrow = firstrow;
                Dklu_kernel.PRINTF("Got pivotal row: %d\n", pivrow);
                break;
            }
            Dklu_kernel.ASSERT(pivrow >= 0 && pivrow < n);
            double pivot2 = 0.0;
            p_pivrow[0] = pivrow;
            p_pivot[0] = pivot2;
            p_abs_pivot[0] = 0.0;
            p_firstrow[0] = firstrow;
            return 0;
        }
        int pdiag = -1;
        int ppivrow = -1;
        double abs_pivot = -1.0;
        int i = Llen[Llen_offset + k] - 1;
        double[] Li = Lx = Dklu_kernel.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
        int last_row_index = (int)Li[Li_offset[0] + i];
        Llen[Llen_offset + k] = i;
        Li = Lx = Dklu_kernel.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
        for (p = 0; p < len[0]; ++p) {
            i = (int)Li[Li_offset[0] + p];
            double x = X[i];
            Dklu_kernel.CLEAR(X, i);
            Lx[Lx_offset[0] + p] = x;
            xabs = Dklu_kernel.ABS(x);
            if (i == diagrow) {
                pdiag = p;
            }
            if (!(xabs > abs_pivot)) continue;
            abs_pivot = xabs;
            ppivrow = p;
        }
        xabs = Dklu_kernel.ABS(X[last_row_index]);
        if (xabs > abs_pivot) {
            abs_pivot = xabs;
            ppivrow = -1;
        }
        if (last_row_index == diagrow) {
            if (xabs >= tol * abs_pivot) {
                abs_pivot = xabs;
                ppivrow = -1;
            }
        } else if (pdiag != -1 && (xabs = Dklu_kernel.ABS(Lx[Lx_offset[0] + pdiag])) >= tol * abs_pivot) {
            abs_pivot = xabs;
            ppivrow = pdiag;
        }
        if (ppivrow != -1) {
            pivrow = (int)Li[Li_offset[0] + ppivrow];
            pivot = Lx[Lx_offset[0] + ppivrow];
            Li[Li_offset[0] + ppivrow] = last_row_index;
            Lx[Lx_offset[0] + ppivrow] = X[last_row_index];
        } else {
            pivrow = last_row_index;
            pivot = X[last_row_index];
        }
        Dklu_kernel.CLEAR(X, last_row_index);
        p_pivrow[0] = pivrow;
        p_pivot[0] = pivot;
        p_abs_pivot[0] = abs_pivot;
        Dklu_kernel.ASSERT(pivrow >= 0 && pivrow < n);
        if (Dklu_kernel.IS_ZERO(pivot) && Common.halt_if_singular != 0) {
            return 0;
        }
        for (p = 0; p < Llen[Llen_offset + k]; ++p) {
            int n2 = Lx_offset[0] + p;
            Lx[n2] = Lx[n2] / pivot;
        }
        return 1;
    }

    public static void prune(int[] Lpend, int[] Pinv, int k, int pivrow, double[] LU, int[] Uip, int Uip_offset, int[] Lip, int Lip_offset, int[] Ulen, int Ulen_offset, int[] Llen, int Llen_offset) {
        int[] llen = new int[1];
        int[] ulen = new int[1];
        int[] Li_offset = new int[1];
        int[] Lx_offset = new int[1];
        int[] Ui_offset = new int[1];
        int[] Ux_offset = new int[1];
        double[] Ui = Dklu_kernel.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, ulen);
        block0: for (int p = 0; p < ulen[0]; ++p) {
            double[] Lx;
            int j = (int)Ui[Ui_offset[0] + p];
            Dklu_kernel.ASSERT(j < k);
            Dklu_kernel.PRINTF("%d is pruned: %d. Lpend[j] %d Lip[j+1] %d\n", j, Lpend[j] != -1 ? 1 : 0, Lpend[j], Lip[Lip_offset + j + 1]);
            if (Lpend[j] != -1) continue;
            double[] Li = Lx = Dklu_kernel.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, j, llen);
            for (int p2 = 0; p2 < llen[0]; ++p2) {
                int p3;
                if ((double)pivrow != Li[Li_offset[0] + p2]) continue;
                if (!NDEBUG) {
                    Dklu_kernel.PRINTF("==== PRUNE: col j %d of L\n", j);
                    for (p3 = 0; p3 < Llen[Llen_offset + j]; ++p3) {
                        Dklu_kernel.PRINTF("before: %d  pivotal: %d\n", (int)Li[Li_offset[0] + p3], Pinv[(int)Li[Li_offset[0] + p3]] >= 0 ? 1 : 0);
                    }
                }
                int phead = 0;
                int ptail = Llen[Llen_offset + j];
                while (phead < ptail) {
                    int i = (int)Li[Li_offset[0] + phead];
                    if (Pinv[i] >= 0) {
                        ++phead;
                        continue;
                    }
                    Li[Li_offset[0] + phead] = Li[Li_offset[0] + --ptail];
                    Li[Li_offset[0] + ptail] = i;
                    double x = Lx[Lx_offset[0] + phead];
                    Lx[Lx_offset[0] + phead] = Lx[Lx_offset[0] + ptail];
                    Lx[Lx_offset[0] + ptail] = x;
                }
                Lpend[j] = ptail;
                if (NDEBUG) continue block0;
                for (p3 = 0; p3 < Llen[Llen_offset + j]; ++p3) {
                    if (p3 == Lpend[j]) {
                        Dklu_kernel.PRINTF("----\n", new Object[0]);
                    }
                    Dklu_kernel.PRINTF("after: %d  pivotal: %d\n", (int)Li[Li_offset[0] + p3], Pinv[(int)Li[Li_offset[0] + p3]] >= 0 ? 1 : 0);
                }
                continue block0;
            }
        }
    }

    public static int klu_kernel(int n, int[] Ap, int[] Ai, double[] Ax, int[] Q, int lusize, int[] Pinv, int[] P, double[][] p_LU, double[] Udiag, int Udiag_offset, int[] Llen, int Llen_offset, int[] Ulen, int Ulen_offset, int[] Lip, int Lip_offset, int[] Uip, int Uip_offset, int[] lnz, int[] unz, double[] X, int[] Stack, int[] Flag, int[] Ap_pos, int[] Lpend, int k1, int[] PSinv, double[] Rs, int[] Offp, int[] Offi, double[] Offx, KLU_common Common) {
        double[] Li;
        int p;
        int i;
        int newlusize;
        int k;
        double[] pivot = new double[1];
        double[] abs_pivot = new double[1];
        int[] len = new int[1];
        int[] firstrow = new int[1];
        int[] pivrow = new int[]{0};
        int[] Ui_offset = new int[1];
        int[] Ux_offset = new int[1];
        int[] Li_offset = new int[1];
        int[] Lx_offset = new int[1];
        Dklu_kernel.ASSERT(Common != null);
        int scale = Common.scale;
        double tol = Common.tol;
        double memgrow = Common.memgrow;
        lnz[0] = 0;
        unz[0] = 0;
        pivot[0] = 0.0;
        Dklu_kernel.PRINTF("input: lusize %d \n", lusize);
        Dklu_kernel.ASSERT(lusize > 0);
        double[] LU = p_LU[0];
        firstrow[0] = 0;
        int lup = 0;
        for (k = 0; k < n; ++k) {
            Dklu_kernel.CLEAR(X, k);
            Flag[k] = -1;
            Lpend[k] = -1;
        }
        for (k = 0; k < n; ++k) {
            P[k] = k;
            Pinv[k] = Dklu_kernel.FLIP(k);
        }
        Offp[0] = 0;
        if (!NDEBUG) {
            for (k = 0; k < n; ++k) {
                Dklu_kernel.PRINTF("Initial P [%d] = %d\n", k, P[k]);
            }
        }
        for (k = 0; k < n; ++k) {
            double[] Ux;
            Dklu_kernel.PRINTF("\n\n==================================== k: %d\n", k);
            double nunits = n - k + k + (n - k) + k;
            Dklu_kernel.PRINTF("lup %d lusize %g lup+nunits: %g\n", lup, lusize, (double)lup + nunits);
            double xsize = (double)lup + nunits;
            if (xsize > (double)lusize) {
                xsize = memgrow * (double)lusize + (double)(4 * n) + 1.0;
                if (Dklu_kernel.INT_OVERFLOW(xsize)) {
                    Dklu_kernel.PRINTF("Matrix is too large (int overflow)\n", new Object[0]);
                    Common.status = -4;
                    return lusize;
                }
                newlusize = (int)(memgrow * (double)lusize + (double)(2 * n) + 1.0);
                LU = Dklu_memory.klu_realloc_dbl(newlusize, lusize, LU, Common);
                ++Common.nrealloc;
                p_LU[0] = LU;
                if (Common.status == -2) {
                    Dklu_kernel.PRINTF("Matrix is too large (LU)\n", new Object[0]);
                    return lusize;
                }
                lusize = newlusize;
                Dklu_kernel.PRINTF("inc LU to %d done\n", lusize);
            }
            Lip[Lip_offset + k] = lup;
            if (!NDEBUG) {
                for (i = 0; i < n; ++i) {
                    Dklu_kernel.ASSERT(Flag[i] < k);
                    Dklu_kernel.ASSERT(Dklu_kernel.IS_ZERO(X[i]));
                }
            }
            int top = Dklu_kernel.lsolve_symbolic(n, k, Ap, Ai, Q, Pinv, Stack, Flag, Lpend, Ap_pos, LU, lup, Llen, Llen_offset, Lip, Lip_offset, k1, PSinv);
            if (!NDEBUG) {
                Dklu_kernel.PRINTF("--- in U:\n", new Object[0]);
                for (p = top; p < n; ++p) {
                    Dklu_kernel.PRINTF("pattern of X for U: %d : %d pivot row: %d\n", p, Stack[p], Pinv[Stack[p]]);
                    Dklu_kernel.ASSERT(Flag[Stack[p]] == k);
                }
                Dklu_kernel.PRINTF("--- in L:\n", new Object[0]);
                Li = LU;
                Li_offset[0] = Lip[Lip_offset + k];
                for (p = 0; p < Llen[Llen_offset + k]; ++p) {
                    Dklu_kernel.PRINTF("pattern of X in L: %d : %d pivot row: %d\n", p, (int)Li[Li_offset[0] + p], Pinv[(int)Li[Li_offset[0] + p]]);
                    Dklu_kernel.ASSERT(Flag[(int)Li[Li_offset[0] + p]] == k);
                }
                p = 0;
                for (i = 0; i < n; ++i) {
                    Dklu_kernel.ASSERT(Flag[i] <= k);
                    if (Flag[i] != k) continue;
                    ++p;
                }
            }
            Dklu_kernel.construct_column(k, Ap, Ai, Ax, Q, X, k1, PSinv, Rs, scale, Offp, Offi, Offx);
            Dklu_kernel.lsolve_numeric(Pinv, LU, Stack, Lip, Lip_offset, top, n, Llen, Llen_offset, X);
            if (!NDEBUG) {
                for (p = top; p < n; ++p) {
                    Dklu_kernel.PRINTF("X for U %d : ", Stack[p]);
                    Dklu_kernel.PRINT_ENTRY(X[Stack[p]]);
                }
                Li = LU;
                Li_offset[0] = Lip[Lip_offset + k];
                for (p = 0; p < Llen[Llen_offset + k]; ++p) {
                    Dklu_kernel.PRINTF("X for L %d : ", (int)Li[Li_offset[0] + p]);
                    Dklu_kernel.PRINT_ENTRY(X[(int)Li[Li_offset[0] + p]]);
                }
            }
            int diagrow = P[k];
            Dklu_kernel.PRINTF("k %d, diagrow = %d, UNFLIP (diagrow) = %d\n", k, diagrow, Dklu_kernel.UNFLIP(diagrow));
            if (Dklu_kernel.lpivot(diagrow, pivrow, pivot, abs_pivot, tol, X, LU, Lip, Lip_offset, Llen, Llen_offset, k, n, Pinv, firstrow, Common) == 0) {
                Common.status = 1;
                if (Common.numerical_rank == -1) {
                    Common.numerical_rank = k + k1;
                    Common.singular_col = Q[k + k1];
                }
                if (Common.halt_if_singular != 0) {
                    return lusize;
                }
            }
            Dklu_kernel.PRINTF("\nk %d : Pivot row %d : ", k, pivrow[0]);
            Dklu_kernel.PRINT_ENTRY(pivot[0]);
            Dklu_kernel.ASSERT(pivrow[0] >= 0 && pivrow[0] < n);
            Dklu_kernel.ASSERT(Pinv[pivrow[0]] < 0);
            Uip[Uip_offset + k] = Lip[Lip_offset + k] + Llen[Llen_offset + k] + Llen[Llen_offset + k];
            lup += Llen[Llen_offset + k] + Llen[Llen_offset + k];
            Ulen[Ulen_offset + k] = n - top;
            double[] Ui = Ux = Dklu_kernel.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
            p = top;
            i = 0;
            while (p < n) {
                int j = Stack[p];
                Ui[Ui_offset[0] + i] = Pinv[j];
                Ux[Ux_offset[0] + i] = X[j];
                X[j] = 0.0;
                ++p;
                ++i;
            }
            lup += Ulen[Ulen_offset + k] + Ulen[Ulen_offset + k];
            Udiag[Udiag_offset + k] = pivot[0];
            Dklu_kernel.ASSERT(Dklu_kernel.UNFLIP(Pinv[diagrow]) < n);
            Dklu_kernel.ASSERT(P[Dklu_kernel.UNFLIP(Pinv[diagrow])] == diagrow);
            if (pivrow[0] != diagrow) {
                ++Common.noffdiag;
                Dklu_kernel.PRINTF(">>>>>>>>>>>>>>>>> pivrow %d k %d off-diagonal\n", pivrow[0], k);
                if (Pinv[diagrow] < 0) {
                    int kbar = Dklu_kernel.FLIP(Pinv[pivrow[0]]);
                    P[kbar] = diagrow;
                    Pinv[diagrow] = Dklu_kernel.FLIP(kbar);
                }
            }
            P[k] = pivrow[0];
            Pinv[pivrow[0]] = k;
            if (!NDEBUG) {
                for (i = 0; i < n; ++i) {
                    Dklu_kernel.ASSERT(Dklu_kernel.IS_ZERO(X[i]));
                }
                Ui = Ux = Dklu_kernel.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                for (p = 0; p < len[0]; ++p) {
                    Dklu_kernel.PRINTF("Column %d of U: %d : ", k, (int)Ui[Ui_offset[0] + p]);
                    Dklu_kernel.PRINT_ENTRY(Ux[Ux_offset[0] + p]);
                }
                double[] Lx = Dklu_kernel.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                Li = Lx;
                for (p = 0; p < len[0]; ++p) {
                    Dklu_kernel.PRINTF("Column %d of L: %d : ", k, (int)Li[Li_offset[0] + p]);
                    Dklu_kernel.PRINT_ENTRY(Lx[Lx_offset[0] + p]);
                }
            }
            Dklu_kernel.prune(Lpend, Pinv, k, pivrow[0], LU, Uip, Uip_offset, Lip, Lip_offset, Ulen, Ulen_offset, Llen, Llen_offset);
            lnz[0] = lnz[0] + (Llen[Llen_offset + k] + 1);
            unz[0] = unz[0] + (Ulen[Ulen_offset + k] + 1);
        }
        for (p = 0; p < n; ++p) {
            Li = LU;
            Li_offset[0] = Lip[Lip_offset + p];
            for (i = 0; i < Llen[Llen_offset + p]; ++i) {
                Li[Li_offset[0] + i] = Pinv[(int)Li[Li_offset[0] + i]];
            }
        }
        if (!NDEBUG) {
            for (i = 0; i < n; ++i) {
                Dklu_kernel.PRINTF("P [%d] = %d   Pinv [%d] = %d\n", i, P[i], i, Pinv[i]);
            }
            for (i = 0; i < n; ++i) {
                Dklu_kernel.ASSERT(Pinv[i] >= 0 && Pinv[i] < n);
                Dklu_kernel.ASSERT(P[i] >= 0 && P[i] < n);
                Dklu_kernel.ASSERT(P[Pinv[i]] == i);
                Dklu_kernel.ASSERT(Dklu_kernel.IS_ZERO(X[i]));
            }
        }
        Dklu_kernel.ASSERT((newlusize = lup) <= lusize);
        LU = Dklu_memory.klu_realloc_dbl(newlusize, lusize, LU, Common);
        p_LU[0] = LU;
        return newlusize;
    }
}

