/*
 * Decompiled with CFR 0.152.
 */
package nl.systemsgenetics.simplegeneticriskscorecalculator;

class RiskEntry
implements Comparable<RiskEntry> {
    private final String rsName;
    private final double or;
    private final int pos;
    private final String chr;
    private final String allele;
    private final double pValue;

    RiskEntry(String rsName, String chr, int pos, String allele, String or, double pValue) {
        this.rsName = rsName;
        this.chr = chr;
        this.pos = pos;
        this.allele = allele;
        this.pValue = pValue;
        this.or = Double.parseDouble(or);
    }

    public String getRsName() {
        return this.rsName;
    }

    public double getOr() {
        return this.or;
    }

    public int getPos() {
        return this.pos;
    }

    public String getChr() {
        return this.chr;
    }

    public String getAllele() {
        return this.allele;
    }

    public double getpValue() {
        return this.pValue;
    }

    @Override
    public int compareTo(RiskEntry o) {
        if (this.pValue < o.getpValue()) {
            return -1;
        }
        if (this.pValue == o.getpValue()) {
            if (Math.abs(this.or) > Math.abs(o.getOr())) {
                return -1;
            }
            if (Math.abs(this.or) == Math.abs(o.getOr())) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    String InfoToString() {
        StringBuilder s = new StringBuilder();
        s.append(this.rsName).append("\t");
        s.append(this.chr).append("\t");
        s.append(this.pos).append("\t");
        s.append(this.allele).append("\t");
        s.append(this.or).append("\t");
        s.append(this.pValue);
        return s.toString();
    }
}

