/*
 * Decompiled with CFR 0.152.
 */
package nl.systemsgenetics.simplegeneticriskscorecalculator;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nl.systemsgenetics.simplegeneticriskscorecalculator.CalculateSimpleGeneticRiskScore;
import nl.systemsgenetics.simplegeneticriskscorecalculator.RiskEntry;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;
import org.molgenis.genotype.variant.GeneticVariant;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.ConvertDoubleMatrixDataToTriTyper;
import umcg.genetica.io.trityper.WGAFileMatrixGenotype;
import umcg.genetica.io.trityper.WGAFileMatrixImputedDosage;
import umcg.genetica.math.matrix2.DoubleMatrixDataset;

public class Main {
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        Options options = new Options();
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Location (folder) for the output.");
        OptionBuilder.withLongOpt("OutputFolder");
        Option FileOut = OptionBuilder.create("o");
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Type of refference data.");
        OptionBuilder.withLongOpt("GenotypeType");
        Option GenotypeTypeIn = OptionBuilder.create("gt");
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Location for the reference data");
        OptionBuilder.withLongOpt("GenotypeLocation");
        Option GenotypeIn = OptionBuilder.create("gi");
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Location of the folder with genetic risk score information");
        OptionBuilder.withLongOpt("input");
        Option InFolder = OptionBuilder.create("i");
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("R2 for pruning");
        OptionBuilder.withLongOpt("rSquared");
        Option rSquared = OptionBuilder.create("r");
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("P-value thresholds for genetic risk score inclussion, colon separated should be ordered from most stringent to least stringent.");
        OptionBuilder.withLongOpt("pValue");
        Option pValueThreshold = OptionBuilder.create("p");
        OptionBuilder.withArgName("double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Window size for pruning, optional give two window-sizes (colon separated), will do a two step window approach.");
        OptionBuilder.withLongOpt("wSize");
        Option WindowSize = OptionBuilder.create("w");
        OptionBuilder.withArgName("boolean");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Switch on debugging.");
        OptionBuilder.withLongOpt("debug");
        Option debug = OptionBuilder.create("d");
        options.addOption(FileOut).addOption(GenotypeTypeIn).addOption(GenotypeIn).addOption(InFolder).addOption(rSquared).addOption(pValueThreshold).addOption(WindowSize).addOption(debug);
        String genotypePath = null;
        String genotypeType = null;
        String riskFolder = null;
        File outputFolder = null;
        double rSquare = 1.0;
        double[] windowSize = null;
        double[] pValThres = null;
        boolean debugMode = false;
        try {
            int i;
            String[] tempThres;
            CommandLine cmd = parser.parse(options, args);
            HelpFormatter formatter = new HelpFormatter();
            if (cmd.hasOption("OutputFolder") || cmd.hasOption("o")) {
                outputFolder = new File(cmd.getOptionValue("OutputFolder"));
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("GenotypeLocation") || cmd.hasOption("gi")) {
                genotypePath = cmd.getOptionValue("GenotypeLocation");
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("GenotypeType") || cmd.hasOption("gt")) {
                genotypeType = cmd.getOptionValue("GenotypeType");
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("input") || cmd.hasOption("i")) {
                riskFolder = cmd.getOptionValue("input");
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("rSquared") || cmd.hasOption("r")) {
                rSquare = Double.parseDouble(cmd.getOptionValue("rSquared"));
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("wSize") || cmd.hasOption("w")) {
                tempThres = cmd.getOptionValue("wSize").split(":");
                windowSize = new double[tempThres.length];
                for (i = 0; i < tempThres.length; ++i) {
                    windowSize[i] = Double.parseDouble(tempThres[i]);
                }
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            if (cmd.hasOption("pValue") || cmd.hasOption("p")) {
                tempThres = cmd.getOptionValue("pValue").split(":");
                pValThres = new double[tempThres.length];
                for (i = 0; i < tempThres.length; ++i) {
                    pValThres[i] = Double.parseDouble(tempThres[i]);
                }
            } else {
                System.out.println("Missing necesarray information");
                formatter.printHelp("ant", options);
                System.exit(0);
            }
            debugMode = cmd.hasOption("d");
        }
        catch (ParseException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            if (!outputFolder.exists()) {
                Gpio.createDir(outputFolder.getAbsolutePath());
            }
            RandomAccessGenotypeData genotypeData = RandomAccessGenotypeDataReaderFormats.valueOf(genotypeType).createFilteredGenotypeData(genotypePath, 750000, null, null);
            HashMap<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> risks = Main.readRiskFiles(genotypeData, riskFolder, pValThres);
            if (windowSize.length == 1) {
                DoubleMatrixDataset<String, String> geneticRiskScoreMatrix = CalculateSimpleGeneticRiskScore.calculate(genotypeData, risks, outputFolder, rSquare, (double)windowSize[0], debugMode);
                Main.writeMatrixToFile(geneticRiskScoreMatrix, outputFolder);
            } else if (windowSize.length == 2) {
                DoubleMatrixDataset<String, String> geneticRiskScoreMatrix = CalculateSimpleGeneticRiskScore.calculateTwoStages(genotypeData, risks, outputFolder, rSquare, windowSize, debugMode);
                Main.writeMatrixToFile(geneticRiskScoreMatrix, outputFolder);
            } else {
                System.out.println("More than two window-sizes is not supported.");
                System.exit(0);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static HashMap<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> readRiskFiles(RandomAccessGenotypeData genotypeData, String riskFolder, double[] pValueThreshold) {
        File[] riskFiles;
        HashMap<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> risks = new HashMap<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>>();
        File riskFileFolder = new File(riskFolder);
        for (File f : riskFiles = riskFileFolder.listFiles()) {
            try {
                TextFile readFiles = new TextFile(f.getAbsolutePath(), false);
                System.out.println(f.getName());
                for (double p : pValueThreshold) {
                    String name = f.getName();
                    String name2 = "_P" + p;
                    if (!risks.containsKey(name)) {
                        risks.put(name, new LinkedHashMap());
                    }
                    if (risks.get(name).containsKey(name2)) continue;
                    risks.get(name).put(name2, new HashMap());
                }
                String s = readFiles.readLine();
                while ((s = readFiles.readLine()) != null) {
                    String[] parts = TAB_PATTERN.split(s);
                    if (!genotypeData.getVariantIdMap().containsKey(parts[0])) continue;
                    GeneticVariant snpObject = genotypeData.getVariantIdMap().get(parts[0]);
                    double currentP = Double.parseDouble(parts[3]);
                    for (double p : pValueThreshold) {
                        if (!(currentP < p)) continue;
                        String name = f.getName();
                        String name2 = "_P" + p;
                        if (!risks.get(name).get(name2).containsKey(snpObject.getSequenceName())) {
                            risks.get(name).get(name2).put(snpObject.getSequenceName(), new ArrayList());
                        }
                        risks.get(name).get(name2).get(snpObject.getSequenceName()).add(new RiskEntry(parts[0], snpObject.getSequenceName(), snpObject.getStartPos(), parts[1], parts[2], currentP));
                    }
                }
                readFiles.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (Map.Entry e : risks.entrySet()) {
            for (Map.Entry e2 : ((LinkedHashMap)e.getValue()).entrySet()) {
                int entries = 0;
                for (Map.Entry e3 : ((HashMap)e2.getValue()).entrySet()) {
                    Collections.sort((List)e3.getValue());
                    entries += ((ArrayList)e3.getValue()).size();
                }
            }
        }
        return risks;
    }

    private static void writeMatrixToFile(DoubleMatrixDataset<String, String> geneticRiskScoreMatrix, File outputFolder) throws IOException {
        String outputF = outputFolder + File.separator + "TT";
        if (!new File(outputF).exists()) {
            Gpio.createDir(outputF);
        } else if (!new File(outputF).isDirectory()) {
            System.out.println("Error file is already there but not a directory, writing to TT1");
            outputF = outputFolder + File.separator + "TT1";
            Gpio.createDir(outputF);
            System.exit(0);
        }
        geneticRiskScoreMatrix.save(outputF + File.separator + "rawScoreMatrix.txt");
        try {
            System.out.println("Writing SNPMappings.txt & SNPs.txt to file:");
            BufferedWriter outSNPMappings = new BufferedWriter(new FileWriter(new File(outputF + File.separator + "SNPMappings.txt")));
            BufferedWriter outSNPs = new BufferedWriter(new FileWriter(new File(outputF + File.separator + "SNPs.txt")));
            for (String var : geneticRiskScoreMatrix.getRowObjects()) {
                outSNPMappings.write("1\t1000000\t" + var + '\n');
                outSNPs.write(var + '\n');
            }
            outSNPMappings.close();
            outSNPs.close();
        }
        catch (Exception e) {
            System.out.println("Error:\t" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }
        geneticRiskScoreMatrix.setMatrix(ConvertDoubleMatrixDataToTriTyper.rankRows(geneticRiskScoreMatrix.getMatrix()));
        geneticRiskScoreMatrix.setMatrix(ConvertDoubleMatrixDataToTriTyper.rescaleValue(geneticRiskScoreMatrix.getMatrix(), 200.0));
        try {
            System.out.println("\nWriting Individuals.txt and Phenotype.txt to file:");
            BufferedWriter outIndNew = new BufferedWriter(new FileWriter(outputF + File.separator + "Individuals.txt"));
            BufferedWriter outPhenoNew = new BufferedWriter(new FileWriter(outputF + File.separator + "PhenotypeInformation.txt"));
            for (String ind : geneticRiskScoreMatrix.getColObjects()) {
                outIndNew.write(ind + '\n');
                outPhenoNew.write(ind + "\tcontrol\tinclude\tmale\n");
            }
            outIndNew.close();
            outPhenoNew.close();
        }
        catch (Exception e) {
            System.out.println("Error:\t" + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }
        int nrSNPs = geneticRiskScoreMatrix.rows();
        int nrSamples = geneticRiskScoreMatrix.columns();
        WGAFileMatrixGenotype fileMatrixGenotype = new WGAFileMatrixGenotype(nrSNPs, nrSamples, new File(outputF + File.separator + "GenotypeMatrix.dat"), false);
        WGAFileMatrixImputedDosage fileMatrixDosage = new WGAFileMatrixImputedDosage(nrSNPs, nrSamples, new File(outputF + File.separator + "ImputedDosageMatrix.dat"), false);
        byte[] alleles = new byte[]{84, 67};
        for (int snp = 0; snp < nrSNPs; ++snp) {
            DoubleMatrix1D snpRow = geneticRiskScoreMatrix.getMatrix().viewRow(snp);
            byte[] allele1 = new byte[nrSamples];
            byte[] allele2 = new byte[nrSamples];
            byte[] dosageValues = new byte[nrSamples];
            for (int ind = 0; ind < nrSamples; ++ind) {
                byte value;
                if (snpRow.get(ind) > 100.0) {
                    allele1[ind] = alleles[1];
                    allele2[ind] = alleles[1];
                } else {
                    allele1[ind] = alleles[0];
                    allele2[ind] = alleles[0];
                }
                int dosageInt = (int)Math.round(snpRow.get(ind));
                dosageValues[ind] = value = (byte)(-128 + dosageInt);
            }
            fileMatrixGenotype.setAllele1(snp, 0, allele1);
            fileMatrixGenotype.setAllele2(snp, 0, allele2);
            fileMatrixDosage.setDosage(snp, 0, dosageValues);
        }
        fileMatrixGenotype.close();
        fileMatrixDosage.close();
    }
}

