/*
 * Decompiled with CFR 0.152.
 */
package nl.systemsgenetics.simplegeneticriskscorecalculator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.systemsgenetics.simplegeneticriskscorecalculator.RiskEntry;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.util.Ld;
import org.molgenis.genotype.util.LdCalculatorException;
import org.molgenis.genotype.variant.GeneticVariant;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.math.matrix2.DoubleMatrixDataset;

class CalculateSimpleGeneticRiskScore {
    private static final String[] chrOrder = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"};

    CalculateSimpleGeneticRiskScore() {
    }

    static DoubleMatrixDataset<String, String> calculate(RandomAccessGenotypeData genotypeData, HashMap<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> risks, File outputFolder, double rSquare, double windowSize, boolean debugMode) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> riskScorePheno : risks.entrySet()) {
            for (Map.Entry<String, HashMap<String, ArrayList<RiskEntry>>> riskScorePheno2 : riskScorePheno.getValue().entrySet()) {
                keys.add(riskScorePheno.getKey() + riskScorePheno2.getKey());
            }
        }
        DoubleMatrixDataset<String, String> scores = new DoubleMatrixDataset<String, String>(keys, Arrays.asList(genotypeData.getSampleNames()));
        ProgressBar p = new ProgressBar(risks.size() * chrOrder.length);
        for (int counter = 0; counter < chrOrder.length; ++counter) {
            for (Map.Entry<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> riskScorePheno : risks.entrySet()) {
                HashSet<String> excludeList = new HashSet<String>();
                for (Map.Entry<String, HashMap<String, ArrayList<RiskEntry>>> riskScorePheno2 : riskScorePheno.getValue().entrySet()) {
                    String NameOfEntry = riskScorePheno.getKey() + riskScorePheno2.getKey();
                    int rowNr = scores.getHashRows().get(NameOfEntry);
                    try {
                        TextFile out = null;
                        if (debugMode) {
                            System.out.println(NameOfEntry);
                            out = new TextFile(outputFolder + File.separator + NameOfEntry + "Chr" + chrOrder[counter] + ".log", true);
                            out.write("SNPs used for GRS calculation:\n");
                        }
                        int nrSNPs = 0;
                        if (riskScorePheno2.getValue().containsKey(chrOrder[counter])) {
                            int snp;
                            ArrayList<RiskEntry> valueE2 = riskScorePheno2.getValue().get(chrOrder[counter]);
                            int nrSNPsThisChr = valueE2.size();
                            boolean[] excludeSNPs = new boolean[nrSNPsThisChr];
                            if (excludeList.size() > 0) {
                                for (snp = 0; snp < nrSNPsThisChr; ++snp) {
                                    if (!excludeList.contains(valueE2.get(snp).getRsName())) continue;
                                    excludeSNPs[snp] = true;
                                }
                            }
                            for (snp = 0; snp < nrSNPsThisChr; ++snp) {
                                if (excludeSNPs[snp]) continue;
                                RiskEntry riskE = valueE2.get(snp);
                                GeneticVariant var1 = genotypeData.getSnpVariantByPos(riskE.getChr(), riskE.getPos());
                                if (var1.getCallRate() < 0.75) {
                                    excludeSNPs[snp] = true;
                                    excludeList.add(riskE.getRsName());
                                    continue;
                                }
                                if (debugMode) {
                                    out.write(riskE.InfoToString() + "\n");
                                }
                                double or = riskE.getOr();
                                int direction = -1;
                                if (!riskE.getAllele().equals(var1.getRefAllele().toString()) && !riskE.getAllele().equals(var1.getRefAllele().getComplement().toString())) {
                                    direction = 1;
                                }
                                for (int sample = 0; sample < var1.getSampleCalledDosages().length; ++sample) {
                                    if (var1.getSampleCalledDosages()[sample] == -1) continue;
                                    scores.getMatrix().setQuick(rowNr, sample, scores.getMatrix().getQuick(rowNr, sample) + (double)direction * or * (double)Math.abs(var1.getSampleCalledDosages()[sample] - 2));
                                }
                                ++nrSNPs;
                                for (int t = snp + 1; t < nrSNPsThisChr; ++t) {
                                    RiskEntry riskE2;
                                    if (excludeSNPs[t] || !((double)Math.abs((riskE2 = valueE2.get(t)).getPos() - riskE.getPos()) <= windowSize)) continue;
                                    GeneticVariant var2 = genotypeData.getSnpVariantByPos(riskE2.getChr(), riskE2.getPos());
                                    if (var2.getCallRate() < 0.75) {
                                        excludeSNPs[t] = true;
                                        excludeList.add(riskE2.getRsName());
                                        continue;
                                    }
                                    try {
                                        Ld ld = var1.calculateLd(var2);
                                        if (!(ld.getR2() >= rSquare)) continue;
                                        excludeSNPs[t] = true;
                                        excludeList.add(riskE2.getRsName());
                                        continue;
                                    }
                                    catch (LdCalculatorException ex) {
                                        Logger.getLogger(CalculateSimpleGeneticRiskScore.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }
                        }
                        if (!debugMode) continue;
                        out.write("Total SNPs used: " + nrSNPs);
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(CalculateSimpleGeneticRiskScore.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                p.iterate();
            }
        }
        p.close();
        return scores;
    }

    static DoubleMatrixDataset<String, String> calculateTwoStages(RandomAccessGenotypeData genotypeData, HashMap<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> risks, File outputFolder, double rSquare, double[] windowSize, boolean debugMode) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> riskScorePheno : risks.entrySet()) {
            for (Map.Entry<String, HashMap<String, ArrayList<RiskEntry>>> riskScorePheno2 : riskScorePheno.getValue().entrySet()) {
                keys.add(riskScorePheno.getKey() + riskScorePheno2.getKey());
            }
        }
        DoubleMatrixDataset<String, String> scores = new DoubleMatrixDataset<String, String>(keys, Arrays.asList(genotypeData.getSampleNames()));
        ProgressBar p = new ProgressBar(risks.size() * chrOrder.length);
        for (int counter = 0; counter < chrOrder.length; ++counter) {
            for (Map.Entry<String, LinkedHashMap<String, HashMap<String, ArrayList<RiskEntry>>>> riskScorePheno : risks.entrySet()) {
                HashSet<String> excludeList = new HashSet<String>();
                for (Map.Entry<String, HashMap<String, ArrayList<RiskEntry>>> riskScorePheno2 : riskScorePheno.getValue().entrySet()) {
                    try {
                        String NameOfEntry = riskScorePheno.getKey() + riskScorePheno2.getKey();
                        int rowNr = scores.getHashRows().get(NameOfEntry);
                        TextFile out = null;
                        if (debugMode) {
                            System.out.println(NameOfEntry);
                            out = new TextFile(outputFolder + File.separator + NameOfEntry + "Chr" + chrOrder[counter] + ".log", true);
                            out.write("SNPs used for GRS calculation:\n");
                        }
                        int nrSNPs = 0;
                        if (riskScorePheno2.getValue().containsKey(chrOrder[counter])) {
                            GeneticVariant var1;
                            RiskEntry riskE;
                            int snp;
                            ArrayList<RiskEntry> valueE2 = riskScorePheno2.getValue().get(chrOrder[counter]);
                            int nrSNPsThisChr = valueE2.size();
                            boolean[] excludeSNPs = new boolean[nrSNPsThisChr];
                            if (excludeList.size() > 0) {
                                for (snp = 0; snp < nrSNPsThisChr; ++snp) {
                                    if (!excludeList.contains(valueE2.get(snp).getRsName())) continue;
                                    excludeSNPs[snp] = true;
                                }
                            }
                            for (snp = 0; snp < nrSNPsThisChr; ++snp) {
                                if (excludeSNPs[snp]) continue;
                                riskE = valueE2.get(snp);
                                var1 = genotypeData.getSnpVariantByPos(riskE.getChr(), riskE.getPos());
                                if (var1.getCallRate() < 0.75) {
                                    excludeSNPs[snp] = true;
                                    excludeList.add(riskE.getRsName());
                                    continue;
                                }
                                for (int t = snp + 1; t < nrSNPsThisChr; ++t) {
                                    RiskEntry riskE2;
                                    if (excludeSNPs[t] || !((double)Math.abs((riskE2 = valueE2.get(t)).getPos() - riskE.getPos()) <= windowSize[0])) continue;
                                    GeneticVariant var2 = genotypeData.getSnpVariantByPos(riskE2.getChr(), riskE2.getPos());
                                    if (var2.getCallRate() < 0.75) {
                                        excludeSNPs[t] = true;
                                        excludeList.add(riskE2.getRsName());
                                        continue;
                                    }
                                    try {
                                        Ld ld = var1.calculateLd(var2);
                                        if (!(ld.getR2() >= rSquare)) continue;
                                        excludeSNPs[t] = true;
                                        excludeList.add(riskE2.getRsName());
                                        continue;
                                    }
                                    catch (LdCalculatorException ex) {
                                        Logger.getLogger(CalculateSimpleGeneticRiskScore.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }
                            for (snp = 0; snp < nrSNPsThisChr; ++snp) {
                                if (excludeSNPs[snp]) continue;
                                riskE = valueE2.get(snp);
                                var1 = genotypeData.getSnpVariantByPos(riskE.getChr(), riskE.getPos());
                                if (debugMode) {
                                    out.write(riskE.InfoToString() + "\n");
                                }
                                double or = riskE.getOr();
                                int direction = -1;
                                if (!riskE.getAllele().equals(var1.getRefAllele().toString()) && !riskE.getAllele().equals(var1.getRefAllele().getComplement().toString())) {
                                    direction = 1;
                                }
                                for (int sample = 0; sample < var1.getSampleCalledDosages().length; ++sample) {
                                    if (var1.getSampleCalledDosages()[sample] == -1) continue;
                                    scores.getMatrix().setQuick(rowNr, sample, scores.getMatrix().getQuick(rowNr, sample) + (double)direction * or * (double)Math.abs(var1.getSampleCalledDosages()[sample] - 2));
                                }
                                ++nrSNPs;
                                for (int t = snp + 1; t < nrSNPsThisChr; ++t) {
                                    RiskEntry riskE2;
                                    if (excludeSNPs[t] || !((double)Math.abs((riskE2 = valueE2.get(t)).getPos() - riskE.getPos()) <= windowSize[1])) continue;
                                    GeneticVariant var2 = genotypeData.getSnpVariantByPos(riskE2.getChr(), riskE2.getPos());
                                    try {
                                        Ld ld = var1.calculateLd(var2);
                                        if (!(ld.getR2() >= rSquare)) continue;
                                        excludeSNPs[t] = true;
                                        continue;
                                    }
                                    catch (LdCalculatorException ex) {
                                        Logger.getLogger(CalculateSimpleGeneticRiskScore.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }
                        }
                        if (!debugMode) continue;
                        out.write("Total SNPs used: " + nrSNPs);
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(CalculateSimpleGeneticRiskScore.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                p.iterate();
            }
        }
        p.close();
        return scores;
    }
}

