/*
 * Decompiled with CFR 0.152.
 */
package nl.systemsgenetics.geneticriskscorecalculator;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.List;
import nl.systemsgenetics.geneticriskscorecalculator.GeneticRiskScoreCalculator;
import nl.systemsgenetics.geneticriskscorecalculator.PhenotypeData;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.variant.GeneticVariant;

public class SimpleGeneticRiskScoreCalculator
implements GeneticRiskScoreCalculator {
    private String phenotype;
    private List<Integer> chr = new ArrayList<Integer>();
    private List<Integer> pos = new ArrayList<Integer>();
    private List<String> rsid = new ArrayList<String>();
    private List<String> riskallele = new ArrayList<String>();
    private List<String> otherallele = new ArrayList<String>();
    private List<Double> pvalue = new ArrayList<Double>();
    private List<Double> ororbeta = new ArrayList<Double>();

    @Override
    public TObjectDoubleHashMap<String> calculateRiskScores(RandomAccessGenotypeData genotypeData, String onlyCount, String harmonizedData, double inclusionThreshold) {
        int index;
        boolean useDosages = true;
        TObjectDoubleHashMap<String> scores = new TObjectDoubleHashMap<String>(genotypeData.getSampleNames().length);
        ArrayList<Double> score = new ArrayList<Double>();
        for (index = 0; index < genotypeData.getSampleNames().length; ++index) {
            score.add(index, 0.0);
        }
        int nrGCAT = 0;
        int nrnonGCAT = 0;
        boolean intOnlyCount = false;
        if (onlyCount == null) {
            System.out.println("onlyCount is null: we add the betas ");
        } else {
            intOnlyCount = true;
            System.out.println("onlyCount is not null: we only count risk alleles ");
        }
        boolean intHarmonizedData = false;
        if (harmonizedData == null) {
            System.out.println("harmonizedData is null: we don't assume harmonized data");
        } else {
            intHarmonizedData = true;
            System.out.println("harmonizedData is not null: we assume harmonized data");
        }
        System.out.println("risk snp inclusion threshold is:  " + inclusionThreshold);
        String complementriskallele = "K";
        double maxRisk = 0.0;
        System.out.println("-----------------------------------------------");
        System.out.println("Processing: " + this.phenotype);
        System.out.println("-----------------------------------------------");
        System.out.println("Size of chr " + this.chr.size());
        System.out.println("Size of pos " + this.pos.size());
        System.out.println("Size of ororbeta " + this.ororbeta.size());
        for (index = 0; index < this.chr.size(); ++index) {
            block38: {
                Integer currentChr = this.chr.get(index);
                int currentPos = this.pos.get(index);
                double currentOrorbeta = this.ororbeta.get(index);
                System.out.print("SNP" + index + " " + this.rsid.get(index) + "  " + this.chr.get(index) + "  " + this.pos.get(index) + "  " + this.riskallele.get(index) + " " + this.otherallele.get(index) + " effectsize " + this.ororbeta.get(index) + " Pvalue " + this.pvalue.get(index) + "   ");
                if (this.pvalue.get(index) < inclusionThreshold) {
                    try {
                        GeneticVariant snpVariantByPos = genotypeData.getSnpVariantByPos(currentChr.toString(), currentPos);
                        System.out.print("         Chr: " + snpVariantByPos.getSequenceName() + " Pos " + snpVariantByPos.getStartPos() + " MINORALLELE  " + snpVariantByPos.getMinorAllele() + "  ALLALLELES  " + snpVariantByPos.getVariantAlleles() + "  FIRST: " + snpVariantByPos.getVariantAlleles().get(0) + "  SECOND: " + snpVariantByPos.getVariantAlleles().get(1) + "  Is GC AT snp: " + snpVariantByPos.getVariantAlleles().isAtOrGcSnp() + "  MAF  " + snpVariantByPos.getMinorAlleleFrequency() + " ");
                        if (snpVariantByPos.getVariantAlleles().isAtOrGcSnp()) {
                            ++nrGCAT;
                        } else {
                            ++nrnonGCAT;
                        }
                        List<Alleles> alleles = snpVariantByPos.getSampleVariants();
                        float[] dosages = snpVariantByPos.getSampleDosages();
                        List<String> myids = snpVariantByPos.getAllIds();
                        String originalriskallele = this.riskallele.get(index);
                        String usedriskallele = this.riskallele.get(index);
                        String secondallele = this.otherallele.get(index);
                        if (this.ororbeta.get(index) < 0.0) {
                            usedriskallele = this.otherallele.get(index);
                        }
                        System.out.print(myids.get(0) + " ORIGRISKALLELE " + originalriskallele + " ");
                        System.out.print(" USEDRISKALLELE " + usedriskallele + " ");
                        if (intHarmonizedData | !snpVariantByPos.getVariantAlleles().isAtOrGcSnp()) {
                            for (int index2 = 0; index2 < alleles.size(); ++index2) {
                                if (index2 < 20) {
                                    System.out.print(" -- allele " + alleles.get(index2).getAllelesAsString() + "__" + alleles.get(index2).getAllelesAsString().get(0) + "__" + alleles.get(index2).getAllelesAsString().get(1));
                                    System.out.print(" dosage: " + dosages[index2]);
                                }
                                if (!intOnlyCount) {
                                    if (usedriskallele.equals(snpVariantByPos.getVariantAlleles().get(0).toString())) {
                                        score.set(index2, (Double)score.get(index2) + (double)dosages[index2] * Math.abs(this.ororbeta.get(index)));
                                        if (index2 < 20) {
                                            System.out.print(" added (first allele, orig strand) " + (double)dosages[index2] * Math.abs(this.ororbeta.get(index)) + "**" + alleles.get(index2).getAllelesAsString().get(0) + "**");
                                        }
                                    }
                                    if (usedriskallele.equals(snpVariantByPos.getVariantAlleles().get(1).toString())) {
                                        score.set(index2, (Double)score.get(index2) + (double)(2.0f - dosages[index2]) * Math.abs(this.ororbeta.get(index)));
                                        if (index2 < 20) {
                                            System.out.print(" added (second allele, orig strand) " + (double)(2.0f - dosages[index2]) * Math.abs(this.ororbeta.get(index)) + "**" + alleles.get(index2).getAllelesAsString().get(0) + "**");
                                        }
                                    }
                                    if (intHarmonizedData) continue;
                                    if (usedriskallele.equals("C")) {
                                        complementriskallele = "G";
                                    }
                                    if (usedriskallele.equals("G")) {
                                        complementriskallele = "C";
                                    }
                                    if (usedriskallele.equals("A")) {
                                        complementriskallele = "T";
                                    }
                                    if (usedriskallele.equals("T")) {
                                        complementriskallele = "A";
                                    }
                                    if (complementriskallele.equals(snpVariantByPos.getVariantAlleles().get(0).toString())) {
                                        score.set(index2, (Double)score.get(index2) + (double)dosages[index2] * Math.abs(this.ororbeta.get(index)));
                                        if (index2 < 20) {
                                            System.out.print(" added (first allele, other strand) " + (double)dosages[index2] * Math.abs(this.ororbeta.get(index)) + "**" + alleles.get(index2).getAllelesAsString().get(0) + "**");
                                        }
                                    }
                                    if (!complementriskallele.equals(snpVariantByPos.getVariantAlleles().get(1).toString())) continue;
                                    score.set(index2, (Double)score.get(index2) + (double)(2.0f - dosages[index2]) * Math.abs(this.ororbeta.get(index)));
                                    if (index2 >= 20) continue;
                                    System.out.print(" added (second allele,other strand) " + (double)(2.0f - dosages[index2]) * Math.abs(this.ororbeta.get(index)) + "**" + alleles.get(index2).getAllelesAsString().get(0) + "**");
                                    continue;
                                }
                                if (usedriskallele.equals(snpVariantByPos.getVariantAlleles().get(0).toString())) {
                                    score.set(index2, (Double)score.get(index2) + (double)dosages[index2]);
                                    if (index2 < 20) {
                                        System.out.print(" added (first allele, orig strand) " + dosages[index2] + "**" + alleles.get(index2).getAllelesAsString().get(0) + "**");
                                    }
                                }
                                if (usedriskallele.equals(snpVariantByPos.getVariantAlleles().get(1).toString())) {
                                    score.set(index2, (Double)score.get(index2) + (double)(2.0f - dosages[index2]));
                                    if (index2 < 20) {
                                        System.out.print(" added (second allele, orig strand) " + (2.0f - dosages[index2]) + "**" + alleles.get(index2).getAllelesAsString().get(0) + "**");
                                    }
                                }
                                if (intHarmonizedData) continue;
                                if (usedriskallele.equals("C")) {
                                    complementriskallele = "G";
                                }
                                if (usedriskallele.equals("G")) {
                                    complementriskallele = "C";
                                }
                                if (usedriskallele.equals("A")) {
                                    complementriskallele = "T";
                                }
                                if (usedriskallele.equals("T")) {
                                    complementriskallele = "A";
                                }
                                if (complementriskallele.equals(snpVariantByPos.getVariantAlleles().get(0).toString())) {
                                    score.set(index2, (Double)score.get(index2) + (double)dosages[index2]);
                                    if (index2 < 20) {
                                        System.out.print(" added (first allele, other strand) " + dosages[index2] + "**" + alleles.get(index2).getAllelesAsString().get(0) + "**");
                                    }
                                }
                                if (!complementriskallele.equals(snpVariantByPos.getVariantAlleles().get(1).toString())) continue;
                                score.set(index2, (Double)score.get(index2) + (double)(2.0f - dosages[index2]));
                                if (index2 >= 20) continue;
                                System.out.print(" added (second allele, other strand) " + (2.0f - dosages[index2]) + "**" + alleles.get(index2).getAllelesAsString().get(0) + "**");
                            }
                            break block38;
                        }
                        System.out.print("      SNP excluded because non-harmonized data and SNP is a GC/AT snp");
                    }
                    catch (NullPointerException ex) {
                        System.out.print("       No genotype data for this genomic position");
                    }
                } else {
                    System.out.print("      SNP excluded because Pvalue not low enough");
                }
            }
            System.out.println();
        }
        System.out.println("IN CALCULATOR FIRST SCORE: " + score.get(0));
        System.out.println("IN CALCULATOR SECND SCORE: " + score.get(1));
        for (index = 0; index < genotypeData.getSampleNames().length; ++index) {
            scores.put(genotypeData.getSampleNames()[index], (Double)score.get(index));
        }
        return scores;
    }

    @Override
    public TObjectDoubleHashMap<String> calculateRiskScores(RandomAccessGenotypeData genotypeData, PhenotypeData phenotypeData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPhenotype() {
        return this.phenotype;
    }

    public void setPhenotype(String phenotype) {
        this.phenotype = phenotype;
    }

    public void addChr(Integer chr) {
        this.chr.add(chr);
    }

    public void addPos(Integer pos) {
        this.pos.add(pos);
    }

    public void addRsid(String rsid) {
        this.rsid.add(rsid);
    }

    public void addRiskallele(String riskallele) {
        this.riskallele.add(riskallele);
    }

    public void addOtherallele(String riskallele) {
        this.otherallele.add(riskallele);
    }

    public void addOrorbeta(Double ororbeta) {
        this.ororbeta.add(ororbeta);
    }

    public void addPvalue(Double pvalue) {
        this.pvalue.add(pvalue);
    }
}

