/*
 * Decompiled with CFR 0.152.
 */
package nl.systemsgenetics.geneticriskscorecalculator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import nl.systemsgenetics.geneticriskscorecalculator.GeneticRiskScoreCalculator;
import nl.systemsgenetics.geneticriskscorecalculator.SimpleGeneticRiskScoreCalculator;
import umcg.genetica.io.text.TextFile;

public class GwasCatalogLoader {
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");

    public List<GeneticRiskScoreCalculator> getGeneticRiskScoreCalculators(String myFile) {
        ArrayList<GeneticRiskScoreCalculator> geneticRiskScoreCalculators = new ArrayList<GeneticRiskScoreCalculator>();
        ArrayList<String> phenotypes = new ArrayList<String>();
        phenotypes.add("CD");
        phenotypes.add("UC");
        phenotypes.add("IBD");
        for (String currentPhenotype : phenotypes) {
            SimpleGeneticRiskScoreCalculator firstCalculator = new SimpleGeneticRiskScoreCalculator();
            firstCalculator.setPhenotype(currentPhenotype);
            int index = 0;
            try {
                String fileLine;
                TextFile riskSnpsFile = new TextFile(myFile, false);
                riskSnpsFile.readLine();
                while ((fileLine = riskSnpsFile.readLine()) != null) {
                    String[] fileLineData = TAB_PATTERN.split(fileLine);
                    if (index < 5) {
                        // empty if block
                    }
                    if (index < 5) {
                        // empty if block
                    }
                    try {
                        if (fileLineData[0].equals(currentPhenotype)) {
                            firstCalculator.addChr(Integer.valueOf(fileLineData[1]));
                            firstCalculator.addPos(Integer.valueOf(fileLineData[2]));
                            firstCalculator.addRsid(fileLineData[3]);
                            firstCalculator.addRiskallele(fileLineData[4]);
                            firstCalculator.addOtherallele(fileLineData[5]);
                            firstCalculator.addPvalue(Double.valueOf(fileLineData[7]));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.err.println("no integer in chr or pos field");
                    }
                    try {
                        if (fileLineData[0].equals(currentPhenotype)) {
                            firstCalculator.addOrorbeta(Double.valueOf(fileLineData[8]));
                        }
                    }
                    catch (NumberFormatException e) {
                        firstCalculator.addOrorbeta(Double.valueOf("0"));
                        System.err.println("effect size missing: set to zero");
                    }
                    ++index;
                }
                riskSnpsFile.close();
            }
            catch (IOException ex) {
                System.err.println("Unable to load risk snps file.");
                System.exit(1);
            }
            geneticRiskScoreCalculators.add(firstCalculator);
        }
        return geneticRiskScoreCalculators;
    }
}

