/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

class GeomBuffer {
    static final int QUAD_STRIP = 1;
    static final int TRIANGLES = 2;
    static final int QUADS = 4;
    static final int TRIANGLE_FAN = 16;
    static final int TRIANGLE_STRIP = 32;
    private int flags;
    static final int GENERATE_NORMALS = 1;
    static final int GENERATE_TEXTURE_COORDS = 2;
    Point3f[] pts = null;
    Vector3f[] normals = null;
    TexCoord2f[] tcoords = null;
    int currVertCnt;
    int currPrimCnt;
    int[] currPrimType = null;
    int[] currPrimStartVertex = null;
    int[] currPrimEndVertex = null;
    GeometryArray geometry;
    int numVerts = 0;
    int numTris = 0;
    int numTexUnit = 1;
    int[] texCoordSetMap = null;
    static final int debug = 0;

    GeomBuffer(int n, int n2) {
        this.numTexUnit = n2;
        this.pts = new Point3f[n];
        this.normals = new Vector3f[n];
        this.tcoords = new TexCoord2f[n];
        this.currPrimType = new int[n / 3];
        this.currPrimStartVertex = new int[n / 3];
        this.currPrimEndVertex = new int[n / 3];
        this.currVertCnt = 0;
        this.currPrimCnt = 0;
        this.texCoordSetMap = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.texCoordSetMap[n3] = 0;
            ++n3;
        }
    }

    GeomBuffer(int n) {
        this(n, 1);
    }

    GeometryArray getGeom(int n) {
        GeometryArray geometryArray = null;
        this.flags = n;
        this.numTris = 0;
        switch (this.currPrimType[0]) {
            case 2: {
                geometryArray = this.processTriangles();
                break;
            }
            case 4: {
                geometryArray = this.processQuads();
                break;
            }
            case 1: 
            case 32: {
                geometryArray = this.processQuadStrips();
                break;
            }
            case 16: {
                geometryArray = this.processTriangleFan();
            }
        }
        if (geometryArray != null && (this.flags & 0x20) != 0) {
            geometryArray.setCapability(18);
            geometryArray.setCapability(17);
            geometryArray.setCapability(8);
            geometryArray.setCapability(0);
        }
        return geometryArray;
    }

    void begin(int n) {
        this.currPrimType[this.currPrimCnt] = n;
        this.currPrimStartVertex[this.currPrimCnt] = this.currVertCnt;
    }

    void end() {
        this.currPrimEndVertex[this.currPrimCnt] = this.currVertCnt;
        ++this.currPrimCnt;
    }

    void vertex3d(double d, double d2, double d3) {
        this.pts[this.currVertCnt] = new Point3f((float)d, (float)d2, (float)d3);
        ++this.currVertCnt;
    }

    void normal3d(double d, double d2, double d3) {
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (Math.abs(d4 - 1.0) > 0.001) {
            double d5 = Math.sqrt(d4);
            if (d5 > 1.0E-6) {
                d /= d5;
                d2 /= d5;
                d3 /= d5;
            } else {
                d3 = 0.0;
                d2 = 0.0;
                d = 1.0;
            }
        }
        this.normals[this.currVertCnt] = new Vector3f((float)d, (float)d2, (float)d3);
    }

    void texCoord2d(double d, double d2) {
        this.tcoords[this.currVertCnt] = new TexCoord2f((float)d, (float)d2);
    }

    GeometryArray getComputedGeometry() {
        return this.geometry;
    }

    int getNumTris() {
        return this.numTris;
    }

    int getNumVerts() {
        return this.numVerts;
    }

    private GeometryArray processQuadStrips() {
        TriangleStripArray triangleStripArray = null;
        int n = 0;
        int[] nArray = new int[this.currPrimCnt];
        int n2 = 0;
        while (n2 < this.currPrimCnt) {
            nArray[n2] = this.currPrimEndVertex[n2] - this.currPrimStartVertex[n2];
            n += nArray[n2];
            ++n2;
        }
        int n3 = 1;
        if ((this.flags & 1) != 0) {
            n3 |= 2;
        }
        if ((this.flags & 2) != 0) {
            n3 |= 0x20;
        }
        triangleStripArray = new TriangleStripArray(n, n3, 1, this.texCoordSetMap, nArray);
        Point3f[] point3fArray = new Point3f[n];
        Vector3f[] vector3fArray = new Vector3f[n];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n];
        int n4 = 0;
        n2 = 0;
        while (n2 < this.currPrimCnt) {
            int n5 = this.currPrimStartVertex[n2];
            while (n5 < this.currPrimEndVertex[n2]) {
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, n5);
                ++n5;
            }
            ++n2;
        }
        this.numVerts = n4;
        this.numTris += n - this.currPrimCnt * 2;
        triangleStripArray.setCoordinates(0, point3fArray);
        if ((this.flags & 1) != 0) {
            triangleStripArray.setNormals(0, vector3fArray);
        }
        if ((this.flags & 2) != 0) {
            triangleStripArray.setTextureCoordinates(0, 0, texCoord2fArray);
        }
        this.geometry = triangleStripArray;
        return triangleStripArray;
    }

    private GeometryArray processQuads() {
        QuadArray quadArray = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.currPrimCnt) {
            n += this.currPrimEndVertex[n2] - this.currPrimStartVertex[n2];
            ++n2;
        }
        quadArray = (this.flags & 1) != 0 && (this.flags & 2) != 0 ? new QuadArray(n, 35, 1, this.texCoordSetMap) : ((this.flags & 1) == 0 && (this.flags & 2) != 0 ? new QuadArray(n, 33, 1, this.texCoordSetMap) : ((this.flags & 1) != 0 && (this.flags & 2) == 0 ? new QuadArray(n, 3) : new QuadArray(n, 1)));
        Point3f[] point3fArray = new Point3f[n];
        Vector3f[] vector3fArray = new Vector3f[n];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n];
        int n3 = 0;
        n2 = 0;
        while (n2 < this.currPrimCnt) {
            int n4 = this.currPrimStartVertex[n2];
            while (n4 < this.currPrimEndVertex[n2] - 3) {
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n3++, this.pts, this.normals, this.tcoords, n4);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n3++, this.pts, this.normals, this.tcoords, n4 + 1);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n3++, this.pts, this.normals, this.tcoords, n4 + 2);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n3++, this.pts, this.normals, this.tcoords, n4 + 3);
                this.numTris += 2;
                n4 += 4;
            }
            ++n2;
        }
        this.numVerts = n3;
        quadArray.setCoordinates(0, point3fArray);
        if ((this.flags & 1) != 0) {
            quadArray.setNormals(0, vector3fArray);
        }
        if ((this.flags & 2) != 0) {
            quadArray.setTextureCoordinates(0, 0, texCoord2fArray);
        }
        this.geometry = quadArray;
        return quadArray;
    }

    private GeometryArray processTriangles() {
        TriangleArray triangleArray = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.currPrimCnt) {
            n += this.currPrimEndVertex[n2] - this.currPrimStartVertex[n2];
            ++n2;
        }
        triangleArray = (this.flags & 1) != 0 && (this.flags & 2) != 0 ? new TriangleArray(n, 35, 1, this.texCoordSetMap) : ((this.flags & 1) == 0 && (this.flags & 2) != 0 ? new TriangleArray(n, 33, 1, this.texCoordSetMap) : ((this.flags & 1) != 0 && (this.flags & 2) == 0 ? new TriangleArray(n, 3) : new TriangleArray(n, 1)));
        Point3f[] point3fArray = new Point3f[n];
        Vector3f[] vector3fArray = new Vector3f[n];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n];
        int n3 = 0;
        n2 = 0;
        while (n2 < this.currPrimCnt) {
            int n4 = this.currPrimStartVertex[n2];
            while (n4 < this.currPrimEndVertex[n2] - 2) {
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n3++, this.pts, this.normals, this.tcoords, n4);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n3++, this.pts, this.normals, this.tcoords, n4 + 1);
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n3++, this.pts, this.normals, this.tcoords, n4 + 2);
                ++this.numTris;
                n4 += 3;
            }
            ++n2;
        }
        this.numVerts = n3;
        triangleArray.setCoordinates(0, point3fArray);
        if ((this.flags & 1) != 0) {
            triangleArray.setNormals(0, vector3fArray);
        }
        if ((this.flags & 2) != 0) {
            triangleArray.setTextureCoordinates(0, 0, texCoord2fArray);
        }
        this.geometry = triangleArray;
        return triangleArray;
    }

    private GeometryArray processTriangleFan() {
        TriangleFanArray triangleFanArray = null;
        int n = 0;
        int[] nArray = new int[this.currPrimCnt];
        int n2 = 0;
        while (n2 < this.currPrimCnt) {
            nArray[n2] = this.currPrimEndVertex[n2] - this.currPrimStartVertex[n2];
            n += nArray[n2];
            ++n2;
        }
        int n3 = 1;
        if ((this.flags & 1) != 0) {
            n3 |= 2;
        }
        if ((this.flags & 2) != 0) {
            n3 |= 0x20;
        }
        triangleFanArray = new TriangleFanArray(n, n3, 1, this.texCoordSetMap, nArray);
        Point3f[] point3fArray = new Point3f[n];
        Vector3f[] vector3fArray = new Vector3f[n];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n];
        int n4 = 0;
        n2 = 0;
        while (n2 < this.currPrimCnt) {
            int n5 = this.currPrimStartVertex[n2];
            while (n5 < this.currPrimEndVertex[n2]) {
                this.outVertex(point3fArray, vector3fArray, texCoord2fArray, n4++, this.pts, this.normals, this.tcoords, n5);
                ++n5;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < point3fArray.length) {
            ++n2;
        }
        this.numVerts = n4;
        this.numTris = n - this.currPrimCnt * 2;
        triangleFanArray.setCoordinates(0, point3fArray);
        if ((this.flags & 1) != 0) {
            triangleFanArray.setNormals(0, vector3fArray);
        }
        if ((this.flags & 2) != 0) {
            triangleFanArray.setTextureCoordinates(0, 0, texCoord2fArray);
        }
        this.geometry = triangleFanArray;
        return triangleFanArray;
    }

    void outVertex(Point3f[] point3fArray, Vector3f[] vector3fArray, TexCoord2f[] texCoord2fArray, int n, Point3f[] point3fArray2, Vector3f[] vector3fArray2, TexCoord2f[] texCoord2fArray2, int n2) {
        point3fArray[n] = new Point3f(point3fArray2[n2]);
        if ((this.flags & 1) != 0) {
            vector3fArray[n] = new Vector3f(vector3fArray2[n2]);
        }
        if ((this.flags & 2) != 0) {
            texCoord2fArray[n] = new TexCoord2f(texCoord2fArray2[n2]);
        }
    }
}

