/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.FogRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.MultipleParentException;
import javax.media.j3d.NnuId;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Targets;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.ViewSpecificGroupRetained;
import javax.media.j3d.VirtualUniverse;

class GroupRetained
extends NodeRetained
implements BHLeafInterface {
    ArrayList children = new ArrayList(1);
    Bounds collisionBound = null;
    Locale locale = null;
    ArrayList lights = null;
    ArrayList fogs = null;
    ArrayList modelClips = null;
    ArrayList altAppearances = null;
    boolean collisionTarget = false;
    ArrayList childrenSwitchLinks = null;
    int parentSwitchLinkChildIndex = -1;
    ArrayList orderedPaths = null;
    BoundingBox collisionVwcBounds;
    ArrayList mirrorGroup;
    HashKey key;
    GroupRetained sourceNode;
    BHLeafNode bhLeafNode = null;
    boolean isRoot = false;
    boolean allocatedLights = false;
    boolean allocatedFogs = false;
    boolean allocatedMclips = false;
    boolean allocatedAltApps = false;
    int scopingRefCount = 0;
    ArrayList compiledChildrenList = null;
    boolean isInClearLive = false;
    ArrayList viewLists = null;
    boolean inViewSpecificGroup = false;

    GroupRetained() {
        this.nodeType = 23;
        this.localBounds = new BoundingSphere();
        ((BoundingSphere)this.localBounds).setRadius(-1.0);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8256;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChild(Node node, int n) {
        this.checkValidChild(node, "GroupRetained0");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doSetChild(node, n);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doSetChild(node, n);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doSetChild(Node node, int n) {
        J3dMessage[] j3dMessageArray = null;
        int n2 = 0;
        int n3 = 0;
        NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
        if (this.source.isLive()) {
            if (nodeRetained != null) {
                n2 += 3;
                n3 = 3;
            }
            if (node != null) {
                n2 += 4;
            }
            j3dMessageArray = new J3dMessage[n2];
            int n4 = 0;
            while (n4 < n2) {
                j3dMessageArray[n4] = VirtualUniverse.mc.getMessage();
                ++n4;
            }
        }
        if (nodeRetained != null) {
            nodeRetained.setParent(null);
            this.checkClearLive(nodeRetained, j3dMessageArray, 0, n, null);
        }
        this.removeChildrenData(n);
        if (node == null) {
            this.children.set(n, null);
            if (j3dMessageArray != null) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
            return;
        }
        NodeRetained nodeRetained2 = (NodeRetained)node.retained;
        nodeRetained2.setParent(this);
        this.children.set(n, nodeRetained2);
        this.insertChildrenData(n);
        this.checkSetLive(nodeRetained2, n, j3dMessageArray, n3, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained2).isNew = true;
        }
        if (j3dMessageArray != null) {
            VirtualUniverse.mc.processMessage(j3dMessageArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertChild(Node node, int n) {
        this.checkValidChild(node, "GroupRetained1");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doInsertChild(node, n);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doInsertChild(node, n);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doInsertChild(Node node, int n) {
        this.insertChildrenData(n);
        int n2 = n;
        while (n2 < this.children.size()) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(n2);
            if (nodeRetained != null) {
                ++nodeRetained.childIndex;
            }
            ++n2;
        }
        if (node == null) {
            this.children.add(n, null);
            return;
        }
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        nodeRetained.setParent(this);
        this.children.add(n, nodeRetained);
        this.checkSetLive(nodeRetained, n, null, 0, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained).isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(int n) {
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doRemoveChild(n, null, 0);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doRemoveChild(n, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    int indexOfChild(Node node) {
        if (node != null) {
            return this.children.indexOf((NodeRetained)node.retained);
        }
        return this.children.indexOf(null);
    }

    void removeChild(Node node) {
        int n = this.indexOfChild(node);
        if (n >= 0) {
            this.removeChild(n);
        }
    }

    void removeAllChildren() {
        int n = this.children.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.removeChild(n2);
            --n2;
        }
    }

    void doRemoveChild(int n, J3dMessage[] j3dMessageArray, int n2) {
        NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
        int n3 = this.children.size();
        int n4 = n;
        while (n4 < n3) {
            NodeRetained nodeRetained2 = (NodeRetained)this.children.get(n4);
            if (nodeRetained2 != null) {
                --nodeRetained2.childIndex;
            }
            ++n4;
        }
        if (nodeRetained != null) {
            nodeRetained.setParent(null);
            this.checkClearLive(nodeRetained, j3dMessageArray, n2, n, null);
        }
        this.children.remove(n);
        this.removeChildrenData(n);
        if (this.nodeType == 18) {
            SwitchRetained switchRetained = (SwitchRetained)this;
            switchRetained.setWhichChild(switchRetained.whichChild, true);
        }
    }

    Node getChild(int n) {
        SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
        if (sceneGraphObjectRetained == null) {
            return null;
        }
        return (Node)sceneGraphObjectRetained.source;
    }

    Enumeration getAllChildren() {
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.children.size());
        int n = 0;
        while (n < this.children.size()) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
            if (sceneGraphObjectRetained != null) {
                vector.add(sceneGraphObjectRetained.source);
            } else {
                vector.add(null);
            }
            ++n;
        }
        return vector.elements();
    }

    void checkValidChild(Node node, String string) {
        if (node != null && (node instanceof BranchGroup && ((BranchGroupRetained)node.retained).attachedToLocale || ((NodeRetained)node.retained).parent != null)) {
            throw new MultipleParentException(J3dI18N.getString(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(Node node) {
        this.checkValidChild(node, "GroupRetained2");
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doAddChild(node, null, 0);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doAddChild(node, null, 0);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doAddChild(Node node, J3dMessage[] j3dMessageArray, int n) {
        this.appendChildrenData();
        if (node == null) {
            this.children.add(null);
            return;
        }
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        nodeRetained.setParent(this);
        this.children.add(nodeRetained);
        this.checkSetLive(nodeRetained, this.children.size() - 1, j3dMessageArray, n, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained).isNew = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTo(BranchGroup branchGroup) {
        if (this.source.isLive()) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doMoveTo(branchGroup);
                this.universe.setLiveState.clear();
            }
            this.universe.waitForMC();
        } else {
            this.doMoveTo(branchGroup);
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void doMoveTo(BranchGroup branchGroup) {
        J3dMessage[] j3dMessageArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (branchGroup != null) {
            BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
            GroupRetained groupRetained = (GroupRetained)branchGroupRetained.parent;
            if (groupRetained != null) {
                if (groupRetained.source.isLive()) {
                    n = 3;
                    n3 = 3;
                } else {
                    n = 0;
                    n3 = 0;
                }
            } else {
                n = 3;
                n3 = 3;
            }
            if (this.source.isLive()) {
                n += 4;
            }
            j3dMessageArray = new J3dMessage[n];
            int n4 = 0;
            while (n4 < n) {
                j3dMessageArray[n4] = VirtualUniverse.mc.getMessage();
                j3dMessageArray[n4].type = -1;
                ++n4;
            }
            if (groupRetained == null) {
                if (branchGroupRetained.locale != null) {
                    branchGroupRetained.locale.doRemoveBranchGraph(branchGroup, j3dMessageArray, n2);
                }
            } else {
                groupRetained.doRemoveChild(groupRetained.children.indexOf(branchGroupRetained), j3dMessageArray, n2);
            }
        }
        this.doAddChild(branchGroup, j3dMessageArray, n3);
        if (n > 0) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                if (j3dMessageArray[n6].type != -1) {
                    ++n5;
                }
                ++n6;
            }
            if (n5 == n) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            } else {
                J3dMessage[] j3dMessageArray2 = null;
                if (n5 > 0) {
                    j3dMessageArray2 = new J3dMessage[n5];
                }
                int n7 = 0;
                int n8 = 0;
                while (n8 < n) {
                    if (j3dMessageArray[n8].type != -1) {
                        j3dMessageArray2[n7++] = j3dMessageArray[n8];
                    } else {
                        VirtualUniverse.mc.addMessageToFreelists(j3dMessageArray[n8]);
                    }
                    ++n8;
                }
                if (j3dMessageArray2 != null) {
                    VirtualUniverse.mc.processMessage(j3dMessageArray2);
                }
            }
        }
    }

    int numChildren() {
        return this.children.size();
    }

    void removeLight(int n, LightRetained[] lightRetainedArray, HashKey hashKey) {
        block3: {
            block2: {
                if (!this.inSharedGroup) break block2;
                int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                ArrayList arrayList = (ArrayList)this.lights.get(n2);
                if (arrayList == null) break block3;
                int n3 = 0;
                while (n3 < n) {
                    int n4 = arrayList.indexOf(lightRetainedArray[n3]);
                    arrayList.remove(n4);
                    ++n3;
                }
                break block3;
            }
            ArrayList arrayList = (ArrayList)this.lights.get(0);
            int n5 = 0;
            while (n5 < n) {
                int n6 = arrayList.indexOf(lightRetainedArray[n5]);
                arrayList.remove(n6);
                ++n5;
            }
        }
    }

    void addAllNodesForScopedLight(int n, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2 = 0;
            while (n2 < this.localToVworldKeys.length) {
                hashKey.set(this.localToVworldKeys[n2]);
                this.processAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey);
                ++n2;
            }
        } else {
            this.processAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey);
        }
    }

    void processAllNodesForScopedLight(int n, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedLights) {
            this.addLight(lightRetainedArray, n, hashKey);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            int n2 = this.children.size() - 1;
            while (n2 >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n2);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).processAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n3 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.processAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n3;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    }
                }
                --n2;
            }
        }
    }

    void removeAllNodesForScopedLight(int n, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n2 = 0;
            while (n2 < this.localToVworldKeys.length) {
                hashKey.set(this.localToVworldKeys[n2]);
                this.processRemoveAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey);
                ++n2;
            }
        } else {
            this.processRemoveAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey);
        }
    }

    void processRemoveAllNodesForScopedLight(int n, LightRetained[] lightRetainedArray, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedLights) {
            this.removeLight(n, lightRetainedArray, hashKey);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            int n2 = this.children.size() - 1;
            while (n2 >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n2);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                        ((GroupRetained)nodeRetained).processRemoveAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n3 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.processRemoveAllNodesForScopedLight(n, lightRetainedArray, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n3;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    }
                }
                --n2;
            }
        }
    }

    void addAllNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                hashKey.set(this.localToVworldKeys[n]);
                this.processAddNodesForScopedFog(fogRetained, arrayList, hashKey);
                ++n;
            }
        } else {
            this.processAddNodesForScopedFog(fogRetained, arrayList, hashKey);
        }
    }

    void processAddNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedFogs) {
            this.addFog(fogRetained, hashKey);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).processAddNodesForScopedFog(fogRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.processAddNodesForScopedFog(fogRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void removeAllNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                hashKey.set(this.localToVworldKeys[n]);
                this.processRemoveAllNodesForScopedFog(fogRetained, arrayList, hashKey);
                ++n;
            }
        } else {
            this.processRemoveAllNodesForScopedFog(fogRetained, arrayList, hashKey);
        }
    }

    void processRemoveAllNodesForScopedFog(FogRetained fogRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedFogs) {
            this.removeFog(fogRetained, hashKey);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                        ((GroupRetained)nodeRetained).processRemoveAllNodesForScopedFog(fogRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.processRemoveAllNodesForScopedFog(fogRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void addAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                hashKey.set(this.localToVworldKeys[n]);
                this.processAddNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
                ++n;
            }
        } else {
            this.processAddNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
        }
    }

    void processAddNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedMclips) {
            this.addModelClip(modelClipRetained, hashKey);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).processAddNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.processAddNodesForScopedModelClip(modelClipRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void removeAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                hashKey.set(this.localToVworldKeys[n]);
                this.processRemoveAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
                ++n;
            }
        } else {
            this.processRemoveAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
        }
    }

    void processRemoveAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedMclips) {
            this.removeModelClip(modelClipRetained, hashKey);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                        ((GroupRetained)nodeRetained).processRemoveAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.processRemoveAllNodesForScopedModelClip(modelClipRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void addAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                hashKey.set(this.localToVworldKeys[n]);
                this.processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
                ++n;
            }
        } else {
            this.processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
        }
    }

    void processAddNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedAltApps) {
            this.addAltApp(alternateAppearanceRetained, hashKey);
        }
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void removeAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                hashKey.set(this.localToVworldKeys[n]);
                this.processRemoveNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
                ++n;
            }
        } else {
            this.processAddNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
        }
    }

    void processRemoveNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, ArrayList arrayList, HashKey hashKey) {
        if (this.allocatedAltApps) {
            this.removeAltApp(alternateAppearanceRetained, hashKey);
        }
        if (this.source.isLive() && !this.isInClearLive) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && nodeRetained.source.isLive() && !((GroupRetained)nodeRetained).isInClearLive) {
                        ((GroupRetained)nodeRetained).processRemoveNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && nodeRetained.source.isLive()) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.processRemoveNodesForScopedAltApp(alternateAppearanceRetained, arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getMirrorObjects(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    synchronized void setLightScope() {
        if (!this.allocatedLights) {
            ArrayList<Object> arrayList;
            this.allocatedLights = true;
            if (this.lights != null) {
                arrayList = new ArrayList<Object>(this.lights.size());
                int n = this.lights.size();
                int n2 = 0;
                while (n2 < n) {
                    ArrayList arrayList2 = (ArrayList)this.lights.get(n2);
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2.clone());
                    } else {
                        arrayList.add(null);
                    }
                    ++n2;
                }
            } else if (this.inSharedGroup) {
                arrayList = new ArrayList();
                int n = 0;
                while (n < this.localToVworldKeys.length) {
                    arrayList.add(new ArrayList());
                    ++n;
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add(new ArrayList());
            }
            this.lights = arrayList;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeLightScope() {
        --this.scopingRefCount;
    }

    synchronized void setFogScope() {
        if (!this.allocatedFogs) {
            ArrayList<Object> arrayList;
            this.allocatedFogs = true;
            if (this.fogs != null) {
                arrayList = new ArrayList<Object>(this.fogs.size());
                int n = this.fogs.size();
                int n2 = 0;
                while (n2 < n) {
                    ArrayList arrayList2 = (ArrayList)this.fogs.get(n2);
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2.clone());
                    } else {
                        arrayList.add(null);
                    }
                    ++n2;
                }
            } else if (this.inSharedGroup) {
                arrayList = new ArrayList();
                int n = 0;
                while (n < this.localToVworldKeys.length) {
                    arrayList.add(new ArrayList());
                    ++n;
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add(new ArrayList());
            }
            this.fogs = arrayList;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeFogScope() {
        --this.scopingRefCount;
    }

    synchronized void setMclipScope() {
        if (!this.allocatedMclips) {
            ArrayList<Object> arrayList;
            this.allocatedMclips = true;
            if (this.modelClips != null) {
                arrayList = new ArrayList<Object>(this.modelClips.size());
                int n = this.modelClips.size();
                int n2 = 0;
                while (n2 < n) {
                    ArrayList arrayList2 = (ArrayList)this.modelClips.get(n2);
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2.clone());
                    } else {
                        arrayList.add(null);
                    }
                    ++n2;
                }
            } else if (this.inSharedGroup) {
                arrayList = new ArrayList();
                int n = 0;
                while (n < this.localToVworldKeys.length) {
                    arrayList.add(new ArrayList());
                    ++n;
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add(new ArrayList());
            }
            this.modelClips = arrayList;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeMclipScope() {
        --this.scopingRefCount;
    }

    synchronized void setAltAppScope() {
        if (!this.allocatedAltApps) {
            ArrayList<Object> arrayList;
            this.allocatedAltApps = true;
            if (this.altAppearances != null) {
                arrayList = new ArrayList<Object>(this.altAppearances.size());
                int n = this.altAppearances.size();
                int n2 = 0;
                while (n2 < n) {
                    ArrayList arrayList2 = (ArrayList)this.altAppearances.get(n2);
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2.clone());
                    } else {
                        arrayList.add(null);
                    }
                    ++n2;
                }
            } else if (this.inSharedGroup) {
                arrayList = new ArrayList();
                int n = 0;
                while (n < this.localToVworldKeys.length) {
                    arrayList.add(new ArrayList());
                    ++n;
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add(new ArrayList());
            }
            this.altAppearances = arrayList;
        }
        ++this.scopingRefCount;
    }

    synchronized void removeAltAppScope() {
        --this.scopingRefCount;
    }

    synchronized boolean usedInScoping() {
        return this.scopingRefCount > 0;
    }

    void addLight(LightRetained[] lightRetainedArray, int n, HashKey hashKey) {
        block3: {
            block2: {
                if (!this.inSharedGroup) break block2;
                int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                ArrayList arrayList = (ArrayList)this.lights.get(n2);
                if (arrayList == null) break block3;
                int n3 = 0;
                while (n3 < n) {
                    arrayList.add(lightRetainedArray[n3]);
                    ++n3;
                }
                break block3;
            }
            ArrayList arrayList = (ArrayList)this.lights.get(0);
            int n4 = 0;
            while (n4 < n) {
                arrayList.add(lightRetainedArray[n4]);
                ++n4;
            }
        }
    }

    void addFog(FogRetained fogRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.fogs.get(n);
            if (arrayList != null) {
                arrayList.add(fogRetained);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.fogs.get(0);
            arrayList.add(fogRetained);
        }
    }

    void addModelClip(ModelClipRetained modelClipRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.modelClips.get(n);
            if (arrayList != null) {
                arrayList.add(modelClipRetained);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.modelClips.get(0);
            arrayList.add(modelClipRetained);
        }
    }

    void addAltApp(AlternateAppearanceRetained alternateAppearanceRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.altAppearances.get(n);
            if (arrayList != null) {
                arrayList.add(alternateAppearanceRetained);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.altAppearances.get(0);
            arrayList.add(alternateAppearanceRetained);
        }
    }

    void removeFog(FogRetained fogRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.fogs.get(n);
            if (arrayList != null) {
                int n2 = arrayList.indexOf(fogRetained);
                arrayList.remove(n2);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.fogs.get(0);
            int n = arrayList.indexOf(fogRetained);
            arrayList.remove(n);
        }
    }

    void removeModelClip(ModelClipRetained modelClipRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.modelClips.get(n);
            if (arrayList != null) {
                int n2 = arrayList.indexOf(modelClipRetained);
                arrayList.remove(n2);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.modelClips.get(0);
            int n = arrayList.indexOf(modelClipRetained);
            arrayList.remove(n);
        }
    }

    void removeAltApp(AlternateAppearanceRetained alternateAppearanceRetained, HashKey hashKey) {
        if (this.inSharedGroup) {
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            ArrayList arrayList = (ArrayList)this.altAppearances.get(n);
            if (arrayList != null) {
                int n2 = arrayList.indexOf(alternateAppearanceRetained);
                arrayList.remove(n2);
            }
        } else {
            ArrayList arrayList = (ArrayList)this.altAppearances.get(0);
            int n = arrayList.indexOf(alternateAppearanceRetained);
            arrayList.remove(n);
        }
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        NodeRetained nodeRetained;
        int n = this.children.size() - 1;
        super.updatePickable(hashKeyArray, blArray);
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            nodeRetained = (NodeRetained)this.children.get(n2);
            if (nodeRetained != null) {
                nodeRetained.updatePickable(hashKeyArray, (boolean[])blArray.clone());
            }
            ++n2;
        }
        nodeRetained = (NodeRetained)this.children.get(n2);
        if (nodeRetained != null) {
            nodeRetained.updatePickable(hashKeyArray, blArray);
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        NodeRetained nodeRetained;
        int n = this.children.size() - 1;
        super.updateCollidable(hashKeyArray, blArray);
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            nodeRetained = (NodeRetained)this.children.get(n2);
            if (nodeRetained != null) {
                nodeRetained.updateCollidable(hashKeyArray, (boolean[])blArray.clone());
            }
            ++n2;
        }
        nodeRetained = (NodeRetained)this.children.get(n2);
        if (nodeRetained != null) {
            nodeRetained.updateCollidable(hashKeyArray, blArray);
        }
    }

    void setAlternateCollisionTarget(boolean bl) {
        if (this.collisionTarget == bl) {
            return;
        }
        this.collisionTarget = bl;
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 64;
            j3dMessage.universe = this.universe;
            CachedTargets[] cachedTargetsArray = null;
            if (bl) {
                this.createMirrorGroup();
                TargetsInterface targetsInterface = this.getClosestTargetsInterface(0);
                if (targetsInterface != null) {
                    Targets targets = new Targets();
                    int n = this.mirrorGroup.size();
                    cachedTargetsArray = new CachedTargets[n];
                    int n2 = 0;
                    while (n2 < n) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, n2, -1);
                        if (cachedTargets != null) {
                            targets.addNode((NnuId)this.mirrorGroup.get(n2), 6);
                            cachedTargetsArray[n2] = targets.snapShotAdd(cachedTargets);
                        } else {
                            cachedTargetsArray[n2] = null;
                        }
                        ++n2;
                    }
                    targetsInterface.updateTargetThreads(0, cachedTargetsArray);
                    targetsInterface.resetCachedTargets(0, cachedTargetsArray, -1);
                }
                j3dMessage.type = 0;
                j3dMessage.args[0] = this.mirrorGroup.toArray();
                j3dMessage.args[1] = targetsInterface;
                j3dMessage.args[2] = cachedTargetsArray;
            } else {
                TargetsInterface targetsInterface = this.getClosestTargetsInterface(0);
                if (targetsInterface != null) {
                    Targets targets = new Targets();
                    int n = this.mirrorGroup.size();
                    cachedTargetsArray = new CachedTargets[n];
                    int n3 = 0;
                    while (n3 < n) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, n3, -1);
                        if (cachedTargets != null) {
                            targets.addNode((NnuId)this.mirrorGroup.get(n3), 6);
                            cachedTargetsArray[n3] = targets.snapShotRemove(cachedTargets);
                        } else {
                            cachedTargetsArray[n3] = null;
                        }
                        ++n3;
                    }
                    targetsInterface.updateTargetThreads(0, cachedTargetsArray);
                    targetsInterface.resetCachedTargets(0, cachedTargetsArray, -1);
                }
                j3dMessage.type = 1;
                j3dMessage.args[0] = this.mirrorGroup.toArray();
                j3dMessage.args[1] = targetsInterface;
                j3dMessage.args[2] = cachedTargetsArray;
                this.mirrorGroup = null;
            }
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    boolean getAlternateCollisionTarget() {
        return this.collisionTarget;
    }

    void checkSetLive(NodeRetained nodeRetained, int n, J3dMessage[] j3dMessageArray, int n2, NodeRetained nodeRetained2) {
        this.checkSetLive(nodeRetained, n, this.localToVworldKeys, this.inSharedGroup, j3dMessageArray, n2, nodeRetained2);
    }

    void checkSetLive(NodeRetained nodeRetained, int n, HashKey[] hashKeyArray, boolean bl, J3dMessage[] j3dMessageArray, int n2, NodeRetained nodeRetained2) {
        SceneGraphObject sceneGraphObject = this.source;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        if (sceneGraphObject.isLive()) {
            NodeRetained nodeRetained3;
            J3dMessage j3dMessage;
            int n3;
            int n4;
            boolean[] blArray;
            boolean[] blArray2;
            SetLiveState setLiveState = this.universe.setLiveState;
            setLiveState.reset(this.locale);
            setLiveState.refCount = this.refCount;
            setLiveState.inSharedGroup = bl;
            setLiveState.inBackgroundGroup = this.inBackgroundGroup;
            setLiveState.inViewSpecificGroup = this.inViewSpecificGroup;
            setLiveState.geometryBackground = this.geometryBackground;
            setLiveState.keys = hashKeyArray;
            setLiveState.viewLists = this.viewLists;
            setLiveState.parentBranchGroupPaths = this.branchGroupPaths;
            setLiveState.branchGroupPaths = (ArrayList)this.branchGroupPaths.clone();
            setLiveState.orderedPaths = this.orderedPaths;
            setLiveState.lights = this.lights;
            setLiveState.altAppearances = this.altAppearances;
            setLiveState.fogs = this.fogs;
            setLiveState.modelClips = this.modelClips;
            if (!this.inSharedGroup) {
                blArray2 = new boolean[1];
                blArray = new boolean[1];
            } else {
                blArray2 = new boolean[this.localToVworldKeys.length];
                blArray = new boolean[this.localToVworldKeys.length];
            }
            this.findPickableFlags(blArray2);
            super.updatePickable(null, blArray2);
            setLiveState.pickable = blArray2;
            this.findCollidableFlags(blArray);
            super.updateCollidable(null, blArray);
            setLiveState.collidable = blArray;
            TargetsInterface targetsInterface = this.initTransformStates(setLiveState, true);
            TargetsInterface targetsInterface2 = this.initSwitchStates(setLiveState, this, nodeRetained, nodeRetained2, true);
            if (setLiveState.inViewSpecificGroup && setLiveState.changedViewGroup == null) {
                setLiveState.changedViewGroup = new ArrayList();
                setLiveState.changedViewList = new ArrayList();
                setLiveState.keyList = new int[10];
                setLiveState.viewScopedNodeList = new ArrayList();
                setLiveState.scopedNodesViewList = new ArrayList();
            }
            this.childCheckSetLive(nodeRetained, n, setLiveState, nodeRetained2);
            CachedTargets[] cachedTargetsArray = null;
            cachedTargetsArray = this.updateTransformStates(setLiveState, targetsInterface, true);
            this.updateSwitchStates(setLiveState, targetsInterface2, true);
            if (j3dMessageArray == null) {
                n4 = 2;
                if (setLiveState.ogList.size() > 0) {
                    ++n4;
                } else {
                    bl3 = false;
                }
                if (setLiveState.changedViewGroup != null) {
                    ++n4;
                } else {
                    bl4 = false;
                }
                j3dMessageArray = new J3dMessage[n4];
                n2 = 0;
                n3 = 0;
                while (n3 < n4) {
                    j3dMessageArray[n3] = VirtualUniverse.mc.getMessage();
                    ++n3;
                }
                bl2 = true;
            }
            if (bl3) {
                j3dMessage = j3dMessageArray[n2++];
                j3dMessage.threads = 4224;
                j3dMessage.type = 32;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = setLiveState.ogList.toArray();
                j3dMessage.args[1] = setLiveState.ogChildIdList.toArray();
                j3dMessage.args[2] = setLiveState.ogOrderedIdList.toArray();
                j3dMessage.args[3] = setLiveState.ogCIOList.toArray();
                j3dMessage.args[4] = setLiveState.ogCIOTableList.toArray();
            }
            if (bl4) {
                j3dMessage = j3dMessageArray[n2++];
                j3dMessage.threads = 4096;
                j3dMessage.type = 57;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = setLiveState.changedViewGroup;
                j3dMessage.args[1] = setLiveState.changedViewList;
                j3dMessage.args[2] = setLiveState.keyList;
            }
            j3dMessage = j3dMessageArray[n2++];
            j3dMessage.threads = setLiveState.notifyThreads;
            j3dMessage.type = 0;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.nodeList.toArray();
            if (cachedTargetsArray != null) {
                j3dMessage.args[1] = targetsInterface;
                j3dMessage.args[2] = cachedTargetsArray;
            } else {
                j3dMessage.args[1] = null;
                j3dMessage.args[2] = null;
            }
            if (setLiveState.viewScopedNodeList != null) {
                j3dMessage.args[3] = setLiveState.viewScopedNodeList;
                j3dMessage.args[4] = setLiveState.scopedNodesViewList;
            }
            n4 = setLiveState.behaviorNodes.size();
            n3 = 0;
            while (n3 < n4) {
                nodeRetained3 = (BehaviorRetained)setLiveState.behaviorNodes.get(n3);
                ((BehaviorRetained)nodeRetained3).executeInitialize();
                ++n3;
            }
            setLiveState.behaviorNodes.clear();
            j3dMessage = j3dMessageArray[n2++];
            j3dMessage.threads = 256;
            j3dMessage.type = 49;
            j3dMessage.universe = this.universe;
            if (bl2) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
            if (this.nodeType == 18) {
                nodeRetained3 = (SwitchRetained)this;
                ((SwitchRetained)nodeRetained3).setWhichChild(((SwitchRetained)nodeRetained3).whichChild, true);
            }
            setLiveState.reset(null);
        }
    }

    void checkClearLive(NodeRetained nodeRetained, J3dMessage[] j3dMessageArray, int n, int n2, NodeRetained nodeRetained2) {
        this.checkClearLive(nodeRetained, this.localToVworldKeys, this.inSharedGroup, j3dMessageArray, n, n2, nodeRetained2);
    }

    void checkClearLive(NodeRetained nodeRetained, HashKey[] hashKeyArray, boolean bl, J3dMessage[] j3dMessageArray, int n, int n2, NodeRetained nodeRetained2) {
        SceneGraphObject sceneGraphObject = this.source;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        if (sceneGraphObject.isLive()) {
            J3dMessage j3dMessage;
            Object object;
            Object object2;
            SetLiveState setLiveState = this.universe.setLiveState;
            setLiveState.reset(this.locale);
            setLiveState.refCount = this.refCount;
            setLiveState.inSharedGroup = bl;
            setLiveState.inBackgroundGroup = this.inBackgroundGroup;
            setLiveState.inViewSpecificGroup = this.inViewSpecificGroup;
            setLiveState.keys = hashKeyArray;
            setLiveState.fogs = this.fogs;
            setLiveState.lights = this.lights;
            setLiveState.altAppearances = this.altAppearances;
            setLiveState.modelClips = this.modelClips;
            if (this instanceof OrderedGroupRetained && nodeRetained2 == null) {
                setLiveState.ogList.add(this);
                setLiveState.ogChildIdList.add(new Integer(n2));
                setLiveState.ogCIOList.add(this);
                object2 = null;
                object = (OrderedGroupRetained)this;
                if (((OrderedGroupRetained)object).userChildIndexOrder != null) {
                    object2 = new int[((OrderedGroupRetained)object).userChildIndexOrder.length];
                    System.arraycopy(((OrderedGroupRetained)object).userChildIndexOrder, 0, object2, 0, ((OrderedGroupRetained)object).userChildIndexOrder.length);
                }
                setLiveState.ogCIOTableList.add(object2);
            }
            if (!(this instanceof ViewSpecificGroupRetained)) {
                setLiveState.viewLists = this.viewLists;
            }
            object2 = this.initTransformStates(setLiveState, false);
            object = this.initSwitchStates(setLiveState, this, nodeRetained, nodeRetained2, false);
            nodeRetained.clearLive(setLiveState);
            CachedTargets[] cachedTargetsArray = null;
            cachedTargetsArray = this.updateTransformStates(setLiveState, (TargetsInterface)object2, false);
            this.updateSwitchStates(setLiveState, (TargetsInterface)object, false);
            if (j3dMessageArray == null) {
                int n3 = 1;
                if (setLiveState.ogList.size() > 0) {
                    ++n3;
                } else {
                    bl3 = false;
                }
                if (setLiveState.changedViewGroup != null) {
                    ++n3;
                } else {
                    bl4 = false;
                }
                j3dMessageArray = new J3dMessage[n3];
                n = 0;
                int n4 = 0;
                while (n4 < n3) {
                    j3dMessageArray[n4] = VirtualUniverse.mc.getMessage();
                    ++n4;
                }
                bl2 = true;
            }
            if (bl3) {
                j3dMessage = j3dMessageArray[n++];
                j3dMessage.threads = 4224;
                j3dMessage.type = 33;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = setLiveState.ogList.toArray();
                j3dMessage.args[1] = setLiveState.ogChildIdList.toArray();
                j3dMessage.args[3] = setLiveState.ogCIOList.toArray();
                j3dMessage.args[4] = setLiveState.ogCIOTableList.toArray();
            }
            if (bl4) {
                j3dMessage = j3dMessageArray[n++];
                j3dMessage.threads = 4096;
                j3dMessage.type = 58;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = setLiveState.changedViewGroup;
                j3dMessage.args[1] = setLiveState.keyList;
            }
            j3dMessage = j3dMessageArray[n++];
            j3dMessage.threads = setLiveState.notifyThreads;
            j3dMessage.type = 1;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.nodeList.toArray();
            if (cachedTargetsArray != null) {
                j3dMessage.args[1] = object2;
                j3dMessage.args[2] = cachedTargetsArray;
            } else {
                j3dMessage.args[1] = null;
                j3dMessage.args[2] = null;
            }
            if (setLiveState.viewScopedNodeList != null) {
                j3dMessage.args[3] = setLiveState.viewScopedNodeList;
                j3dMessage.args[4] = setLiveState.scopedNodesViewList;
            }
            if (bl2) {
                VirtualUniverse.mc.processMessage(j3dMessageArray);
            }
            setLiveState.reset(null);
        }
    }

    TargetsInterface initTransformStates(SetLiveState setLiveState, boolean bl) {
        Object object;
        int n = this.inSharedGroup ? setLiveState.keys.length : 1;
        TargetsInterface targetsInterface = this.getClosestTargetsInterface(0);
        if (bl) {
            setLiveState.currentTransforms = this.localToVworld;
            setLiveState.currentTransformsIndex = this.localToVworldIndex;
            setLiveState.localToVworldKeys = this.localToVworldKeys;
            setLiveState.localToVworld = setLiveState.currentTransforms;
            setLiveState.localToVworldIndex = setLiveState.currentTransformsIndex;
            setLiveState.parentTransformLink = this.parentTransformLink;
            if (this.parentTransformLink != null) {
                if (this.parentTransformLink instanceof TransformGroupRetained) {
                    object = (TransformGroupRetained)this.parentTransformLink;
                    setLiveState.childTransformLinks = object.childTransformLinks;
                } else {
                    object = (SharedGroupRetained)this.parentTransformLink;
                    setLiveState.childTransformLinks = object.childTransformLinks;
                }
            }
        }
        object = new int[n];
        this.findTransformLevels((int[])object);
        setLiveState.transformLevels = object;
        if (targetsInterface != null) {
            Targets[] targetsArray = new Targets[n];
            int n2 = 0;
            while (n2 < n) {
                targetsArray[n2] = setLiveState.transformLevels[n2] >= 0 ? new Targets() : null;
                ++n2;
            }
            setLiveState.transformTargets = targetsArray;
        }
        return targetsInterface;
    }

    CachedTargets[] updateTransformStates(SetLiveState setLiveState, TargetsInterface targetsInterface, boolean bl) {
        CachedTargets[] cachedTargetsArray = null;
        if (targetsInterface != null) {
            if (bl) {
                boolean bl2 = false;
                cachedTargetsArray = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (setLiveState.transformTargets[0] != null) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, 0, -1);
                        if (cachedTargets != null) {
                            cachedTargetsArray[0] = setLiveState.transformTargets[0].snapShotAdd(cachedTargets);
                        }
                    } else {
                        cachedTargetsArray[0] = null;
                    }
                } else {
                    int n = 0;
                    while (n < setLiveState.keys.length) {
                        if (setLiveState.transformTargets[n] != null) {
                            CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, n, -1);
                            if (cachedTargets != null) {
                                cachedTargetsArray[n] = setLiveState.transformTargets[n].snapShotAdd(cachedTargets);
                            }
                        } else {
                            cachedTargetsArray[n] = null;
                        }
                        ++n;
                    }
                }
            } else {
                cachedTargetsArray = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (setLiveState.transformTargets[0] != null) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, 0, -1);
                        if (cachedTargets != null) {
                            cachedTargetsArray[0] = setLiveState.transformTargets[0].snapShotRemove(cachedTargets);
                        }
                    } else {
                        cachedTargetsArray[0] = null;
                    }
                } else {
                    int n = 0;
                    while (n < setLiveState.keys.length) {
                        if (setLiveState.transformTargets[n] != null) {
                            CachedTargets cachedTargets = targetsInterface.getCachedTargets(0, n, -1);
                            if (cachedTargets != null) {
                                cachedTargetsArray[n] = setLiveState.transformTargets[n].snapShotRemove(cachedTargets);
                            }
                        } else {
                            cachedTargetsArray[n] = null;
                        }
                        ++n;
                    }
                }
            }
            targetsInterface.updateTargetThreads(0, cachedTargetsArray);
            targetsInterface.resetCachedTargets(0, cachedTargetsArray, -1);
        }
        return cachedTargetsArray;
    }

    TargetsInterface initSwitchStates(SetLiveState setLiveState, NodeRetained nodeRetained, NodeRetained nodeRetained2, NodeRetained nodeRetained3, boolean bl) {
        int n;
        this.findSwitchInfo(setLiveState, nodeRetained, nodeRetained2, nodeRetained3);
        TargetsInterface targetsInterface = this.getClosestTargetsInterface(1);
        if (targetsInterface != null) {
            Targets[] targetsArray = null;
            int n2 = this.inSharedGroup ? setLiveState.keys.length : 1;
            targetsArray = new Targets[n2];
            n = 0;
            while (n < n2) {
                targetsArray[n] = setLiveState.switchLevels[n] >= 0 ? new Targets() : null;
                ++n;
            }
            setLiveState.switchTargets = targetsArray;
        }
        if (bl) {
            if (this.nodeType == 18) {
                n = this.parentSwitchLinkChildIndex;
                setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n);
                setLiveState.parentSwitchLink = this;
            } else if (this.nodeType == 22) {
                n = this.parentSwitchLinkChildIndex;
                setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n);
                setLiveState.parentSwitchLink = this;
            } else {
                setLiveState.parentSwitchLink = this.parentSwitchLink;
                if (this.parentSwitchLink != null) {
                    n = this.parentSwitchLinkChildIndex;
                    setLiveState.childSwitchLinks = (ArrayList)this.parentSwitchLink.childrenSwitchLinks.get(n);
                }
            }
            if (targetsInterface != null) {
                setLiveState.switchStates = targetsInterface.getTargetsData(1, this.parentSwitchLinkChildIndex);
            } else {
                setLiveState.switchStates = new ArrayList(1);
                setLiveState.switchStates.add(new SwitchState(false));
            }
        }
        return targetsInterface;
    }

    void updateSwitchStates(SetLiveState setLiveState, TargetsInterface targetsInterface, boolean bl) {
        if (targetsInterface != null) {
            if (bl) {
                CachedTargets[] cachedTargetsArray = null;
                cachedTargetsArray = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    CachedTargets cachedTargets;
                    cachedTargetsArray[0] = setLiveState.switchTargets[0] != null ? ((cachedTargets = targetsInterface.getCachedTargets(1, 0, this.parentSwitchLinkChildIndex)) != null ? setLiveState.switchTargets[0].snapShotAdd(cachedTargets) : setLiveState.switchTargets[0].snapShotInit()) : null;
                } else {
                    int n = 0;
                    while (n < setLiveState.keys.length) {
                        CachedTargets cachedTargets;
                        cachedTargetsArray[n] = setLiveState.switchTargets[n] != null ? ((cachedTargets = targetsInterface.getCachedTargets(1, n, this.parentSwitchLinkChildIndex)) != null ? setLiveState.switchTargets[n].snapShotAdd(cachedTargets) : setLiveState.switchTargets[n].snapShotInit()) : null;
                        ++n;
                    }
                }
                targetsInterface.resetCachedTargets(1, cachedTargetsArray, this.parentSwitchLinkChildIndex);
                if (targetsInterface instanceof SwitchRetained) {
                    ((SwitchRetained)targetsInterface).traverseSwitchParent();
                } else if (targetsInterface instanceof SharedGroupRetained) {
                    ((SharedGroupRetained)targetsInterface).traverseSwitchParent();
                }
            } else {
                CachedTargets[] cachedTargetsArray = new CachedTargets[this.localToVworld.length];
                if (!this.inSharedGroup) {
                    if (setLiveState.switchTargets[0] != null) {
                        CachedTargets cachedTargets = targetsInterface.getCachedTargets(1, 0, this.parentSwitchLinkChildIndex);
                        if (cachedTargets != null) {
                            cachedTargetsArray[0] = setLiveState.switchTargets[0].snapShotRemove(cachedTargets);
                        }
                    } else {
                        cachedTargetsArray[0] = null;
                    }
                } else {
                    int n = 0;
                    while (n < setLiveState.keys.length) {
                        if (setLiveState.switchTargets[n] != null) {
                            CachedTargets cachedTargets = targetsInterface.getCachedTargets(1, n, this.parentSwitchLinkChildIndex);
                            if (cachedTargets != null) {
                                cachedTargetsArray[n] = setLiveState.switchTargets[n].snapShotRemove(cachedTargets);
                            }
                        } else {
                            cachedTargetsArray[n] = null;
                        }
                        ++n;
                    }
                }
                targetsInterface.resetCachedTargets(1, cachedTargetsArray, this.parentSwitchLinkChildIndex);
            }
        }
    }

    void appendChildrenData() {
    }

    void insertChildrenData(int n) {
    }

    void removeChildrenData(int n) {
    }

    TargetsInterface getClosestTargetsInterface(int n) {
        return n == 0 ? (TargetsInterface)((Object)this.parentTransformLink) : (TargetsInterface)((Object)this.parentSwitchLink);
    }

    synchronized void updateLocalToVworld() {
        int n = this.children.size() - 1;
        while (n >= 0) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
            if (nodeRetained != null) {
                nodeRetained.updateLocalToVworld();
            }
            --n;
        }
    }

    void setNodeData(SetLiveState setLiveState) {
        super.setNodeData(setLiveState);
        this.orderedPaths = setLiveState.orderedPaths;
    }

    void removeNodeData(SetLiveState setLiveState) {
        this.orderedPaths = !this.inSharedGroup || setLiveState.keys.length == this.localToVworld.length ? null : setLiveState.orderedPaths;
        super.removeNodeData(setLiveState);
    }

    void setLive(SetLiveState setLiveState) {
        this.doSetLive(setLiveState);
        super.markAsLive();
    }

    void childDoSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState) {
        if (nodeRetained != null) {
            nodeRetained.setLive(setLiveState);
        }
    }

    void childCheckSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState, NodeRetained nodeRetained2) {
        nodeRetained.setLive(setLiveState);
    }

    void doSetLive(SetLiveState setLiveState) {
        BoundingSphere boundingSphere = new BoundingSphere();
        super.doSetLive(setLiveState);
        this.locale = setLiveState.locale;
        this.inViewSpecificGroup = setLiveState.inViewSpecificGroup;
        int n = this.children.size();
        ArrayList arrayList = setLiveState.lights;
        ArrayList arrayList2 = setLiveState.fogs;
        ArrayList arrayList3 = setLiveState.altAppearances;
        ArrayList arrayList4 = setLiveState.modelClips;
        boolean[] blArray = (boolean[])setLiveState.pickable.clone();
        boolean[] blArray2 = (boolean[])setLiveState.collidable.clone();
        boolean[] blArray3 = new boolean[blArray.length];
        boolean[] blArray4 = new boolean[blArray2.length];
        ArrayList arrayList5 = setLiveState.branchGroupPaths;
        this.setScopingInfo(setLiveState);
        if (!(this instanceof ViewSpecificGroupRetained)) {
            this.viewLists = setLiveState.viewLists;
        }
        int n2 = 0;
        while (n2 < n) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(n2);
            System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
            System.arraycopy(blArray2, 0, blArray4, 0, blArray2.length);
            setLiveState.pickable = blArray3;
            setLiveState.collidable = blArray4;
            setLiveState.parentBranchGroupPaths = this.branchGroupPaths;
            setLiveState.branchGroupPaths = (ArrayList)arrayList5.clone();
            setLiveState.inViewSpecificGroup = this.inViewSpecificGroup;
            this.childDoSetLive(nodeRetained, n2, setLiveState);
            ++n2;
        }
        if (this.collisionTarget) {
            this.processCollisionTarget(setLiveState);
        }
        setLiveState.lights = arrayList;
        setLiveState.fogs = arrayList2;
        setLiveState.altAppearances = arrayList3;
        setLiveState.modelClips = arrayList4;
    }

    void setScopingInfo(SetLiveState setLiveState) {
        int n;
        int n2;
        ArrayList arrayList;
        ArrayList arrayList2;
        int n3;
        int n4;
        if (this.allocatedLights) {
            if (setLiveState.lights != null) {
                if (this.inSharedGroup) {
                    n4 = 0;
                    while (n4 < setLiveState.keys.length) {
                        n3 = setLiveState.keys[n4].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        arrayList2 = (ArrayList)this.lights.get(n3);
                        arrayList = (ArrayList)setLiveState.lights.get(n4);
                        if (arrayList != null) {
                            n2 = arrayList.size();
                            n = 0;
                            while (n < n2) {
                                arrayList2.add(arrayList.get(n));
                                ++n;
                            }
                        }
                        ++n4;
                    }
                } else {
                    arrayList2 = (ArrayList)this.lights.get(0);
                    arrayList = (ArrayList)setLiveState.lights.get(0);
                    n2 = arrayList.size();
                    n4 = 0;
                    while (n4 < n2) {
                        arrayList2.add(arrayList.get(n4));
                        ++n4;
                    }
                }
            }
            setLiveState.lights = this.lights;
        } else {
            this.lights = setLiveState.lights;
        }
        if (this.allocatedFogs) {
            if (setLiveState.fogs != null) {
                if (this.inSharedGroup) {
                    n4 = 0;
                    while (n4 < setLiveState.keys.length) {
                        n3 = setLiveState.keys[n4].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        arrayList2 = (ArrayList)this.fogs.get(n3);
                        arrayList = (ArrayList)setLiveState.fogs.get(n4);
                        if (arrayList != null) {
                            n2 = arrayList.size();
                            n = 0;
                            while (n < n2) {
                                arrayList2.add(arrayList.get(n));
                                ++n;
                            }
                        }
                        ++n4;
                    }
                } else {
                    arrayList2 = (ArrayList)this.fogs.get(0);
                    arrayList = (ArrayList)setLiveState.fogs.get(0);
                    n2 = arrayList.size();
                    n4 = 0;
                    while (n4 < n2) {
                        arrayList2.add(arrayList.get(n4));
                        ++n4;
                    }
                }
            }
            setLiveState.fogs = this.fogs;
        } else {
            this.fogs = setLiveState.fogs;
        }
        if (this.allocatedMclips) {
            if (setLiveState.modelClips != null) {
                if (this.inSharedGroup) {
                    n4 = 0;
                    while (n4 < setLiveState.keys.length) {
                        n3 = setLiveState.keys[n4].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        arrayList2 = (ArrayList)this.modelClips.get(n3);
                        arrayList = (ArrayList)setLiveState.modelClips.get(n4);
                        if (arrayList != null) {
                            n2 = arrayList.size();
                            n = 0;
                            while (n < n2) {
                                arrayList2.add(arrayList.get(n));
                                ++n;
                            }
                        }
                        ++n4;
                    }
                } else {
                    arrayList2 = (ArrayList)this.modelClips.get(0);
                    arrayList = (ArrayList)setLiveState.modelClips.get(0);
                    n2 = arrayList.size();
                    n4 = 0;
                    while (n4 < n2) {
                        arrayList2.add(arrayList.get(n4));
                        ++n4;
                    }
                }
            }
            setLiveState.modelClips = this.modelClips;
        } else {
            this.modelClips = setLiveState.modelClips;
        }
        if (this.allocatedAltApps) {
            if (setLiveState.altAppearances != null) {
                if (this.inSharedGroup) {
                    n4 = 0;
                    while (n4 < setLiveState.keys.length) {
                        n3 = setLiveState.keys[n4].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                        arrayList2 = (ArrayList)this.altAppearances.get(n3);
                        arrayList = (ArrayList)setLiveState.altAppearances.get(n4);
                        if (arrayList != null) {
                            n2 = arrayList.size();
                            n = 0;
                            while (n < n2) {
                                arrayList2.add(arrayList.get(n));
                                ++n;
                            }
                        }
                        ++n4;
                    }
                } else {
                    arrayList2 = (ArrayList)this.altAppearances.get(0);
                    arrayList = (ArrayList)setLiveState.altAppearances.get(0);
                    n2 = arrayList.size();
                    n4 = 0;
                    while (n4 < n2) {
                        arrayList2.add(arrayList.get(n4));
                        ++n4;
                    }
                }
            }
            setLiveState.altAppearances = this.altAppearances;
        } else {
            this.altAppearances = setLiveState.altAppearances;
        }
    }

    void processCollisionTarget(SetLiveState setLiveState) {
        Bounds bounds;
        if (this.mirrorGroup == null) {
            this.mirrorGroup = new ArrayList();
        }
        Bounds bounds2 = bounds = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                GroupRetained groupRetained = new GroupRetained();
                groupRetained.key = setLiveState.keys[n];
                groupRetained.localToVworld = new Transform3D[1][];
                groupRetained.localToVworldIndex = new int[1][];
                int n2 = setLiveState.keys[n].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 < 0) {
                    System.out.println("GroupRetained : Can't find hashKey");
                }
                groupRetained.localToVworld[0] = this.localToVworld[n2];
                groupRetained.localToVworldIndex[0] = this.localToVworldIndex[n2];
                groupRetained.collisionVwcBounds = new BoundingBox();
                groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld(0));
                groupRetained.sourceNode = this;
                groupRetained.locale = this.locale;
                this.mirrorGroup.add(groupRetained);
                if (setLiveState.transformTargets != null && setLiveState.transformTargets[n] != null) {
                    setLiveState.transformTargets[n].addNode(groupRetained, 6);
                }
                setLiveState.nodeList.add(groupRetained);
                ++n;
            }
        } else {
            GroupRetained groupRetained = new GroupRetained();
            groupRetained.localToVworld = new Transform3D[1][];
            groupRetained.localToVworldIndex = new int[1][];
            groupRetained.localToVworld[0] = this.localToVworld[0];
            groupRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            groupRetained.collisionVwcBounds = new BoundingBox();
            groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld(0));
            groupRetained.sourceNode = this;
            groupRetained.locale = this.locale;
            this.mirrorGroup.add(groupRetained);
            if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                setLiveState.transformTargets[0].addNode(groupRetained, 6);
            }
            setLiveState.nodeList.add(groupRetained);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(bounds);
                }
                --n;
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            BoundingSphere boundingSphere = new BoundingSphere();
            boundingSphere.setRadius(-1.0);
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(boundingSphere);
                }
                --n;
            }
            return boundingSphere;
        }
        return super.getBounds();
    }

    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    boolean isStaticChildren() {
        return !this.source.getCapability(12) && !this.source.getCapability(13);
    }

    boolean isStatic() {
        return super.isStatic() && this.isStaticChildren();
    }

    void setCompiled() {
        super.setCompiled();
        int n = this.children.size() - 1;
        while (n >= 0) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
            if (sceneGraphObjectRetained != null) {
                sceneGraphObjectRetained.setCompiled();
            }
            --n;
        }
    }

    void traverse(boolean bl, int n) {
        if (!bl) {
            super.traverse(true, n);
            if (this.source.getCapability(12)) {
                System.out.print(" (r)");
            } else if (this.isStatic()) {
                System.out.print(" (s)");
            } else if (this.source.getCapability(13)) {
                System.out.print(" (w)");
            }
        }
        ++n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n2);
            if (sceneGraphObjectRetained != null) {
                sceneGraphObjectRetained.traverse(false, n);
            }
            ++n2;
        }
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        this.mergeFlag = 1;
        if (!this.isStatic()) {
            compileState.keepTG = true;
            this.mergeFlag = 0;
        }
        if (this.isRoot || this.usedInScoping() || this.parent instanceof SwitchRetained) {
            this.mergeFlag = 0;
        }
        this.compiledChildrenList = new ArrayList(5);
        int n = 0;
        while (n < this.children.size()) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
            if (sceneGraphObjectRetained != null) {
                sceneGraphObjectRetained.compile(compileState);
            }
            ++n;
        }
    }

    void merge(CompileState compileState) {
        GroupRetained groupRetained = null;
        if (this.mergeFlag != 2) {
            if (this.mergeFlag == 0) {
                super.merge(compileState);
                groupRetained = compileState.parentGroup;
                compileState.parentGroup = this;
            }
            int n = 0;
            while (n < this.children.size()) {
                SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
                if (sceneGraphObjectRetained != null) {
                    sceneGraphObjectRetained.merge(compileState);
                }
                ++n;
            }
            if (compileState.parentGroup == this) {
                this.children = this.compiledChildrenList;
                compileState.doShapeMerge();
                this.compiledChildrenList = null;
                compileState.parentGroup = groupRetained;
            } else {
                this.children.clear();
            }
            this.mergeFlag = 2;
        } else if (compileState.parentGroup != null) {
            compileState.parentGroup.compiledChildrenList.add(this);
            this.parent = compileState.parentGroup;
        }
    }

    void clearLive(SetLiveState setLiveState) {
        int n;
        int n2;
        int n3;
        ArrayList arrayList;
        int n4;
        Cloneable cloneable;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        this.isInClearLive = true;
        HashKey[] hashKeyArray = this.localToVworldKeys;
        super.clearLive(setLiveState);
        int n5 = this.children.size();
        if (!(this instanceof ViewSpecificGroupRetained)) {
            this.viewLists = setLiveState.viewLists;
        }
        ArrayList arrayList2 = setLiveState.lights;
        if (this.allocatedLights) {
            setLiveState.lights = this.lights;
        }
        ArrayList arrayList3 = setLiveState.fogs;
        if (this.allocatedFogs) {
            setLiveState.fogs = this.fogs;
        }
        ArrayList arrayList4 = setLiveState.modelClips;
        if (this.allocatedMclips) {
            setLiveState.modelClips = this.modelClips;
        }
        ArrayList arrayList5 = setLiveState.altAppearances;
        if (this.allocatedAltApps) {
            setLiveState.altAppearances = this.altAppearances;
        }
        int n6 = n5 - 1;
        while (n6 >= 0) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(n6);
            if (this instanceof OrderedGroupRetained) {
                cloneable = (OrderedGroupRetained)this;
                if (this.refCount + 1 == setLiveState.refCount) {
                    setLiveState.ogList.add(this);
                    setLiveState.ogChildIdList.add(new Integer(n6));
                }
                setLiveState.orderedPaths = (ArrayList)((OrderedGroupRetained)cloneable).childrenOrderedPaths.get(n6);
            }
            if (nodeRetained != null) {
                nodeRetained.clearLive(setLiveState);
            }
            --n6;
        }
        if (arrayList2 != null && this.allocatedLights) {
            if (this.inSharedGroup) {
                n6 = 0;
                while (n6 < setLiveState.keys.length) {
                    n4 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    cloneable = (ArrayList)arrayList2.get(n4);
                    arrayList = (ArrayList)this.lights.get(n4);
                    if (cloneable != null) {
                        n3 = ((ArrayList)cloneable).size();
                        n2 = 0;
                        while (n2 < n3) {
                            arrayList.remove(((ArrayList)cloneable).get(n2));
                            ++n2;
                        }
                    }
                    ++n6;
                }
            } else {
                cloneable = (ArrayList)arrayList2.get(0);
                arrayList = (ArrayList)this.lights.get(0);
                n3 = ((ArrayList)cloneable).size();
                n = 0;
                while (n < n3) {
                    arrayList.remove(((ArrayList)cloneable).get(n));
                    ++n;
                }
            }
        }
        if (arrayList3 != null && this.allocatedFogs) {
            if (this.inSharedGroup) {
                n6 = 0;
                while (n6 < setLiveState.keys.length) {
                    n4 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    cloneable = (ArrayList)arrayList3.get(n4);
                    arrayList = (ArrayList)this.fogs.get(n4);
                    if (cloneable != null) {
                        n3 = ((ArrayList)cloneable).size();
                        n2 = 0;
                        while (n2 < n3) {
                            arrayList.remove(((ArrayList)cloneable).get(n2));
                            ++n2;
                        }
                    }
                    ++n6;
                }
            } else {
                cloneable = (ArrayList)arrayList3.get(0);
                n3 = ((ArrayList)cloneable).size();
                int n7 = 0;
                while (n7 < n3) {
                    this.fogs.remove(((ArrayList)cloneable).get(n7));
                    ++n7;
                }
            }
        }
        if (arrayList4 != null && this.allocatedMclips) {
            if (this.inSharedGroup) {
                n6 = 0;
                while (n6 < setLiveState.keys.length) {
                    n4 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    cloneable = (ArrayList)arrayList4.get(n4);
                    ArrayList arrayList6 = (ArrayList)this.modelClips.get(n4);
                    if (cloneable != null) {
                        n3 = ((ArrayList)cloneable).size();
                        n2 = 0;
                        while (n2 < n3) {
                            arrayList6.remove(((ArrayList)cloneable).get(n2));
                            ++n2;
                        }
                    }
                    ++n6;
                }
            } else {
                cloneable = (ArrayList)arrayList4.get(0);
                n3 = ((ArrayList)cloneable).size();
                int n8 = 0;
                while (n8 < n3) {
                    this.modelClips.remove(((ArrayList)cloneable).get(n8));
                    ++n8;
                }
            }
        }
        if (arrayList5 != null && this.allocatedAltApps) {
            if (this.inSharedGroup) {
                n6 = 0;
                while (n6 < setLiveState.keys.length) {
                    n4 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    cloneable = (ArrayList)arrayList5.get(n4);
                    ArrayList arrayList7 = (ArrayList)this.altAppearances.get(n4);
                    if (cloneable != null) {
                        n3 = ((ArrayList)cloneable).size();
                        n2 = 0;
                        while (n2 < n3) {
                            arrayList7.remove(((ArrayList)cloneable).get(n2));
                            ++n2;
                        }
                    }
                    ++n6;
                }
            } else {
                cloneable = (ArrayList)arrayList5.get(0);
                n3 = ((ArrayList)cloneable).size();
                int n9 = 0;
                while (n9 < n3) {
                    this.altAppearances.remove(((ArrayList)cloneable).get(n9));
                    ++n9;
                }
            }
        }
        if (this.collisionTarget) {
            if (this.inSharedGroup) {
                n6 = setLiveState.keys.length - 1;
                while (n6 >= 0) {
                    HashKey hashKey = setLiveState.keys[n6];
                    n = this.mirrorGroup.size() - 1;
                    while (n >= 0) {
                        cloneable = (GroupRetained)this.mirrorGroup.get(n);
                        if (((GroupRetained)cloneable).key.equals((Object)hashKey)) {
                            setLiveState.nodeList.add(this.mirrorGroup.remove(n));
                            if (setLiveState.transformTargets == null || setLiveState.transformTargets[n] == null) break;
                            setLiveState.transformTargets[n].addNode((NnuId)((Object)cloneable), 6);
                            break;
                        }
                        --n;
                    }
                    --n6;
                }
            } else {
                cloneable = (GroupRetained)this.mirrorGroup.get(0);
                if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
                    setLiveState.transformTargets[0].addNode((NnuId)((Object)cloneable), 6);
                }
                setLiveState.nodeList.add(this.mirrorGroup.remove(0));
            }
        }
        setLiveState.lights = arrayList2;
        setLiveState.modelClips = arrayList4;
        setLiveState.fogs = arrayList3;
        setLiveState.altAppearances = arrayList5;
        this.isInClearLive = false;
    }

    public BoundingBox computeBoundingHull() {
        return this.collisionVwcBounds;
    }

    public boolean isEnable() {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    public boolean isEnable(int n) {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    static boolean isNodeSwitchOn(NodeRetained nodeRetained, HashKey hashKey) {
        NodeRetained nodeRetained2 = null;
        if (hashKey != null) {
            hashKey = new HashKey(hashKey);
        }
        Object object = nodeRetained.universe.sceneGraphLock;
        synchronized (object) {
            do {
                if (nodeRetained instanceof SwitchRetained && nodeRetained2 != null && !GroupRetained.validSwitchChild((SwitchRetained)nodeRetained, nodeRetained2)) {
                    boolean bl = false;
                    return bl;
                }
                nodeRetained2 = nodeRetained;
                if (nodeRetained instanceof SharedGroupRetained) {
                    String string = hashKey.getLastNodeId();
                    Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                    int n = vector.size() - 1;
                    while (n >= 0) {
                        NodeRetained nodeRetained3 = (NodeRetained)vector.get(n);
                        if (nodeRetained3.nodeId.equals(string)) {
                            nodeRetained = nodeRetained3;
                            break;
                        }
                        --n;
                    }
                    if (nodeRetained != nodeRetained2) continue;
                    boolean bl = false;
                    return bl;
                }
                nodeRetained = nodeRetained.parent;
            } while (nodeRetained != null);
        }
        return true;
    }

    static boolean validSwitchChild(SwitchRetained switchRetained, NodeRetained nodeRetained) {
        int n = switchRetained.whichChild;
        if (n == -1) {
            return false;
        }
        if (n == -2) {
            return true;
        }
        ArrayList arrayList = switchRetained.children;
        if (n >= 0) {
            return arrayList.get(n) == nodeRetained;
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            if (switchRetained.childMask.get(n2) && arrayList.get(n2) == nodeRetained) {
                return true;
            }
            --n2;
        }
        return false;
    }

    void createMirrorGroup() {
        Bounds bounds;
        this.mirrorGroup = new ArrayList();
        Bounds bounds2 = bounds = this.collisionBound != null ? this.collisionBound : this.getEffectiveBounds();
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                GroupRetained groupRetained = new GroupRetained();
                groupRetained.key = this.localToVworldKeys[n];
                groupRetained.localToVworld = new Transform3D[1][];
                groupRetained.localToVworldIndex = new int[1][];
                groupRetained.localToVworld[0] = this.localToVworld[n];
                groupRetained.localToVworldIndex[0] = this.localToVworldIndex[n];
                groupRetained.collisionVwcBounds = new BoundingBox();
                groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld());
                groupRetained.sourceNode = this;
                groupRetained.locale = this.locale;
                this.mirrorGroup.add(groupRetained);
                ++n;
            }
        } else {
            GroupRetained groupRetained = new GroupRetained();
            groupRetained.localToVworld = new Transform3D[1][];
            groupRetained.localToVworldIndex = new int[1][];
            groupRetained.localToVworld[0] = this.localToVworld[0];
            groupRetained.localToVworldIndex[0] = this.localToVworldIndex[0];
            groupRetained.collisionVwcBounds = new BoundingBox();
            groupRetained.collisionVwcBounds.transform(bounds, groupRetained.getCurrentLocalToVworld());
            groupRetained.sourceNode = this;
            groupRetained.locale = this.locale;
            this.mirrorGroup.add(groupRetained);
        }
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            super.setBoundsAutoCompute(bl);
            if (!bl) {
                this.localBounds = this.getEffectiveBounds();
            }
            if (this.source.isLive() && this.collisionBound == null && bl && this.mirrorGroup != null) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.type = 34;
                j3dMessage.threads = 8256;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = this;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute && this.collisionBound == null && this.mirrorGroup != null) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8256;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    int[] processViewSpecificInfo(int n, HashKey hashKey, View view, ArrayList arrayList, int[] nArray, ArrayList arrayList2) {
        int n2 = this.children.size();
        if (this.source.isLive()) {
            int n3 = 0;
            while (n3 < n2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(n3);
                if (nodeRetained instanceof LeafRetained) {
                    if (nodeRetained instanceof LinkRetained) {
                        int n4 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        nArray = linkRetained.sharedGroup.processViewSpecificInfo(n, hashKey.append("+").append(linkRetained.nodeId), view, arrayList, nArray, arrayList2);
                        hashKey.count = n4;
                    } else {
                        ((LeafRetained)nodeRetained).getMirrorObjects(arrayList2, hashKey);
                    }
                } else {
                    nArray = nodeRetained.processViewSpecificInfo(n, hashKey, view, arrayList, nArray, arrayList2);
                }
                ++n3;
            }
        }
        return nArray;
    }

    void findSwitchInfo(SetLiveState setLiveState, NodeRetained nodeRetained, NodeRetained nodeRetained2, NodeRetained nodeRetained3) {
        this.parentSwitchLinkChildIndex = -1;
        if (!this.inSharedGroup) {
            NodeRetained nodeRetained4 = nodeRetained3 == null ? nodeRetained2 : nodeRetained3;
            NodeRetained nodeRetained5 = nodeRetained;
            while (nodeRetained5 != null) {
                if (nodeRetained5 instanceof SwitchRetained) {
                    setLiveState.switchLevels[0] = setLiveState.switchLevels[0] + 1;
                    if (setLiveState.closestSwitchParents[0] == null) {
                        setLiveState.closestSwitchParents[0] = (SwitchRetained)nodeRetained5;
                        ++((SwitchRetained)nodeRetained5).switchIndexCount;
                    }
                    if (this.parentSwitchLinkChildIndex == -1) {
                        this.parentSwitchLinkChildIndex = ((GroupRetained)nodeRetained5).children.indexOf(nodeRetained4);
                    }
                } else if (nodeRetained5 instanceof SharedGroupRetained && this.parentSwitchLinkChildIndex == -1) {
                    this.parentSwitchLinkChildIndex = ((GroupRetained)nodeRetained5).children.indexOf(nodeRetained4);
                }
                nodeRetained4 = nodeRetained5;
                nodeRetained5 = nodeRetained4.parent;
            }
        } else {
            setLiveState.switchLevels = new int[this.localToVworldKeys.length];
            setLiveState.closestSwitchParents = new SwitchRetained[this.localToVworldKeys.length];
            setLiveState.closestSwitchIndices = new int[this.localToVworldKeys.length];
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                setLiveState.switchLevels[n] = -1;
                setLiveState.closestSwitchParents[n] = null;
                setLiveState.closestSwitchIndices[n] = -1;
                ++n;
            }
            n = 0;
            while (n < this.localToVworldKeys.length) {
                NodeRetained nodeRetained6 = nodeRetained3 == null ? nodeRetained2 : nodeRetained3;
                NodeRetained nodeRetained7 = nodeRetained;
                HashKey hashKey = new HashKey(this.localToVworldKeys[n]);
                while (nodeRetained7 != null) {
                    if (nodeRetained7 instanceof SwitchRetained) {
                        int n2 = n;
                        setLiveState.switchLevels[n2] = setLiveState.switchLevels[n2] + 1;
                        if (setLiveState.closestSwitchParents[n] == null) {
                            setLiveState.closestSwitchParents[n] = (SwitchRetained)nodeRetained7;
                            ++((SwitchRetained)nodeRetained7).switchIndexCount;
                        }
                        if (this.parentSwitchLinkChildIndex == -1) {
                            this.parentSwitchLinkChildIndex = ((GroupRetained)nodeRetained7).children.indexOf(nodeRetained6);
                        }
                    } else if (nodeRetained7 instanceof SharedGroupRetained) {
                        String string = hashKey.getLastNodeId();
                        Vector vector = ((SharedGroupRetained)nodeRetained7).parents;
                        if (this.parentSwitchLinkChildIndex == -1) {
                            this.parentSwitchLinkChildIndex = ((GroupRetained)nodeRetained7).children.indexOf(nodeRetained6);
                        }
                        int n3 = 0;
                        while (n3 < vector.size()) {
                            NodeRetained nodeRetained8 = (NodeRetained)vector.get(n3);
                            if (nodeRetained8.nodeId.equals(string)) {
                                nodeRetained7 = nodeRetained8;
                                break;
                            }
                            ++n3;
                        }
                    }
                    nodeRetained6 = nodeRetained7;
                    nodeRetained7 = nodeRetained6.parent;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void gatherBlUsers(ArrayList arrayList, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            ArrayList arrayList2;
            ArrayList arrayList3 = arrayList2 = ((BoundingLeafRetained)objectArray[n]).users;
            synchronized (arrayList3) {
                arrayList.addAll(arrayList2);
            }
            ++n;
        }
    }

    void searchGeometryAtoms(UnorderList unorderList) {
        int n = this.children.size() - 1;
        while (n >= 0) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(n);
            nodeRetained.searchGeometryAtoms(unorderList);
            --n;
        }
    }
}

