/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.randvar.ErlangConvolutionGen;
import umontreal.iro.lecuyer.randvar.ErlangGen;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.Resource;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.ThreadProcessSimulator;
import umontreal.iro.lecuyer.stat.Tally;

public class BankProc {
    ProcessSimulator sim = new ThreadProcessSimulator();
    double minute = 0.016666666666666666;
    int nbServed;
    double meanDelay;
    SimProcess nextCust;
    Resource tellers = new Resource(this.sim, 0, "The tellers");
    RandomStream streamArr = new MRG32k3a();
    ErlangGen genServ = new ErlangConvolutionGen((RandomStream)new MRG32k3a(), 2, 1.0 / this.minute);
    RandomStream streamTeller = new MRG32k3a();
    RandomStream streamBalk = new MRG32k3a();
    Tally statServed = new Tally("Nb. served per day");
    Tally avWait = new Tally("Average wait per day (hours)");

    public void simulOneDay() {
        this.sim.init();
        new OneDay(this.sim).schedule(9.75);
        this.sim.start();
        this.statServed.add(this.nbServed);
        this.avWait.add(this.tellers.waitList().statSize().sum());
    }

    public void simulateDays(int numDays) {
        this.tellers.waitList().setStatCollecting(true);
        for (int i = 1; i <= numDays; ++i) {
            this.simulOneDay();
        }
        System.out.println(this.statServed.report());
        System.out.println(this.avWait.report());
    }

    public static void main(String[] args) {
        new BankProc().simulateDays(100);
    }

    class Customer
    extends SimProcess {
        public Customer(ProcessSimulator sim) {
            super(sim);
        }

        public void actions() {
            BankProc.this.nextCust = new Customer(this.sim);
            BankProc.this.nextCust.schedule(ExponentialGen.nextDouble(BankProc.this.streamArr, 1.0 / BankProc.this.meanDelay));
            if (!this.balk()) {
                BankProc.this.tellers.request(1);
                this.delay(BankProc.this.genServ.nextDouble());
                BankProc.this.tellers.release(1);
                ++BankProc.this.nbServed;
            }
        }

        private boolean balk() {
            int n = BankProc.this.tellers.waitList().size();
            return n > 9 || n > 5 && 5.0 * BankProc.this.streamBalk.nextDouble() < (double)(n - 5);
        }
    }

    class OneDay
    extends SimProcess {
        public OneDay(ProcessSimulator sim) {
            super(sim);
        }

        public void actions() {
            BankProc.this.nbServed = 0;
            BankProc.this.tellers.setCapacity(0);
            BankProc.this.tellers.waitList().initStat();
            BankProc.this.meanDelay = 2.0 * BankProc.this.minute;
            BankProc.this.nextCust = new Customer(this.sim);
            BankProc.this.nextCust.schedule(ExponentialGen.nextDouble(BankProc.this.streamArr, 1.0 / BankProc.this.meanDelay));
            this.delay(15.0 * BankProc.this.minute);
            double u = BankProc.this.streamTeller.nextDouble();
            int nbTellers = u >= 0.2 ? 3 : (u < 0.05 ? 1 : 2);
            BankProc.this.tellers.setCapacity(nbTellers);
            this.delay(1.0);
            BankProc.this.nextCust.reschedule(BankProc.this.nextCust.getDelay() / 2.0);
            BankProc.this.meanDelay = BankProc.this.minute;
            this.delay(3.0);
            BankProc.this.nextCust.reschedule(BankProc.this.nextCust.getDelay() * 2.0);
            BankProc.this.meanDelay = 2.0 * BankProc.this.minute;
            this.delay(1.0);
            BankProc.this.nextCust.cancel();
        }
    }
}

