/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.filters;

import nl.tudelft.simulation.language.filters.AbstractFilter;

public class MaxDiffFilter
extends AbstractFilter {
    private double acceptedDifferencePercentage = Double.NaN;
    private double lastReceivedValue = -1.7976931348623157E308;

    public MaxDiffFilter(double acceptedDifferencePercentage) {
        if (acceptedDifferencePercentage <= 0.0 && acceptedDifferencePercentage > 1.0) {
            throw new IllegalArgumentException("percentage should be between [0.0,1.0]");
        }
        this.acceptedDifferencePercentage = acceptedDifferencePercentage;
    }

    public boolean filter(Object entry) {
        if (!(entry instanceof double[]) || ((double[])entry).length != 2) {
            throw new IllegalArgumentException("entry should be instance of double[2] representing x,y");
        }
        double[] value = (double[])entry;
        if (Math.abs(value[1] - this.lastReceivedValue) >= this.lastReceivedValue * this.acceptedDifferencePercentage) {
            this.lastReceivedValue = value[1];
            return true;
        }
        this.lastReceivedValue = value[1];
        return false;
    }

    public String getCriterium() {
        return "accepts entries if their value>" + this.acceptedDifferencePercentage + "% of the last received Value";
    }
}

