/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantClass;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;
import nl.tudelft.simulation.language.primitives.Primitive;

public class ANEWARRAY
extends VoidOperation {
    public static final int OP = 189;
    private int index = -1;

    public ANEWARRAY(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        int length = Primitive.toInteger((Object)stack.pop());
        Class clazz = null;
        try {
            clazz = ((ConstantClass)constantPool[this.index]).getValue().getClassValue();
        }
        catch (ClassNotFoundException exception) {
            throw new InterpreterException(exception);
        }
        Object array = Array.newInstance(clazz, length);
        stack.push(array);
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 189;
    }
}

