/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.containers.Triple;
import umcg.genetica.io.fasta.ReferenceGenomeFasta;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.util.WriteExtendedFastaOfInterestRegion;

public class WriteFastaOfInterestRegion {
    public static void main(String[] args) {
        String referenceFasta = args[0];
        String fileWithPositions = args[1];
        String outputFile = args[2];
        boolean modeBed = false;
        if (args.length > 3 && args[3].equals("bed")) {
            modeBed = true;
        }
        ReferenceGenomeFasta refGen = null;
        HashMap<String, HashMap<String, Triple<String, Integer, Integer>>> interestStrings = null;
        try {
            if (!modeBed) {
                System.out.println("Reading reference GTF.");
                interestStrings = WriteFastaOfInterestRegion.readFileWithPositions(fileWithPositions);
            } else {
                System.out.println("Reading reference Bed.");
                interestStrings = WriteFastaOfInterestRegion.readBedFileWithPositions(fileWithPositions);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(WriteFastaOfInterestRegion.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            System.out.println("Reading reference FASTA.");
            refGen = new ReferenceGenomeFasta(new File(referenceFasta), ReferenceGenomeFasta.HUMAN_NORMAL_CHR);
        }
        catch (Exception ex) {
            Logger.getLogger(WriteFastaOfInterestRegion.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (refGen != null && interestStrings != null) {
            try {
                WriteFastaOfInterestRegion.writeFasta(refGen, interestStrings, outputFile);
            }
            catch (IOException ex) {
                Logger.getLogger(WriteFastaOfInterestRegion.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static HashMap<String, HashMap<String, Triple<String, Integer, Integer>>> readFileWithPositions(String fileWithPositions) throws IOException {
        String str;
        HashMap<String, HashMap<String, Triple<String, Integer, Integer>>> chromosomalProbeInformation = new HashMap<String, HashMap<String, Triple<String, Integer, Integer>>>();
        TextFile gffFileReader = new TextFile(fileWithPositions, false);
        int counter = 0;
        while ((str = gffFileReader.readLine()) != null) {
            String[] parts = str.split("\t");
            if (!chromosomalProbeInformation.containsKey(parts[0])) {
                chromosomalProbeInformation.put(parts[0], new HashMap());
            }
            int start = Integer.parseInt(parts[3]);
            int stop = Integer.parseInt(parts[4]);
            if (stop < start) {
                int tmp = stop;
                stop = start;
                start = tmp;
            }
            chromosomalProbeInformation.get(parts[0]).put(parts[8], new Triple<String, Integer, Integer>(parts[6], start, stop));
            ++counter;
        }
        System.out.println("Number of entries read in: " + counter);
        gffFileReader.close();
        return chromosomalProbeInformation;
    }

    private static HashMap<String, HashMap<String, Triple<String, Integer, Integer>>> readBedFileWithPositions(String fileWithPositions) throws IOException {
        String str;
        HashMap<String, HashMap<String, Triple<String, Integer, Integer>>> chromosomalProbeInformation = new HashMap<String, HashMap<String, Triple<String, Integer, Integer>>>();
        TextFile gffFileReader = new TextFile(fileWithPositions, false);
        int counter = 0;
        while ((str = gffFileReader.readLine()) != null) {
            String[] parts = str.split("\t");
            parts[0] = parts[0].replace("chr", "");
            if (!chromosomalProbeInformation.containsKey(parts[0])) {
                chromosomalProbeInformation.put(parts[0], new HashMap());
            }
            int start = Integer.parseInt(parts[1]);
            int stop = Integer.parseInt(parts[2]);
            if (stop < start) {
                int tmp = stop;
                stop = start;
                start = tmp;
            }
            chromosomalProbeInformation.get(parts[0]).put(parts[3], new Triple<String, Integer, Integer>(parts[5], start, stop));
            ++counter;
        }
        System.out.println("Number of entries read in: " + counter);
        gffFileReader.close();
        return chromosomalProbeInformation;
    }

    private static void writeFasta(ReferenceGenomeFasta refGen, HashMap<String, HashMap<String, Triple<String, Integer, Integer>>> interestStrings, String outputFile) throws IOException {
        TextFile writer = new TextFile(outputFile, true);
        for (Map.Entry<String, HashMap<String, Triple<String, Integer, Integer>>> probesPerChr : interestStrings.entrySet()) {
            for (Map.Entry<String, Triple<String, Integer, Integer>> probe : probesPerChr.getValue().entrySet()) {
                try {
                    StringBuilder s = new StringBuilder();
                    s.append(">").append(probe.getKey()).append("\n");
                    String probeSeq = refGen.getNucleotides(probesPerChr.getKey(), probe.getValue().getMiddle().intValue(), probe.getValue().getRight().intValue()).toString();
                    if (probe.getValue().getLeft().equals("+")) {
                        s.append(probeSeq).append("\n");
                        writer.write(s.toString());
                        continue;
                    }
                    if (probe.getValue().getLeft().equals("-")) {
                        s.append((CharSequence)WriteExtendedFastaOfInterestRegion.getFullComplement(WriteExtendedFastaOfInterestRegion.reverse(probeSeq))).append("\n");
                        writer.write(s.toString());
                        continue;
                    }
                    System.out.println("Error with the directionality of the probe: " + probe.getKey());
                }
                catch (Exception ex) {
                    Logger.getLogger(WriteFastaOfInterestRegion.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        writer.close();
    }
}

