/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiThreadedInPlaceQuickSort {
    private static final int N_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int FALLBACK = 2;
    private static Executor pool = Executors.newFixedThreadPool(N_THREADS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>> void quicksort(T[] input) {
        AtomicInteger count = new AtomicInteger(1);
        pool.execute(new QuicksortRunnable(input, 0, input.length - 1, count));
        try {
            AtomicInteger atomicInteger = count;
            synchronized (atomicInteger) {
                count.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class QuicksortRunnable<T extends Comparable<T>>
    implements Runnable {
        private final T[] values;
        private final int left;
        private final int right;
        private final AtomicInteger count;

        public QuicksortRunnable(T[] values, int left, int right, AtomicInteger count) {
            this.values = values;
            this.left = left;
            this.right = right;
            this.count = count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.quicksort(this.left, this.right);
            AtomicInteger atomicInteger = this.count;
            synchronized (atomicInteger) {
                if (this.count.getAndDecrement() == 1) {
                    this.count.notify();
                }
            }
        }

        private void quicksort(int pLeft, int pRight) {
            if (pLeft < pRight) {
                int storeIndex = this.partition(pLeft, pRight);
                if (this.count.get() >= 2 * N_THREADS) {
                    this.quicksort(pLeft, storeIndex - 1);
                    this.quicksort(storeIndex + 1, pRight);
                } else {
                    this.count.getAndAdd(2);
                    pool.execute(new QuicksortRunnable(this.values, pLeft, storeIndex - 1, this.count));
                    pool.execute(new QuicksortRunnable(this.values, storeIndex + 1, pRight, this.count));
                }
            }
        }

        private int partition(int pLeft, int pRight) {
            T pivotValue = this.values[pRight];
            int storeIndex = pLeft;
            for (int i = pLeft; i < pRight; ++i) {
                if (this.values[i].compareTo(pivotValue) >= 0) continue;
                this.swap(i, storeIndex);
                ++storeIndex;
            }
            this.swap(storeIndex, pRight);
            return storeIndex;
        }

        private void swap(int left, int right) {
            T temp = this.values[left];
            this.values[left] = this.values[right];
            this.values[right] = temp;
        }
    }
}

