/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.util;

import JSci.maths.ArrayMath;
import JSci.maths.statistics.NormalDistribution;
import cern.jet.stat.tdouble.Probability;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.util.RankArray;

public class CheckAssocationMultipleGeneProbes {
    public static void main(String[] args) {
        HashMap hashGenes = new HashMap();
        LinkedHashMap<String, Double> hashTValues = new LinkedHashMap<String, Double>();
        HashMap<String, Integer> hashCpGSites = new HashMap<String, Integer>();
        try {
            TextFile in = new TextFile("C:\\Users\\MarcJan\\Desktop\\pcas_450K.txt", false);
            String str = in.readLine();
            int i = -1;
            while ((str = in.readLine()) != null) {
                String[] data = str.split("\t");
                String CpG = data[0];
                if (data.length <= 6) continue;
                String gene = data[6];
                double t = Double.parseDouble(data[5]);
                hashTValues.put(CpG, t);
                hashCpGSites.put(CpG, ++i);
                if (!hashGenes.containsKey(gene)) {
                    ArrayList<String> CpGs = new ArrayList<String>();
                    CpGs.add(CpG);
                    hashGenes.put(gene, CpGs);
                    continue;
                }
                ((ArrayList)hashGenes.get(gene)).add(CpG);
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("Error:\t" + e.getMessage());
            e.printStackTrace();
        }
        double[] pValues = new double[hashTValues.size()];
        int c = 0;
        for (Map.Entry ent : hashTValues.entrySet()) {
            double t;
            pValues[c] = t = ((Double)ent.getValue()).doubleValue();
            ++c;
        }
        RankArray r = new RankArray();
        pValues = r.rank(pValues, false);
        for (int i = 0; i < pValues.length; ++i) {
            pValues[i] = (pValues[i] - 0.5) / (double)pValues.length;
        }
        NormalDistribution normDist = new NormalDistribution();
        for (Map.Entry ent : hashGenes.entrySet()) {
            String gene = (String)ent.getKey();
            ArrayList sites = (ArrayList)ent.getValue();
            double[] pSites = new double[sites.size()];
            double chiSquare = 0.0;
            double[] zSites = new double[sites.size()];
            for (int p = 0; p < sites.size(); ++p) {
                int cpgIndex = (Integer)hashCpGSites.get(sites.get(p));
                pSites[p] = pValues[cpgIndex];
                chiSquare += -2.0 * Math.log(pSites[p]);
                zSites[p] = Probability.normalInverse((double)pSites[p]);
            }
            double zOverall = ArrayMath.mass((double[])zSites) / Math.sqrt(sites.size());
            double minPValue = ArrayMath.min((double[])pSites);
            System.out.println(gene + "\t" + sites.size() + "\t" + minPValue + "\t" + zOverall);
        }
    }
}

