/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.methylation;

import java.util.ArrayList;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import umcg.genetica.math.matrix2.DoubleMatrixDataset;

public class CheckMatrixForValidBetaValues {
    public static void checkBetaValues(DoubleMatrixDataset<String, String> dataset, boolean replaceCheckedValuesOutOfRange) {
        for (int c = 0; c < dataset.columns(); ++c) {
            for (int r = 0; r < dataset.rows(); ++r) {
                if (dataset.getMatrix().get(r, c) >= 0.0 && dataset.getMatrix().get(r, c) <= 1.0) continue;
                dataset.getMatrix().set(r, c, Double.NaN);
            }
        }
    }

    public static ArrayList<String> checkMinAndMaxPerSample(umcg.genetica.math.matrix.DoubleMatrixDataset<String, String> dataset, boolean replaceCheckedValuesOutOfRange) {
        ArrayList<String> columnsToExclude = new ArrayList<String>();
        for (int c = 0; c < dataset.nrCols; ++c) {
            ArrayDoubleList tmp = new ArrayDoubleList();
            for (int r = 0; r < dataset.nrRows; ++r) {
                if (dataset.rawData[r][c] >= 0.0 && dataset.rawData[r][c] <= 1.0 || dataset.rawData[r][c] == -999.0) continue;
                if (replaceCheckedValuesOutOfRange) {
                    if (dataset.rawData[r][c] >= -0.01 && dataset.rawData[r][c] <= 1.0) {
                        dataset.rawData[r][c] = 0.0;
                        continue;
                    }
                    if (Math.abs(dataset.rawData[r][c] - -3.4 * Math.pow(10.0, 38.0)) < 1.0E-7) {
                        dataset.rawData[r][c] = -999.0;
                        continue;
                    }
                    if (dataset.rawData[r][c] == 9.0) {
                        dataset.rawData[r][c] = -999.0;
                        continue;
                    }
                    System.out.println("This shouldn't be reached");
                    System.out.println("This value reached it though: " + dataset.rawData[r][c]);
                    System.exit(-1);
                    continue;
                }
                tmp.add(dataset.rawData[r][c]);
            }
            if (tmp.size() == 0) continue;
            if (tmp.size() > 100) {
                System.out.println("Excluding due to min and max values probe:\t" + c + "\t" + (String)dataset.colObjects.get(c) + "\t" + tmp.size());
            } else {
                System.out.println("Excluding due to min and max values probe:\t" + c + "\t" + (String)dataset.colObjects.get(c) + "\t" + tmp.size() + "\t" + tmp.toString());
            }
            columnsToExclude.add((String)dataset.colObjects.get(c));
        }
        return columnsToExclude;
    }
}

