/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats.concurrent;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Pair;
import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.math.stats.concurrent.ConcurrentCorrelationTask;

public class ConcurrentCorrelation {
    private int nrThreads = Runtime.getRuntime().availableProcessors();

    public ConcurrentCorrelation() {
    }

    public ConcurrentCorrelation(int nrProcs) {
        this.nrThreads = nrProcs;
    }

    public double[][] pairwiseCorrelation(double[][] in) {
        int i;
        ExecutorService threadPool = Executors.newFixedThreadPool(this.nrThreads);
        ExecutorCompletionService<Pair<Integer, double[]>> pool = new ExecutorCompletionService<Pair<Integer, double[]>>(threadPool);
        double[] meanOfSamples = new double[in.length];
        for (i = 0; i < meanOfSamples.length; ++i) {
            meanOfSamples[i] = Descriptives.mean(in[i]);
        }
        for (i = 0; i < in.length; ++i) {
            ConcurrentCorrelationTask task = new ConcurrentCorrelationTask(in, meanOfSamples, i);
            pool.submit(task);
        }
        int returned = 0;
        double[][] correlationMatrix = new double[in.length][0];
        ProgressBar pb = new ProgressBar(in.length, "Calculation of correlation matrix: " + in.length + " x " + in.length);
        while (returned < in.length) {
            try {
                Pair result = (Pair)pool.take().get();
                if (result == null) continue;
                int rownr = (Integer)result.getLeft();
                if (rownr >= 0) {
                    double[] doubles = (double[])result.getRight();
                    correlationMatrix[rownr] = doubles;
                }
                result = null;
                ++returned;
                pb.iterate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int r = 1; r < correlationMatrix.length; ++r) {
            for (int c = 0; c < r; ++c) {
                correlationMatrix[r][c] = correlationMatrix[c][r];
            }
        }
        threadPool.shutdown();
        pb.close();
        return correlationMatrix;
    }

    public DoubleMatrix2D pairwiseCorrelationDoubleMatrix(double[][] in) {
        int i;
        ExecutorService threadPool = Executors.newFixedThreadPool(this.nrThreads);
        ExecutorCompletionService<Pair<Integer, double[]>> pool = new ExecutorCompletionService<Pair<Integer, double[]>>(threadPool);
        double[] meanOfSamples = new double[in.length];
        for (i = 0; i < meanOfSamples.length; ++i) {
            meanOfSamples[i] = Descriptives.mean(in[i]);
        }
        for (i = 0; i < in.length; ++i) {
            ConcurrentCorrelationTask task = new ConcurrentCorrelationTask(in, meanOfSamples, i);
            pool.submit(task);
        }
        int returned = 0;
        Object correlationMatrix = (long)in.length * (long)in.length > 0x7FFFFFFDL ? new DenseLargeDoubleMatrix2D(in.length, in.length) : new DenseDoubleMatrix2D(in.length, in.length);
        ProgressBar pb = new ProgressBar(in.length, "Calculation of correlation matrix: " + in.length + " x " + in.length);
        while (returned < in.length) {
            try {
                Pair result = (Pair)pool.take().get();
                if (result == null) continue;
                int rownr = (Integer)result.getLeft();
                if (rownr >= 0) {
                    double[] doubles = (double[])result.getRight();
                    for (int i2 = 0; i2 < doubles.length; ++i2) {
                        correlationMatrix.setQuick(rownr, i2, doubles[i2]);
                    }
                }
                result = null;
                ++returned;
                pb.iterate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int r = 1; r < correlationMatrix.rows(); ++r) {
            for (int c = 0; c < r; ++c) {
                correlationMatrix.setQuick(r, c, correlationMatrix.getQuick(c, r));
            }
        }
        threadPool.shutdown();
        pb.close();
        return correlationMatrix;
    }
}

