/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import JSci.maths.ArrayMath;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.RankingAlgorithm;
import org.apache.commons.math3.stat.ranking.TiesStrategy;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.util.RankArray;

public class QuantileNormalization {
    private static final RankingAlgorithm COV_RANKER_TIE = new NaturalRanking(NaNStrategy.FAILED, TiesStrategy.AVERAGE);

    public static void quantilenormalize(double[][] rawData) {
        System.out.println("\nPerforming quantile normalization:");
        SpearmansCorrelation spearman = new SpearmansCorrelation();
        int probeCount = rawData.length;
        int sampleCount = rawData[probeCount - 1].length;
        double[] rankedMean = new double[probeCount];
        for (int sampleID = 0; sampleID < sampleCount; ++sampleID) {
            int probeID;
            double[] x = new double[probeCount];
            for (probeID = 0; probeID < probeCount; ++probeID) {
                x[probeID] = rawData[probeID][sampleID];
            }
            Arrays.sort(x);
            for (probeID = 0; probeID < probeCount; ++probeID) {
                int n = probeID;
                rankedMean[n] = rankedMean[n] + x[probeID];
            }
        }
        int probeID = 0;
        while (probeID < probeCount) {
            int n = probeID++;
            rankedMean[n] = rankedMean[n] / (double)sampleCount;
        }
        double[] rankedMeanClasses = new double[probeCount - 1];
        for (int probeID2 = 0; probeID2 < probeCount - 1; ++probeID2) {
            rankedMeanClasses[probeID2] = (rankedMean[probeID2] + rankedMean[probeID2 + 1]) / 2.0;
        }
        for (int s = 0; s < sampleCount; ++s) {
            double[] probes = new double[probeCount];
            for (int p = 0; p < probeCount; ++p) {
                probes[p] = rawData[p][s];
            }
            double[] probesRanked = COV_RANKER_TIE.rank(probes);
            double[] probesQuantileNormalized = new double[probeCount];
            for (int p = 0; p < probeCount; ++p) {
                probesQuantileNormalized[p] = probesRanked[p] % 1.0 != 0.0 ? rankedMeanClasses[(int)Math.floor(probesRanked[p] - 1.0)] : rankedMean[(int)(probesRanked[p] - 1.0)];
                rawData[p][s] = probesQuantileNormalized[p];
            }
            System.out.println("Normalized sample:\t" + (s + 1) + "\tPearson correlation original data and ranked data:\t" + ArrayMath.correlation((double[])probes, (double[])probesRanked) + "\ttSpearman correlation original data and quantile normalized data:\t" + spearman.correlation(probes, probesQuantileNormalized));
        }
    }

    public static void QuantileNormAdressingNaValuesBeforeQN(double[][] rawData, boolean useMedian, boolean retainNA) {
        int s;
        boolean[][] wasNA = new boolean[rawData.length][rawData[1].length];
        for (s = 0; s < rawData[1].length; ++s) {
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            boolean needsReplacement = false;
            for (int p = 0; p < rawData.length; ++p) {
                if (rawData[p][s] == -999.0) {
                    needsReplacement = true;
                    wasNA[p][s] = true;
                    continue;
                }
                wasNA[p][s] = false;
                nonNAvalues.add(rawData[p][s]);
            }
            if (!needsReplacement) continue;
            double replacementValue = useMedian ? ArrayMath.median((double[])nonNAvalues.toArray(new double[0])) : ArrayMath.mean((double[])nonNAvalues.toArray(new double[0]));
            for (int p = 0; p < rawData.length; ++p) {
                if (!wasNA[p][s]) continue;
                rawData[p][s] = replacementValue;
            }
        }
        QuantileNormalization.quantilenormalize(rawData);
        if (retainNA) {
            for (s = 0; s < rawData[1].length; ++s) {
                for (int p = 0; p < rawData.length; ++p) {
                    if (!wasNA[p][s]) continue;
                    rawData[p][s] = -999.0;
                }
            }
        }
    }

    public static void QuantileNormAdressingNaValuesAfterInitialQN(DoubleMatrixDataset<String, String> dataset, boolean retainNA, boolean useRow, boolean keepZero) {
        int s;
        System.out.print("Pre-treating missing values:");
        ArrayList<ArrayDoubleList> dataForPretreatment = new ArrayList<ArrayDoubleList>();
        int maxNonNAvalues = Integer.MIN_VALUE;
        for (int s2 = 0; s2 < dataset.nrCols; ++s2) {
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            for (int p = 0; p < dataset.nrRows; ++p) {
                if (Double.isNaN(dataset.rawData[p][s2])) continue;
                nonNAvalues.add(dataset.rawData[p][s2]);
            }
            if (nonNAvalues.size() > maxNonNAvalues) {
                maxNonNAvalues = nonNAvalues.size();
            }
            dataForPretreatment.add(nonNAvalues);
        }
        double[][] dataSorted = new double[maxNonNAvalues][dataset.nrCols];
        for (int s3 = 0; s3 < dataset.nrCols; ++s3) {
            int p;
            double[] vals = new double[maxNonNAvalues];
            double meanPerSample = 0.0;
            if (((ArrayDoubleList)dataForPretreatment.get(s3)).size() > 0 && !keepZero) {
                meanPerSample = ArrayMath.mean((double[])((ArrayDoubleList)dataForPretreatment.get(s3)).toArray(new double[0]));
            }
            for (p = 0; p < maxNonNAvalues; ++p) {
                vals[p] = ((ArrayDoubleList)dataForPretreatment.get(s3)).size() > p ? ((ArrayDoubleList)dataForPretreatment.get(s3)).get(p) : meanPerSample;
            }
            Arrays.sort(vals);
            for (p = 0; p < vals.length; ++p) {
                dataSorted[p][s3] = vals[p];
            }
        }
        double[] dist = new double[maxNonNAvalues];
        for (int p = 0; p < maxNonNAvalues; ++p) {
            dist[p] = ArrayMath.mean((double[])dataSorted[p]);
        }
        dataSorted = null;
        System.out.println("done");
        System.out.println("Quantile normalization round (1)");
        SpearmansCorrelation spearman = new SpearmansCorrelation();
        for (s = 0; s < dataset.nrCols; ++s) {
            double[] vals1 = new double[((ArrayDoubleList)dataForPretreatment.get(s)).size()];
            RankArray rda = new RankArray();
            double[] valsRanked = rda.rank(((ArrayDoubleList)dataForPretreatment.get(s)).toArray(new double[0]), false);
            for (int v = 0; v < vals1.length; ++v) {
                double quantile = valsRanked[v] / (double)vals1.length;
                int distIndex = (int)(quantile * (double)maxNonNAvalues - 1.0);
                vals1[v] = dist[distIndex + 1];
            }
            System.out.println("Normalized sample:\t" + (String)dataset.colObjects.get(s) + "\t" + s + "\tCorrelation original data and ranked data:\t" + ArrayMath.correlation((double[])((ArrayDoubleList)dataForPretreatment.get(s)).toArray(new double[0]), (double[])valsRanked) + "\tCorrelation original data and quantile normalized data:\t" + ArrayMath.correlation((double[])((ArrayDoubleList)dataForPretreatment.get(s)).toArray(new double[0]), (double[])vals1) + "\t" + spearman.correlation(((ArrayDoubleList)dataForPretreatment.get(s)).toArray(new double[0]), vals1));
            int itr = 0;
            for (int p = 0; p < dataset.nrRows; ++p) {
                if (Double.isNaN(dataset.rawData[p][s])) continue;
                dataset.rawData[p][s] = vals1[itr];
                ++itr;
            }
        }
        if (!retainNA) {
            boolean foundNA;
            if (useRow) {
                for (int p = 0; p < dataset.nrRows; ++p) {
                    double valSum = 0.0;
                    int nr = 0;
                    foundNA = false;
                    for (int s4 = 0; s4 < dataset.nrCols; ++s4) {
                        if (!Double.isNaN(dataset.rawData[p][s4])) {
                            valSum += dataset.rawData[p][s4];
                            ++nr;
                            continue;
                        }
                        foundNA = true;
                    }
                    if (!foundNA) continue;
                    double mean = valSum / (double)nr;
                    for (int s5 = 0; s5 < dataset.nrCols; ++s5) {
                        if (!Double.isNaN(dataset.rawData[p][s5])) continue;
                        dataset.rawData[p][s5] = mean;
                    }
                }
            } else {
                for (s = 0; s < dataset.nrCols; ++s) {
                    double valSum = 0.0;
                    int nr = 0;
                    foundNA = false;
                    for (int p = 0; p < dataset.nrRows; ++p) {
                        if (!Double.isNaN(dataset.rawData[p][s])) {
                            valSum += dataset.rawData[p][s];
                            ++nr;
                            continue;
                        }
                        foundNA = true;
                    }
                    if (!foundNA) continue;
                    double mean = valSum / (double)nr;
                    for (int p = 0; p < dataset.nrRows; ++p) {
                        if (!Double.isNaN(dataset.rawData[p][s])) continue;
                        dataset.rawData[p][s] = mean;
                    }
                }
            }
            System.out.println("Quantile normalization round 2");
            QuantileNormalization.quantilenormalize(dataset.rawData);
        }
    }
}

