/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

public class Log2Transform {
    public static void log2transform(double[][] rawData) {
        double minValue = Double.MAX_VALUE;
        int probeCount = rawData.length;
        int sampleCount = rawData[probeCount - 1].length;
        for (int p = 0; p < probeCount; ++p) {
            for (int s = 0; s < sampleCount; ++s) {
                if (!(rawData[p][s] < minValue)) continue;
                minValue = rawData[p][s];
            }
        }
        System.out.println("\nLog2 transforming data: Absolute minimum Expression Value:\t" + minValue);
        double multiplier = 1.0 / Math.log10(2.0);
        for (int p = 0; p < probeCount; ++p) {
            for (int s = 0; s < sampleCount; ++s) {
                rawData[p][s] = minValue <= 0.0 ? Math.log10(rawData[p][s] - minValue + 1.0) * multiplier : Math.log10(rawData[p][s] + 1.0) * multiplier;
            }
        }
    }
}

